/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import krause.common.exception.ProcessingException;
import krause.util.PropertiesHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.device.IVNADriver;
import krause.vna.device.VNADriverFactoryDefaultProperties;

public class VNADriverFactory {
    public static final String DRIVER_PREFIX = "Drv.";
    public static final String HELPER_PREFIX = "MathHelper.";
    public static final String MENU_PREFIX = "Menu.";
    private static Properties properties = new Properties();
    private static VNADriverFactory singleton = null;
    private static Map<String, IVNADriver> driverMapByType = new HashMap<String, IVNADriver>();
    private static Map<String, IVNADriver> driverMapByClassName = new HashMap<String, IVNADriver>();
    private static Map<String, IVNADriver> driverMapByShortName = new HashMap<String, IVNADriver>();

    public List<String> getDriverClassnameList() {
        ArrayList<String> rc = new ArrayList<String>();
        Properties loc = PropertiesHelper.createProperties(properties, DRIVER_PREFIX);
        Enumeration<Object> keys = loc.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            rc.add(loc.getProperty(key));
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VNADriverFactory getSingleton() {
        if (singleton != null) return singleton;
        Class<VNADriverFactory> clazz = VNADriverFactory.class;
        synchronized (VNADriverFactory.class) {
            if (singleton != null) return singleton;
            try {
                singleton = new VNADriverFactory();
                singleton.load();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return singleton;
        }
    }

    private void load() {
        TraceHelper.entry(this, "load");
        properties.putAll((Map<?, ?>)PropertiesHelper.loadXMLProperties("drivers.xml", new VNADriverFactoryDefaultProperties()));
        List<String> drvList = this.getDriverClassnameList();
        for (String driverClassName : drvList) {
            try {
                IVNADriver driver = this.createDriverForClassname(driverClassName);
                driverMapByClassName.put(driverClassName, driver);
                driverMapByType.put(driver.getDeviceInfoBlock().getType(), driver);
                driverMapByShortName.put(driver.getDeviceInfoBlock().getShortName(), driver);
            }
            catch (ProcessingException processingException) {
                // empty catch block
            }
        }
        TraceHelper.exit(this, "load");
    }

    public IVNADriver getDriverForType(String vnaDriverType) throws ProcessingException {
        TraceHelper.entry((Object)this, "getDriverForType", vnaDriverType);
        IVNADriver driver = driverMapByType.get(vnaDriverType);
        TraceHelper.exit(this, "getDriverForType");
        return driver;
    }

    public IVNADriver getDriverForShortName(String name) throws ProcessingException {
        TraceHelper.entry((Object)this, "getDriverForShortName", name);
        IVNADriver driver = driverMapByShortName.get(name);
        TraceHelper.exitWithRC((Object)this, "getDriverForShortName", driver != null);
        return driver;
    }

    protected IVNADriver createDriverForClassname(String drvClassName) throws ProcessingException {
        TraceHelper.entry((Object)this, "createDriverForClassname", drvClassName);
        IVNADriver driver = driverMapByClassName.get(drvClassName);
        try {
            driver = (IVNADriver)Class.forName(drvClassName.trim()).newInstance();
        }
        catch (Exception e) {
            throw new ProcessingException(e);
        }
        TraceHelper.exit(this, "createDriverForClassname");
        return driver;
    }

    public List<IVNADriver> getDriverList() {
        ArrayList<IVNADriver> rc = new ArrayList<IVNADriver>();
        TraceHelper.entry(this, "getDriverList");
        for (Map.Entry<String, IVNADriver> ent : driverMapByClassName.entrySet()) {
            rc.add(ent.getValue());
        }
        TraceHelper.exit(this, "getDriverList");
        return rc;
    }
}

