/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import krause.common.TypedProperties;
import krause.vna.data.VNAScanMode;
import krause.vna.device.VNAScanModeParameter;
import org.apache.commons.math.complex.Complex;

public abstract class VNADeviceInfoBlock
implements Serializable {
    public static final int FILTER_MODE1 = 1;
    public static final int FILTER_MODE2 = 2;
    public static final int FILTER_NONE = 0;
    public static final int DEFAULT_FILTERMODE = 1;
    public static final int DEFAULT_LOCAL_TIMEOUT = 1000;
    public static final int DEFAULT_NOFSAMPLES = 2000;
    public static final double DEFAULT_REFERENCE_RESISTANCE_IMAG = 0.0;
    public static final double DEFAULT_REFERENCE_RESISTANCE_REAL = 50.0;
    public static final String DEFAULT_REMOTE_ADDRESS = "127.0.0.1";
    public static final int DEFAULT_REMOTE_PORT = 4444;
    public static final int DEFAULT_REMOTE_TIMEOUT = 10000;
    public static final long ONE_KHZ = 1000L;
    public static final long ONE_MHZ = 1000000L;
    public static final long ONE_GHZ = 1000000000L;
    public static final String PROPERTIES_DDSTicks = "ddsTicks";
    public static final String PROPERTIES_FILTERMODE = "filterMode";
    public static final String PROPERTIES_IP = "ip";
    public static final String PROPERTIES_LOCAL_TIMEOUT = "remoteTimeout";
    public static final String PROPERTIES_NUMBEROFSAMPLES = "nofSamples";
    public static final String PROPERTIES_PORT = "port";
    public static final String PROPERTIES_REFERENCE_RESISTANCE_IMAG = "referenceImag";
    public static final String PROPERTIES_REFERENCE_RESISTANCE_REAL = "referenceReal";
    public static final String PROPERTIES_REMOTE_TIMEOUT = "remoteTimeout";
    public static final String PROPERTIES_LOSS_MIN = "lossMin";
    public static final String PROPERTIES_LOSS_MAX = "lossMax";
    public static final String PROPERTIES_FREQUENCY_MAX = "freqMax";
    public static final String PROPERTIES_FREQUENCY_MIN = "freqMin";
    private long ddsTicksPerMHz;
    private int filterMode;
    private int localTimeout;
    private String longName;
    private long maxFrequency;
    private double maxLoss;
    private double maxPhase;
    private long minFrequency;
    private double minLoss;
    private double minPhase;
    private boolean networkDriver;
    private int numberOfSamples;
    private boolean peakSuppression;
    private Complex referenceResistance;
    private String remoteAddress;
    private int remotePort;
    private int remoteTimeout;
    private Map<VNAScanMode, VNAScanModeParameter> scanModeParameters = new HashMap<VNAScanMode, VNAScanModeParameter>();
    private String shortName;
    private String type;

    public void addScanModeParameter(VNAScanModeParameter pParm) {
        this.scanModeParameters.put(pParm.getMode(), pParm);
    }

    public void clearScanModeParameters() {
        this.scanModeParameters.clear();
    }

    public long getDdsTicksPerMHz() {
        return this.ddsTicksPerMHz;
    }

    public int getFilterMode() {
        return this.filterMode;
    }

    public int getLocalTimeout() {
        return this.localTimeout;
    }

    public String getLongName() {
        return this.longName;
    }

    public long getMaxFrequency() {
        return this.maxFrequency;
    }

    public double getMaxLoss() {
        return this.maxLoss;
    }

    public double getMaxPhase() {
        return this.maxPhase;
    }

    public long getMinFrequency() {
        return this.minFrequency;
    }

    public double getMinLoss() {
        return this.minLoss;
    }

    public double getMinPhase() {
        return this.minPhase;
    }

    public int getNumberOfSamples() {
        return this.numberOfSamples;
    }

    public Complex getReferenceResistance() {
        return this.referenceResistance;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public int getRemoteTimeout() {
        return this.remoteTimeout;
    }

    public VNAScanModeParameter getScanModeParameterForMode(VNAScanMode pScanMode) {
        return this.scanModeParameters.get(pScanMode);
    }

    public Map<VNAScanMode, VNAScanModeParameter> getScanModeParameters() {
        return this.scanModeParameters;
    }

    public String getShortName() {
        return this.shortName;
    }

    public long[] getSwitchPoints() {
        return null;
    }

    public String getType() {
        return this.type;
    }

    public boolean isNetworkDriver() {
        return this.networkDriver;
    }

    public boolean isPeakSuppression() {
        return this.peakSuppression;
    }

    public void reset() {
        this.filterMode = 1;
        this.localTimeout = 1000;
        this.remoteTimeout = 10000;
        this.remoteAddress = DEFAULT_REMOTE_ADDRESS;
        this.remotePort = 4444;
        this.numberOfSamples = 2000;
        this.networkDriver = false;
        this.peakSuppression = true;
        this.referenceResistance = new Complex(50.0, 0.0);
    }

    public abstract void restore(TypedProperties var1, String var2);

    public void setDdsTicksPerMHz(long ddsTicksPerMHz) {
        this.ddsTicksPerMHz = ddsTicksPerMHz;
    }

    public void setFilterMode(int filterMode) {
        this.filterMode = filterMode;
    }

    public void setLocalTimeout(int localTimeout) {
        this.localTimeout = localTimeout;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public void setMaxFrequency(long maxFrequency) {
        this.maxFrequency = maxFrequency;
    }

    public void setMaxLoss(double maxLoss) {
        this.maxLoss = maxLoss;
    }

    public void setMaxPhase(double maxPhase) {
        this.maxPhase = maxPhase;
    }

    public void setMinFrequency(long minFrequency) {
        this.minFrequency = minFrequency;
    }

    public void setMinLoss(double minLoss) {
        this.minLoss = minLoss;
    }

    public void setMinPhase(double minPhase) {
        this.minPhase = minPhase;
    }

    public void setNetworkDriver(boolean networkDriver) {
        this.networkDriver = networkDriver;
    }

    public void setNumberOfSamples(int numberOfSamples) {
        this.numberOfSamples = numberOfSamples;
    }

    public void setPeakSuppression(boolean pPeakSuppression) {
        this.peakSuppression = pPeakSuppression;
    }

    public void setReferenceResistance(Complex referenceResistance) {
        this.referenceResistance = referenceResistance;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public void setRemoteTimeout(int remoteTimeout) {
        this.remoteTimeout = remoteTimeout;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public abstract void store(TypedProperties var1, String var2);
}

