/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device;

import java.util.List;
import krause.common.exception.DialogNotImplementedException;
import krause.common.exception.InitializationException;
import krause.common.exception.ProcessingException;
import krause.common.validation.ValidationResults;
import krause.vna.background.IVNABackgroundTaskStatusListener;
import krause.vna.data.VNAFrequencyRange;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.VNAScanMode;
import krause.vna.device.IVNADriverMathHelper;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.device.VNAScanRange;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.calibrate.mode1.VNACalibrationRange;

public interface IVNADriver {
    public long calculateInternalFrequencyValue(long var1);

    public void destroy();

    public VNACalibrationRange[] getCalibrationRanges();

    public VNAScanMode getDefaultMode();

    public String getDeviceFirmwareInfo();

    public VNADeviceInfoBlock getDeviceInfoBlock();

    public Double getDeviceSupply();

    public Double getDeviceTemperature();

    public String getDriverConfigPrefix();

    public IVNADriverMathHelper getMathHelper();

    public List<String> getPortList() throws ProcessingException;

    public String getPortname();

    public VNACalibrationRange[] getSpecificCalibrationRanges();

    public void init() throws InitializationException;

    public boolean isScanSupported(int var1, VNAFrequencyRange var2, VNAScanMode var3);

    public VNASampleBlock scan(VNAScanMode var1, long var2, long var4, int var6, IVNABackgroundTaskStatusListener var7) throws ProcessingException;

    public void setPortname(String var1);

    public void showDriverDialog(VNAMainFrame var1);

    public void showDriverNetworkDialog(VNAMainFrame var1);

    public void showGeneratorDialog(VNAMainFrame var1) throws DialogNotImplementedException;

    public void startGenerator(long var1, long var3, int var5, int var6, int var7, int var8) throws ProcessingException;

    public void stopGenerator() throws ProcessingException;

    public ValidationResults validateScanRange(VNAScanRange var1);
}

