/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.data.reference;

import java.awt.Color;
import java.awt.Graphics;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.gui.scale.VNAGenericScale;

public class VNAReferenceDataHelper {
    public static void paint(Graphics g, VNAGenericScale scaleLeft, VNAGenericScale scaleRight, int width, int height, VNACalibratedSample[] resizedSamples) {
        int endIndex;
        TraceHelper.entry(VNAReferenceDataHelper.class, "paint");
        if (resizedSamples != null && (endIndex = resizedSamples.length) > 1) {
            TraceHelper.text(VNAReferenceDataHelper.class, "paint", "painting ...");
            Color color = VNAConfig.getSingleton().getColorReference();
            int lastX = 0;
            int lastY1 = 0;
            int currX = 0;
            while (currX < endIndex) {
                VNACalibratedSample currSample = resizedSamples[currX];
                if (currSample != null) {
                    int currY1 = scaleLeft.getScaledSampleValue(currSample, height);
                    g.setColor(color);
                    g.drawLine(lastX, lastY1, currX, currY1);
                    lastX = currX;
                    lastY1 = currY1;
                }
                ++currX;
            }
            TraceHelper.text(VNAReferenceDataHelper.class, "paint", "... done");
        }
        TraceHelper.exit(VNAReferenceDataHelper.class, "paint");
    }
}

