/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.data.helper;

import java.util.List;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.VNABaseSample;
import krause.vna.data.VNASampleBlock;

public class VNASampleBlockHelper {
    static final VNASampleBlockHelper instance = new VNASampleBlockHelper();

    public static VNASampleBlock calculateAverageSampleBlock(List<VNASampleBlock> blocks) {
        TraceHelper.entry(instance, "calculateAverageSampleBlock");
        VNASampleBlock rc = new VNASampleBlock();
        int numBlocks = blocks.size();
        TraceHelper.text(instance, "calculateAverageSampleBlock", "  blocks=" + numBlocks);
        if (numBlocks > 0) {
            VNASampleBlock firstBlock = blocks.get(0);
            int blockLen = firstBlock.getSamples().length;
            VNABaseSample[] samples = new VNABaseSample[blockLen];
            double deviceTemp = 0.0;
            for (VNASampleBlock block : blocks) {
                if (block.getDeviceTemperature() == null) continue;
                deviceTemp += block.getDeviceTemperature().doubleValue();
            }
            deviceTemp /= (double)numBlocks;
            int i = 0;
            while (i < blockLen) {
                VNABaseSample sumSample = new VNABaseSample();
                for (VNASampleBlock block : blocks) {
                    VNABaseSample curSample = block.getSamples()[i];
                    sumSample.setFrequency(curSample.getFrequency());
                    sumSample.setAngle(sumSample.getAngle() + curSample.getAngle());
                    sumSample.setLoss(sumSample.getLoss() + curSample.getLoss());
                    sumSample.setRss1(sumSample.getRss1() + curSample.getRss1());
                    sumSample.setRss2(sumSample.getRss2() + curSample.getRss2());
                    sumSample.setRss3(sumSample.getRss3() + curSample.getRss3());
                }
                sumSample.setAngle(sumSample.getAngle() / numBlocks);
                sumSample.setLoss(sumSample.getLoss() / numBlocks);
                sumSample.setRss1(sumSample.getRss1() / numBlocks);
                sumSample.setRss2(sumSample.getRss2() / numBlocks);
                sumSample.setRss3(sumSample.getRss3() / numBlocks);
                samples[i] = sumSample;
                ++i;
            }
            rc.setAnalyserType(firstBlock.getAnalyserType());
            rc.setMathHelper(firstBlock.getMathHelper());
            rc.setNumberOfSteps(firstBlock.getNumberOfSteps());
            rc.setSamples(samples);
            rc.setStartFrequency(firstBlock.getStartFrequency());
            rc.setStopFrequency(firstBlock.getStopFrequency());
            rc.setScanMode(firstBlock.getScanMode());
            rc.setDeviceTemperature(deviceTemp);
            rc.setNumberOfOverscans(numBlocks);
        }
        TraceHelper.exit(instance, "calculateAverageSampleBlock");
        return rc;
    }
}

