/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.data.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.NumberFormat;
import java.util.Arrays;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.LogManager;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.VNAScanMode;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.data.calibrated.VNACalibrationContext;
import krause.vna.data.calibrated.VNACalibrationPoint;
import krause.vna.data.calibrated.VNACalibrationPointHelper;
import krause.vna.device.IVNADriver;
import krause.vna.export.XLSRawExporter;
import krause.vna.gui.format.VNAFormatFactory;

public class VNACalibrationBlockHelper {
    static final VNACalibrationBlockHelper instance = new VNACalibrationBlockHelper();
    static final VNAConfig config = VNAConfig.getSingleton();

    public static boolean save(VNACalibrationBlock block, String myFileName) {
        boolean result;
        block18: {
            TraceHelper.entry(instance, "save");
            result = false;
            if (!myFileName.endsWith(".cal")) {
                myFileName = String.valueOf(myFileName) + ".cal";
            }
            TraceHelper.text(instance, "save", "Trying to write to [" + myFileName + "]");
            ObjectOutputStream encoder = null;
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(myFileName);
                    encoder = new ObjectOutputStream(fos);
                    encoder.writeObject("__V5");
                    encoder.writeObject(block.getAnalyserType());
                    encoder.writeObject(block.getComment());
                    encoder.writeObject(block.getStartFrequency());
                    encoder.writeObject(block.getStopFrequency());
                    encoder.writeObject(block.getNumberOfSteps());
                    encoder.writeObject(block.getNumberOfOverscans());
                    encoder.writeObject(block.getScanMode());
                    encoder.writeObject(block.getCalibrationData4Load());
                    encoder.writeObject(block.getCalibrationData4Open());
                    encoder.writeObject(block.getCalibrationData4Short());
                    encoder.writeObject(block.getCalibrationData4Loop());
                    block.setFile(new File(myFileName));
                    result = true;
                }
                catch (Exception e) {
                    ErrorLogHelper.exception(instance, "save", e);
                    ErrorLogHelper.text(instance, "save", e.getMessage());
                    try {
                        if (encoder != null) {
                            encoder.flush();
                            encoder.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        break block18;
                    }
                    catch (IOException e2) {
                        result = false;
                        ErrorLogHelper.exception(instance, "save", e2);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (encoder != null) {
                        encoder.flush();
                        encoder.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    result = false;
                    ErrorLogHelper.exception(instance, "save", e);
                }
                throw throwable;
            }
            try {
                if (encoder != null) {
                    encoder.flush();
                    encoder.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                result = false;
                ErrorLogHelper.exception(instance, "save", e);
            }
        }
        TraceHelper.exitWithRC((Object)instance, "save", result);
        return result;
    }

    public static VNACalibrationBlock load(File file, IVNADriver driver) throws ProcessingException {
        TraceHelper.entry(instance, "load");
        VNACalibrationBlock calBlock = null;
        String myFileName = file.getAbsolutePath();
        TraceHelper.text(instance, "load", "Trying to read from [" + myFileName + "]");
        ObjectInputStream decoder = null;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(myFileName);
                decoder = new ObjectInputStream(fis);
                calBlock = new VNACalibrationBlock();
                VNACalibrationBlockHelper.readHeader(decoder, calBlock);
                calBlock.setFile(file);
                calBlock.setMathHelper(driver.getMathHelper());
                calBlock.setCalibrationData4Load((VNASampleBlock)decoder.readObject());
                calBlock.setCalibrationData4Open((VNASampleBlock)decoder.readObject());
                calBlock.setCalibrationData4Short((VNASampleBlock)decoder.readObject());
                calBlock.setCalibrationData4Loop((VNASampleBlock)decoder.readObject());
                calBlock.calculateCalibrationTemperature();
                VNACalibrationContext calContext = calBlock.getMathHelper().createCalibrationContextForCalibrationPoints(calBlock);
                calBlock.getMathHelper().createCalibrationPoints(calContext, calBlock);
                if (config.isExportRawData()) {
                    XLSRawExporter.export(calBlock.getCalibrationPoints(), "loadedCalibrationData");
                }
            }
            catch (Exception e) {
                ErrorLogHelper.exception(instance, "load", e);
                throw new ProcessingException(e);
            }
        }
        finally {
            try {
                if (decoder != null) {
                    decoder.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                ErrorLogHelper.exception(instance, "load", e);
            }
        }
        TraceHelper.exit(instance, "load");
        return calBlock;
    }

    private static void readHeader(ObjectInputStream decoder, VNACalibrationBlock rc) throws IOException, ClassNotFoundException {
        TraceHelper.entry(instance, "readHeader");
        String at = (String)decoder.readObject();
        if ("__V5".equals(at)) {
            TraceHelper.text(instance, "readHeader", "New record type [" + at + "] detected");
            rc.setAnalyserType((String)decoder.readObject());
            rc.setComment((String)decoder.readObject());
            rc.setStartFrequency((Long)decoder.readObject());
            rc.setStopFrequency((Long)decoder.readObject());
            rc.setNumberOfSteps((Integer)decoder.readObject());
            rc.setNumberOfOverscans((Integer)decoder.readObject());
            rc.setScanMode((VNAScanMode)decoder.readObject());
        } else if ("__V4".equals(at)) {
            TraceHelper.text(instance, "readHeader", "New record type [" + at + "] detected");
            rc.setAnalyserType((String)decoder.readObject());
            rc.setComment((String)decoder.readObject());
            rc.setStartFrequency((Long)decoder.readObject());
            rc.setStopFrequency((Long)decoder.readObject());
            rc.setNumberOfSteps((Integer)decoder.readObject());
            rc.setNumberOfOverscans((Integer)decoder.readObject());
            rc.setScanMode((VNAScanMode)decoder.readObject());
        } else if ("__V3".equals(at)) {
            TraceHelper.text(instance, "readHeader", "New record type [" + at + "] detected");
            rc.setAnalyserType((String)decoder.readObject());
            rc.setComment("");
            rc.setStartFrequency((Long)decoder.readObject());
            rc.setStopFrequency((Long)decoder.readObject());
            rc.setNumberOfSteps((Integer)decoder.readObject());
            rc.setNumberOfOverscans((Integer)decoder.readObject());
            rc.setScanMode((VNAScanMode)decoder.readObject());
        } else if ("__V2".equals(at)) {
            TraceHelper.text(instance, "readHeader", "New record type [" + at + "] detected");
            rc.setAnalyserType((String)decoder.readObject());
            rc.setComment("");
            rc.setStartFrequency(((Integer)decoder.readObject()).intValue());
            rc.setStopFrequency(((Integer)decoder.readObject()).intValue());
            rc.setNumberOfSteps((Integer)decoder.readObject());
            rc.setNumberOfOverscans((Integer)decoder.readObject());
            rc.setScanMode((VNAScanMode)decoder.readObject());
        } else {
            TraceHelper.text(instance, "readHeader", "Old record type [" + at + "] detected");
            rc.setAnalyserType(at);
            rc.setComment("");
            rc.setStartFrequency(((Integer)decoder.readObject()).intValue());
            rc.setStopFrequency(((Integer)decoder.readObject()).intValue());
            rc.setNumberOfSteps((Integer)decoder.readObject());
            rc.setNumberOfOverscans(1);
            Boolean b = (Boolean)decoder.readObject();
            rc.setScanMode(b != false ? VNAScanMode.MODE_TRANSMISSION : VNAScanMode.MODE_REFLECTION);
        }
        TraceHelper.exit(instance, "readHeader");
    }

    public static VNACalibrationBlock loadHeader(File file) throws ProcessingException {
        TraceHelper.entry(instance, "loadHeader");
        VNACalibrationBlock rc = null;
        String myFileName = file.getAbsolutePath();
        TraceHelper.text(instance, "loadHeader", "Trying to read header from [" + myFileName + "]");
        ObjectInputStream decoder = null;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(myFileName);
                decoder = new ObjectInputStream(fis);
                rc = new VNACalibrationBlock();
                VNACalibrationBlockHelper.readHeader(decoder, rc);
                rc.setFile(file);
            }
            catch (Exception e) {
                ErrorLogHelper.exception(instance, "loadHeader", e);
                throw new ProcessingException(e);
            }
        }
        finally {
            try {
                if (decoder != null) {
                    decoder.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                ErrorLogHelper.exception(instance, "loadHeader", e);
            }
        }
        TraceHelper.exit(instance, "loadHeader");
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    public static VNACalibrationBlock createResizedCalibrationBlock(VNACalibrationBlock pMainCalibrationBlock, long pStartFreq, long pStopFreq, int targetSteps) {
        methodName = "createResizedCalibrationBlock";
        TraceHelper.entry(VNACalibrationBlockHelper.instance, "createResizedCalibrationBlock");
        TraceHelper.text(VNACalibrationBlockHelper.instance, "createResizedCalibrationBlock", "start=" + pStartFreq);
        TraceHelper.text(VNACalibrationBlockHelper.instance, "createResizedCalibrationBlock", "stop =" + pStopFreq);
        TraceHelper.text(VNACalibrationBlockHelper.instance, "createResizedCalibrationBlock", "steps=" + targetSteps);
        rc = new VNACalibrationBlock();
        if (pStartFreq < pMainCalibrationBlock.getStartFrequency()) {
            ErrorLogHelper.text(VNACalibrationBlockHelper.instance, "createResizedCalibrationBlock", "frequency [" + pStartFreq + "] too low for calibration source [" + pMainCalibrationBlock.getStartFrequency() + "]");
            return rc;
        }
        if (pStopFreq > pMainCalibrationBlock.getStopFrequency()) {
            ErrorLogHelper.text(VNACalibrationBlockHelper.instance, "createResizedCalibrationBlock", "frequency [" + pStopFreq + "] too high for calibration source [" + pMainCalibrationBlock.getStopFrequency() + "]");
            return rc;
        }
        rc.setStartFrequency(pStartFreq);
        rc.setStopFrequency(pStopFreq);
        rc.setNumberOfSteps(targetSteps);
        rc.setAnalyserType(pMainCalibrationBlock.getAnalyserType());
        rc.setMathHelper(pMainCalibrationBlock.getMathHelper());
        rc.setScanMode(pMainCalibrationBlock.getScanMode());
        rc.setTemperature(pMainCalibrationBlock.getTemperature());
        source = pMainCalibrationBlock.getCalibrationPoints();
        target = new VNACalibrationPoint[targetSteps];
        freqStep = (pStopFreq - pStartFreq) / (long)targetSteps;
        TraceHelper.text(VNACalibrationBlockHelper.instance, "createResizedCalibrationBlock", "freq step=" + freqStep);
        targetFreq = pStartFreq;
        sourceIndex = 0;
        sourceSteps = source.length;
        targetIndex = 0;
        ** GOTO lbl44
        {
            ++sourceIndex;
            do {
                if (sourceIndex < sourceSteps && source[sourceIndex].getFrequency() < targetFreq) continue block0;
                if (sourceIndex >= sourceSteps) {
                    sourceIndex = sourceSteps - 1;
                }
                if (source[sourceIndex].getFrequency() == targetFreq) {
                    target[targetIndex] = source[sourceIndex];
                    TraceHelper.text(VNACalibrationBlockHelper.instance, "createResizedCalibrationBlock", "assign " + sourceIndex + ">" + targetIndex + "  exact frequency match");
                } else {
                    p1 = source[sourceIndex - 1];
                    p2 = source[sourceIndex];
                    target[targetIndex] = VNACalibrationPointHelper.interpolate(p1, p2, targetFreq);
                    TraceHelper.text(VNACalibrationBlockHelper.instance, "createResizedCalibrationBlock", "assign " + sourceIndex + ">" + targetIndex + "  " + source[sourceIndex].getFrequency() + ">" + targetFreq);
                }
                targetFreq += freqStep;
                ++targetIndex;
lbl44:
                // 2 sources

            } while (targetIndex < targetSteps);
        }
        rc.setCalibrationPoints(target);
        TraceHelper.exit(VNACalibrationBlockHelper.instance, "createResizedCalibrationBlock");
        return rc;
    }

    public static void removeSwitchPoints(VNACalibrationPoint[] pPoints, long[] pSwitchPoints) {
        String methodName = "removeSwitchPoints";
        TraceHelper.entry(instance, "removeSwitchPoints");
        TraceHelper.text(instance, "removeSwitchPoints", "switchPoints=" + Arrays.toString(pSwitchPoints));
        if (pSwitchPoints != null) {
            if (config.isExportRawData()) {
                XLSRawExporter.export(pPoints, "calBlockBeforeCorrection");
            }
            int j = 0;
            while (j < pSwitchPoints.length) {
                long currSwitchPointFreq = pSwitchPoints[j];
                VNACalibrationPoint lastPoint = pPoints[0];
                int i = 1;
                while (i < pPoints.length - 1) {
                    VNACalibrationPoint currPoint = pPoints[i];
                    if (lastPoint.getFrequency() < currSwitchPointFreq && currPoint.getFrequency() >= currSwitchPointFreq) {
                        if (LogManager.getSingleton().isTracingEnabled()) {
                            NumberFormat nf = VNAFormatFactory.getFrequencyFormat();
                            TraceHelper.text(instance, "removeSwitchPoints", "switch point between " + i + " (" + nf.format(currPoint.getFrequency()) + ") and " + (i - 1) + " (" + nf.format(lastPoint.getFrequency()) + ")");
                        }
                        pPoints[i - 1].copy(pPoints[i - 2]);
                        pPoints[i].copy(pPoints[i - 2]);
                        pPoints[i + 1].copy(pPoints[i - 2]);
                        break;
                    }
                    lastPoint = currPoint;
                    ++i;
                }
                ++j;
            }
            if (config.isExportRawData()) {
                XLSRawExporter.export(pPoints, "calBlockAfterCorrection");
            }
        }
        TraceHelper.exit(instance, "removeSwitchPoints");
    }
}

