/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.data.helper;

import java.text.NumberFormat;
import java.util.Arrays;
import krause.util.ras.logging.LogManager;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.export.XLSRawExporter;
import krause.vna.gui.format.VNAFormatFactory;

public class VNACalibratedSampleHelper {
    static final VNACalibratedSampleHelper instance = new VNACalibratedSampleHelper();
    static final VNAConfig config = VNAConfig.getSingleton();

    public static VNACalibratedSample delta(VNACalibratedSample s1, VNACalibratedSample s2) {
        VNACalibratedSample rc = new VNACalibratedSample();
        rc.setFrequency(Math.abs(s1.getFrequency() - s2.getFrequency()));
        rc.setReflectionLoss(Math.abs(s1.getReflectionLoss() - s2.getReflectionLoss()));
        rc.setTransmissionLoss(Math.abs(s1.getTransmissionLoss() - s2.getTransmissionLoss()));
        rc.setReflectionPhase(Math.abs(s1.getReflectionPhase() - s2.getReflectionPhase()));
        rc.setTransmissionPhase(Math.abs(s1.getTransmissionPhase() - s2.getTransmissionPhase()));
        rc.setR(Math.abs(s1.getR() - s2.getR()));
        rc.setZ(Math.abs(s1.getZ() - s2.getZ()));
        rc.setX(Math.abs(s1.getX() - s2.getX()));
        return rc;
    }

    public static boolean blockMatchesCurrentConfig(VNACalibratedSampleBlock block, VNACalibrationBlock rcb) {
        boolean rc = false;
        TraceHelper.entry(instance, "blockMatchesCurrentConfig");
        if (block != null && block.getCalibratedSamples().length == rcb.getNumberOfSteps()) {
            rc = true;
        }
        TraceHelper.exit(instance, "blockMatchesCurrentConfig");
        return rc;
    }

    public static void removeSwitchPoints(VNACalibratedSample[] pSamples, long[] pSwitchPoints) {
        String methodName = "removeSwitchPoints";
        TraceHelper.entry((Object)instance, "removeSwitchPoints", "SwitchPoints=" + Arrays.toString(pSwitchPoints));
        if (config.isExportRawData()) {
            XLSRawExporter.export(pSamples, "samplesBeforeCorrection");
        }
        int j = 0;
        while (j < pSwitchPoints.length) {
            long currSwitchPointFreq = pSwitchPoints[j];
            VNACalibratedSample lastPoint = pSamples[0];
            int i = 2;
            while (i < pSamples.length - 1) {
                VNACalibratedSample currPoint = pSamples[i];
                if (lastPoint.getFrequency() < currSwitchPointFreq && currPoint.getFrequency() >= currSwitchPointFreq) {
                    if (LogManager.getSingleton().isTracingEnabled()) {
                        NumberFormat nf = VNAFormatFactory.getFrequencyFormat();
                        TraceHelper.text(instance, "removeSwitchPoints", "switch point between " + i + " (" + nf.format(currPoint.getFrequency()) + ") and " + (i - 1) + " (" + nf.format(lastPoint.getFrequency()) + ")");
                    }
                    pSamples[i - 1].copy(pSamples[i - 2]);
                    pSamples[i].copy(pSamples[i - 2]);
                    pSamples[i + 1].copy(pSamples[i - 2]);
                    break;
                }
                lastPoint = currPoint;
                ++i;
            }
            ++j;
        }
        if (config.isExportRawData()) {
            XLSRawExporter.export(pSamples, "samplesAfterCorrection");
        }
        TraceHelper.exit(instance, "removeSwitchPoints");
    }
}

