/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.data.fft.loni;

import krause.vna.data.fft.loni.NotPowerOf2Exception;
import krause.vna.data.fft.loni.NotSameArraySizeException;

public final class FastFourierTransform {
    public static void fastFT(double[][][] realArray, double[][][] imagArray, boolean direction) {
        int numOfFrame = 0;
        int numOfRow = 0;
        int numOfCol = 0;
        if (realArray != null) {
            numOfFrame = realArray.length;
            numOfRow = realArray[0].length;
            numOfCol = realArray[0][0].length;
        }
        int numOfFrameImag = 0;
        int numOfRowImag = 0;
        int numOfColImag = 0;
        if (imagArray != null) {
            numOfFrameImag = imagArray.length;
            numOfRowImag = imagArray[0].length;
            numOfColImag = imagArray[0][0].length;
        }
        double[] realRow = new double[numOfRow];
        double[] imagRow = new double[numOfRow];
        double[] realFrame = new double[numOfFrame];
        double[] imagFrame = new double[numOfFrame];
        try {
            int col;
            FastFourierTransform._checkSizeOfArray(numOfFrame, numOfRow, numOfCol, numOfFrameImag, numOfRowImag, numOfColImag);
            int numOfPowerInFrame = FastFourierTransform._checkPowerOf2(numOfFrame);
            int numOfPowerInRow = FastFourierTransform._checkPowerOf2(numOfRow);
            int numOfPowerInCol = FastFourierTransform._checkPowerOf2(numOfCol);
            int frame = 0;
            while (frame < numOfFrame) {
                int row = 0;
                while (row < numOfRow) {
                    FastFourierTransform._fastFT1D(realArray[frame][row], imagArray[frame][row], numOfPowerInCol, direction);
                    ++row;
                }
                ++frame;
            }
            frame = 0;
            while (frame < numOfFrame) {
                col = 0;
                while (col < numOfCol) {
                    int row = 0;
                    while (row < numOfRow) {
                        realRow[row] = realArray[frame][row][col];
                        imagRow[row] = imagArray[frame][row][col];
                        ++row;
                    }
                    FastFourierTransform._fastFT1D(realRow, imagRow, numOfPowerInRow, direction);
                    row = 0;
                    while (row < numOfRow) {
                        realArray[frame][row][col] = realRow[row];
                        imagArray[frame][row][col] = imagRow[row];
                        ++row;
                    }
                    ++col;
                }
                ++frame;
            }
            int row = 0;
            while (row < numOfRow) {
                col = 0;
                while (col < numOfCol) {
                    int frame2 = 0;
                    while (frame2 < numOfFrame) {
                        realFrame[frame2] = realArray[frame2][row][col];
                        imagFrame[frame2] = imagArray[frame2][row][col];
                        ++frame2;
                    }
                    FastFourierTransform._fastFT1D(realFrame, imagFrame, numOfPowerInFrame, direction);
                    frame2 = 0;
                    while (frame2 < numOfFrame) {
                        realArray[frame2][row][col] = realFrame[frame2];
                        imagArray[frame2][row][col] = imagFrame[frame2];
                        ++frame2;
                    }
                    ++col;
                }
                ++row;
            }
        }
        catch (NotSameArraySizeException e) {
            System.out.println("\n" + e);
            System.out.println("Warning: Please assign real and imaginary arrays with the same dimension");
        }
        catch (NotPowerOf2Exception e) {
            System.out.println("\n" + e);
            System.out.println("Warning: Please assign an array with the length equal to an integer power of 2");
        }
    }

    public static void fastFT(double[][] realArray, double[][] imagArray, boolean direction) {
        int numOfRow = 0;
        int numOfCol = 0;
        if (realArray != null) {
            numOfRow = realArray.length;
            numOfCol = realArray[0].length;
        }
        int numOfRowImag = 0;
        int numOfColImag = 0;
        if (imagArray != null) {
            numOfRowImag = imagArray.length;
            numOfColImag = imagArray[0].length;
        }
        double[] realRow = new double[numOfRow];
        double[] imagRow = new double[numOfRow];
        try {
            FastFourierTransform._checkSizeOfArray(numOfRow, numOfCol, numOfRowImag, numOfColImag);
            int numOfPowerInRow = FastFourierTransform._checkPowerOf2(numOfRow);
            int numOfPowerInCol = FastFourierTransform._checkPowerOf2(numOfCol);
            int row = 0;
            while (row < numOfRow) {
                FastFourierTransform._fastFT1D(realArray[row], imagArray[row], numOfPowerInCol, direction);
                ++row;
            }
            int col = 0;
            while (col < numOfCol) {
                int row2 = 0;
                while (row2 < numOfRow) {
                    realRow[row2] = realArray[row2][col];
                    imagRow[row2] = imagArray[row2][col];
                    ++row2;
                }
                FastFourierTransform._fastFT1D(realRow, imagRow, numOfPowerInRow, direction);
                row2 = 0;
                while (row2 < numOfRow) {
                    realArray[row2][col] = realRow[row2];
                    imagArray[row2][col] = imagRow[row2];
                    ++row2;
                }
                ++col;
            }
        }
        catch (NotSameArraySizeException e) {
            System.out.println("\n" + e);
            System.out.println("Warning: Please assign real and imaginary arrays with the same dimension");
        }
        catch (NotPowerOf2Exception e) {
            System.out.println("\n" + e);
            System.out.println("Warning: Please assign an array with the length equal to an integer power of 2");
        }
    }

    public static void fastFT(double[] realArray, double[] imagArray, boolean direction) {
        int numOfReal = 0;
        if (realArray != null) {
            numOfReal = realArray.length;
        }
        int numOfImag = 0;
        if (imagArray != null) {
            numOfImag = imagArray.length;
        }
        try {
            FastFourierTransform._checkSizeOfArray(numOfReal, numOfImag);
            int numOfPower = FastFourierTransform._checkPowerOf2(numOfReal);
            FastFourierTransform._fastFT1D(realArray, imagArray, numOfPower, direction);
        }
        catch (NotSameArraySizeException e) {
            System.out.println("\n" + e);
            System.out.println("Warning: Please assign real and imaginary arrays with the same dimension");
        }
        catch (NotPowerOf2Exception e) {
            System.out.println("\n" + e);
            System.out.println("Warning: Please assign an array with the length equal to an integer power of 2");
        }
    }

    private static void _checkSizeOfArray(int frameReal, int rowReal, int colReal, int frameImag, int rowImag, int colImag) throws NotSameArraySizeException {
        if (frameReal != frameImag || rowReal != rowImag || colReal != colImag) {
            throw new NotSameArraySizeException();
        }
    }

    private static void _checkSizeOfArray(int rowReal, int colReal, int rowImag, int colImag) throws NotSameArraySizeException {
        if (rowReal != rowImag || colReal != colImag) {
            throw new NotSameArraySizeException();
        }
    }

    private static void _checkSizeOfArray(int numOfReal, int numOfImag) throws NotSameArraySizeException {
        if (numOfReal != numOfImag) {
            throw new NotSameArraySizeException();
        }
    }

    private static int _checkPowerOf2(int index) throws NotPowerOf2Exception {
        if (index < 2) {
            throw new NotPowerOf2Exception(index);
        }
        if ((index & index - 1) != 0) {
            throw new NotPowerOf2Exception(index);
        }
        int i = 0;
        while ((index & 1 << i) == 0) {
            ++i;
        }
        return i;
    }

    private static void _fastFT1D(double[] real, double[] imag, int numOfPower, boolean direct) {
        int numOfPoint = real.length;
        int i2 = numOfPoint >> 1;
        int j2 = 0;
        int i = 0;
        while (i < numOfPoint - 1) {
            if (i < j2) {
                double tr = real[i];
                double ti = imag[i];
                real[i] = real[j2];
                imag[i] = imag[j2];
                real[j2] = tr;
                imag[j2] = ti;
            }
            int k2 = i2;
            while (k2 <= j2) {
                j2 -= k2;
                k2 >>= 1;
            }
            j2 += k2;
            ++i;
        }
        double c1 = -1.0;
        double c2 = 0.0;
        int l2 = 1;
        int l = 0;
        while (l < numOfPower) {
            int l1 = l2;
            l2 <<= 1;
            double u1 = 1.0;
            double u2 = 0.0;
            int j = 0;
            while (j < l1) {
                int i3 = j;
                while (i3 < numOfPoint) {
                    int i1 = i3 + l1;
                    double t1 = u1 * real[i1] - u2 * imag[i1];
                    double t2 = u1 * imag[i1] + u2 * real[i1];
                    real[i1] = real[i3] - t1;
                    imag[i1] = imag[i3] - t2;
                    int n = i3;
                    real[n] = real[n] + t1;
                    int n2 = i3;
                    imag[n2] = imag[n2] + t2;
                    i3 += l2;
                }
                double z = u1 * c1 - u2 * c2;
                u2 = u1 * c2 + u2 * c1;
                u1 = z;
                ++j;
            }
            c2 = Math.sqrt((1.0 - c1) / 2.0);
            if (direct) {
                c2 = -c2;
            }
            c1 = Math.sqrt((1.0 + c1) / 2.0);
            ++l;
        }
        if (direct) {
            i = 0;
            while (i < numOfPoint) {
                int n = i;
                real[n] = real[n] / (double)numOfPoint;
                int n3 = i++;
                imag[n3] = imag[n3] / (double)numOfPoint;
            }
        }
    }
}

