/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.data.fft;

import java.util.ArrayList;
import krause.common.math.FFT;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.calibrated.VNACalibratedSample;
import org.apache.commons.math.complex.Complex;

public class VNAFFTHelper {
    public static Complex[] createFFTDataPoints(VNACalibratedSample[] input) {
        int inputLen = input.length;
        int nx = (int)(Math.log(inputLen) / Math.log(2.0));
        if (1 << nx != inputLen) {
            ++nx;
        }
        int newLen = 1 << nx;
        Complex[] rc = new Complex[newLen];
        int i = 0;
        while (i < inputLen) {
            rc[i] = input[i].getRHO();
            ++i;
        }
        i = inputLen;
        while (i < newLen) {
            rc[i] = Complex.ZERO;
            ++i;
        }
        return rc;
    }

    public static Complex[] doIFFT(VNACalibratedSample[] calibratedSamples) {
        Complex[] fftIn = VNAFFTHelper.createFFTDataPoints(calibratedSamples);
        Complex[] rc = FFT.ifft(fftIn);
        return rc;
    }

    public static Complex[] doFFT(VNACalibratedSample[] calibratedSamples) {
        Complex[] fftIn = VNAFFTHelper.createFFTDataPoints(calibratedSamples);
        Complex[] rc = FFT.fft(fftIn);
        return rc;
    }

    public static double[] getABS(VNACalibratedSample[] inp) {
        double[] rc = new double[inp.length];
        int i = 0;
        while (i < inp.length) {
            double radian = inp[i].getReflectionPhase() * Math.PI / 180.0;
            double amplitude = Math.pow(10.0, inp[i].getReflectionLoss() / 20.0);
            double real = amplitude * Math.cos(radian);
            double imag = amplitude * Math.sin(radian);
            rc[i] = new Complex(real, imag).abs();
            ++i;
        }
        return rc;
    }

    public static double[] getABS(Complex[] inp) {
        double[] rc = new double[inp.length];
        int i = 0;
        while (i < inp.length) {
            rc[i] = inp[i].abs();
            ++i;
        }
        return rc;
    }

    public static int[] findPeaks(double[] input) {
        double currGradient;
        ArrayList<Integer> peakList = new ArrayList<Integer>();
        int inputLen = input.length;
        double[] gradient = new double[inputLen - 1];
        double lastY = input[0];
        int i = 1;
        while (i < inputLen) {
            double currY = input[i];
            currGradient = currY - lastY;
            if (Math.abs(currGradient) < 0.005) {
                currGradient = 0.0;
            }
            gradient[i - 1] = currGradient;
            lastY = currY;
            ++i;
        }
        int state = 0;
        int max = gradient.length;
        int i2 = 0;
        while (i2 < max) {
            currGradient = gradient[i2];
            switch (state) {
                case 0: {
                    if (!(currGradient > 0.0)) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if (!(currGradient < 0.0)) break;
                    peakList.add(new Integer(i2));
                    state = 0;
                }
            }
            ++i2;
        }
        int peakLen = peakList.size();
        int[] peaks = new int[peakLen];
        int i3 = 0;
        while (i3 < peakLen) {
            peaks[i3] = (Integer)peakList.get(i3);
            ++i3;
        }
        TraceHelper.exitWithRC(Class.class, "findPeaks", peakList);
        return peaks;
    }

    public static int[] findPeaks2(double[] fftAbs) {
        int[] rc = null;
        double min = Double.MIN_NORMAL;
        int minIdx = -1;
        int i = 0;
        while (i < fftAbs.length) {
            if (fftAbs[i] > min) {
                min = fftAbs[i];
                minIdx = i;
            }
            ++i;
        }
        if (minIdx != -1) {
            rc = new int[]{minIdx};
        }
        return rc;
    }

    public static Complex[] createFFTDataPoints2(VNACalibratedSample[] input) {
        int inputLen = input.length;
        int nx = (int)(Math.log(inputLen) / Math.log(2.0));
        if (1 << nx != inputLen) {
            ++nx;
        }
        int newLen = 1 << nx;
        Complex[] rc = new Complex[newLen];
        int i = 0;
        while (i < inputLen) {
            VNACalibratedSample orgPt = input[i];
            double radian = orgPt.getReflectionPhase() * Math.PI / 180.0;
            double amplitude = Math.pow(10.0, orgPt.getReflectionLoss() / 20.0);
            double real = amplitude * Math.cos(radian);
            double imag = amplitude * Math.sin(radian);
            rc[i] = new Complex(real, imag);
            ++i;
        }
        i = inputLen;
        while (i < newLen) {
            rc[i] = Complex.ZERO;
            ++i;
        }
        return rc;
    }
}

