/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.data.calibrated;

import java.io.Serializable;
import krause.vna.data.calibrated.VNACalibrationPoint;
import org.apache.commons.math.complex.Complex;

public class VNACalibrationPointHelper
implements Serializable {
    public static VNACalibrationPoint calculateMean(VNACalibrationPoint p1, VNACalibrationPoint p2) {
        Complex deltaE = new Complex((p1.getDeltaE().getReal() + p2.getDeltaE().getReal()) / 2.0, (p1.getDeltaE().getImaginary() + p2.getDeltaE().getImaginary()) / 2.0);
        Complex e00 = new Complex((p1.getE00().getReal() + p2.getE00().getReal()) / 2.0, (p1.getE00().getImaginary() + p2.getE00().getImaginary()) / 2.0);
        Complex e11 = new Complex((p1.getE11().getReal() + p2.getE11().getReal()) / 2.0, (p1.getE11().getImaginary() + p2.getE11().getImaginary()) / 2.0);
        double loss = (p1.getLoss() + p2.getLoss()) / 2.0;
        int rss1 = (p1.getRss1() + p2.getRss1()) / 2;
        int rss2 = (p1.getRss2() + p2.getRss2()) / 2;
        int rss3 = (p1.getRss3() + p2.getRss3()) / 2;
        long freq = (p1.getFrequency() + p2.getFrequency()) / 2L;
        VNACalibrationPoint rc = new VNACalibrationPoint();
        rc.setFrequency(freq);
        rc.setDeltaE(deltaE);
        rc.setE00(e00);
        rc.setE11(e11);
        rc.setLoss(loss);
        rc.setRss1(rss1);
        rc.setRss2(rss2);
        rc.setRss3(rss3);
        return rc;
    }

    public static double interpolate(double y1, double y2, long k1, long k2) {
        return y1 + (double)k1 * (y2 - y1) / (double)k2;
    }

    public static int interpolate(int y1, int y2, long k1, long k2) {
        return (int)((long)y1 + k1 * (long)(y2 - y1) / k2);
    }

    public static Complex interpolate(Complex c1, Complex c2, long k1, long k2) {
        if (c1 != null && c2 != null) {
            double real = VNACalibrationPointHelper.interpolate(c1.getReal(), c2.getReal(), k1, k2);
            double imag = VNACalibrationPointHelper.interpolate(c1.getImaginary(), c2.getImaginary(), k1, k2);
            return new Complex(real, imag);
        }
        return null;
    }

    public static VNACalibrationPoint interpolate(VNACalibrationPoint p1, VNACalibrationPoint p2, long f) {
        long f1 = p1.getFrequency();
        long f2 = p2.getFrequency();
        long K1 = f - f1;
        long K2 = f2 - f1;
        VNACalibrationPoint rc = new VNACalibrationPoint();
        rc.setFrequency(f);
        rc.setLoss(VNACalibrationPointHelper.interpolate(p1.getLoss(), p2.getLoss(), K1, K2));
        rc.setDeltaE(VNACalibrationPointHelper.interpolate(p1.getDeltaE(), p2.getDeltaE(), K1, K2));
        rc.setE00(VNACalibrationPointHelper.interpolate(p1.getE00(), p2.getE00(), K1, K2));
        rc.setE11(VNACalibrationPointHelper.interpolate(p1.getE11(), p2.getE11(), K1, K2));
        rc.setRss1(VNACalibrationPointHelper.interpolate(p1.getRss1(), p2.getRss1(), K1, K2));
        rc.setRss2(VNACalibrationPointHelper.interpolate(p1.getRss2(), p2.getRss2(), K1, K2));
        rc.setRss3(VNACalibrationPointHelper.interpolate(p1.getRss3(), p2.getRss3(), K1, K2));
        return rc;
    }
}

