/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.data.calibrated;

import java.io.Serializable;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.complex.ComplexFormat;

public class VNACalibrationPoint
implements Serializable {
    private long frequency = 0L;
    private Complex deltaE = null;
    private Complex e11 = null;
    private Complex e00 = null;
    private double loss = 0.0;
    private int rss1 = 0;
    private int rss2 = 0;
    private int rss3 = 0;

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }

    public Complex getDeltaE() {
        return this.deltaE;
    }

    public void setDeltaE(Complex deltaE) {
        this.deltaE = deltaE;
    }

    public Complex getE11() {
        return this.e11;
    }

    public void setE11(Complex e11) {
        this.e11 = e11;
    }

    public Complex getE00() {
        return this.e00;
    }

    public void setE00(Complex e00) {
        this.e00 = e00;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getDeltaE() != null) {
            sb.append("DeltaE");
            sb.append(ComplexFormat.getInstance().format((Object)this.getDeltaE()));
        }
        if (this.getE11() != null) {
            sb.append(", E11=");
            sb.append(ComplexFormat.getInstance().format((Object)this.getE11()));
        }
        if (this.getE00() != null) {
            sb.append(", E00=");
            sb.append(ComplexFormat.getInstance().format((Object)this.getE00()));
        }
        sb.append(", freq=");
        sb.append(this.frequency);
        sb.append(", loss=");
        sb.append(this.loss);
        sb.append(", rss1=");
        sb.append(this.rss1);
        sb.append(", rss2=");
        sb.append(this.rss2);
        sb.append(", rss3=");
        sb.append(this.rss3);
        return sb.toString();
    }

    public void setLoss(double loss) {
        this.loss = loss;
    }

    public double getLoss() {
        return this.loss;
    }

    public int getRss1() {
        return this.rss1;
    }

    public void setRss1(int rss1) {
        this.rss1 = rss1;
    }

    public int getRss2() {
        return this.rss2;
    }

    public void setRss2(int rss2) {
        this.rss2 = rss2;
    }

    public int getRss3() {
        return this.rss3;
    }

    public void setRss3(int rss3) {
        this.rss3 = rss3;
    }

    public void copy(VNACalibrationPoint pSource) {
        this.setDeltaE(pSource.getDeltaE());
        this.setE00(pSource.getE00());
        this.setE11(pSource.getE11());
        this.setLoss(pSource.getLoss());
        this.setRss1(pSource.getRss1());
        this.setRss2(pSource.getRss2());
        this.setRss3(pSource.getRss3());
    }
}

