/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.data.calibrated;

import java.io.File;
import java.util.List;
import krause.vna.data.VNAMinMaxPair;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.gui.scale.VNAScaleSymbols;
import org.jdom.Content;
import org.jdom.Element;

public class VNACalibratedSampleBlock {
    public static final String XML_NAME_COMMENT = "comment";
    public static final String XML_NAME_FREQ = "frequency-range";
    public static final String XML_NAME_MAX = "max";
    public static final String XML_NAME_MIN = "min";
    public static final String XML_NAME_MINMAX = "min-max-values";
    public static final String XML_NAME_ROOT = "vna-j-scandata";
    public static final String XML_NAME_SAMPLES = "samples";
    private String blockComment;
    private VNACalibratedSample[] calibratedSamples;
    private File file = null;
    private VNAMinMaxPair mmGroupDelay = new VNAMinMaxPair(VNAScaleSymbols.SCALE_TYPE.SCALE_GRPDLY);
    private VNAMinMaxPair mmRL = new VNAMinMaxPair(VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNLOSS);
    private VNAMinMaxPair mmRLPHASE = new VNAMinMaxPair(VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNPHASE);
    private VNAMinMaxPair mmRS = new VNAMinMaxPair(VNAScaleSymbols.SCALE_TYPE.SCALE_RS);
    private VNAMinMaxPair mmRSS = new VNAMinMaxPair(VNAScaleSymbols.SCALE_TYPE.SCALE_RSS);
    private VNAMinMaxPair mmSWR = new VNAMinMaxPair(VNAScaleSymbols.SCALE_TYPE.SCALE_SWR);
    private VNAMinMaxPair mmTheta = new VNAMinMaxPair(VNAScaleSymbols.SCALE_TYPE.SCALE_THETA);
    private VNAMinMaxPair mmTL = new VNAMinMaxPair(VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONLOSS);
    private VNAMinMaxPair mmTLPHASE = new VNAMinMaxPair(VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONPHASE);
    private VNAMinMaxPair mmXS = new VNAMinMaxPair(VNAScaleSymbols.SCALE_TYPE.SCALE_XS);
    private VNAMinMaxPair mmZABS = new VNAMinMaxPair(VNAScaleSymbols.SCALE_TYPE.SCALE_Z_ABS);

    public static VNACalibratedSampleBlock fromElement(Element root) {
        VNACalibratedSampleBlock rc = null;
        VNACalibratedSample[] samples = VNACalibratedSampleBlock.readDataElements(root);
        if (samples != null) {
            rc = new VNACalibratedSampleBlock(samples.length);
            rc.setComment(root.getChildText(XML_NAME_COMMENT));
            rc.setCalibratedSamples(samples);
            VNACalibratedSampleBlock.readMinMaxValueElements(rc, root);
        }
        return rc;
    }

    private static VNACalibratedSample[] readDataElements(Element root) {
        List samples;
        VNACalibratedSample[] rc = null;
        Element e = root.getChild(XML_NAME_SAMPLES);
        if (e != null && (samples = e.getChildren("sample")) != null) {
            int len = samples.size();
            if (len > 0) {
                rc = new VNACalibratedSample[len];
            }
            int i = 0;
            while (i < len) {
                rc[i] = VNACalibratedSample.fromElement((Element)samples.get(i));
                ++i;
            }
        }
        return rc;
    }

    private static void readMinMaxValueElements(VNACalibratedSampleBlock sb, Element root) {
        Element mms = root.getChild(XML_NAME_MINMAX);
        sb.setMmRP(VNAMinMaxPair.fromElement(mms, VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNPHASE.toString()));
        if (sb.getMmRP().getMinIndex() == -1) {
            sb.setMmRP(VNAMinMaxPair.fromElement(mms, "SCALE_PHASE"));
        }
        sb.setMmTP(VNAMinMaxPair.fromElement(mms, VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONPHASE.toString()));
        if (sb.getMmTP().getMinIndex() == -1) {
            sb.setMmTP(VNAMinMaxPair.fromElement(mms, "SCALE_PHASE"));
        }
        sb.setMmRL(VNAMinMaxPair.fromElement(mms, VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNLOSS.toString()));
        sb.setMmTL(VNAMinMaxPair.fromElement(mms, VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONLOSS.toString()));
        sb.setMmRS(VNAMinMaxPair.fromElement(mms, VNAScaleSymbols.SCALE_TYPE.SCALE_RS.toString()));
        sb.setMmRSS(VNAMinMaxPair.fromElement(mms, VNAScaleSymbols.SCALE_TYPE.SCALE_RSS.toString()));
        sb.setMmSWR(VNAMinMaxPair.fromElement(mms, VNAScaleSymbols.SCALE_TYPE.SCALE_SWR.toString()));
        sb.setMmTheta(VNAMinMaxPair.fromElement(mms, VNAScaleSymbols.SCALE_TYPE.SCALE_THETA.toString()));
        sb.setMmXS(VNAMinMaxPair.fromElement(mms, VNAScaleSymbols.SCALE_TYPE.SCALE_XS.toString()));
        sb.setMmZABS(VNAMinMaxPair.fromElement(mms, VNAScaleSymbols.SCALE_TYPE.SCALE_Z_ABS.toString()));
        sb.setMmGRPDLY(VNAMinMaxPair.fromElement(mms, VNAScaleSymbols.SCALE_TYPE.SCALE_GRPDLY.toString()));
    }

    public VNACalibratedSampleBlock(int listLength) {
        this.calibratedSamples = new VNACalibratedSample[listLength];
    }

    public Element asElement() {
        Element rc = new Element(XML_NAME_ROOT);
        Element minmax = new Element(XML_NAME_MINMAX);
        minmax.addContent((Content)this.getMmGRPDLY().asElement());
        minmax.addContent((Content)this.getMmRL().asElement());
        minmax.addContent((Content)this.getMmRP().asElement());
        minmax.addContent((Content)this.getMmTL().asElement());
        minmax.addContent((Content)this.getMmTP().asElement());
        minmax.addContent((Content)this.getMmRS().asElement());
        minmax.addContent((Content)this.getMmRSS().asElement());
        minmax.addContent((Content)this.getMmSWR().asElement());
        minmax.addContent((Content)this.getMmTheta().asElement());
        minmax.addContent((Content)this.getMmXS().asElement());
        minmax.addContent((Content)this.getMmZABS().asElement());
        rc.addContent((Content)minmax);
        Element fr = new Element(XML_NAME_FREQ);
        VNACalibratedSample[] samples = this.getCalibratedSamples();
        if (samples != null && samples.length > 0) {
            fr.addContent((Content)new Element(XML_NAME_MIN).setText("" + samples[0].getFrequency()));
            fr.addContent((Content)new Element(XML_NAME_MAX).setText("" + samples[samples.length - 1].getFrequency()));
        }
        rc.addContent((Content)fr);
        if (this.getComment() != null) {
            rc.addContent((Content)new Element(XML_NAME_COMMENT).setText(this.getComment()));
        }
        Element data = new Element(XML_NAME_SAMPLES);
        VNACalibratedSample[] ss = this.getCalibratedSamples();
        int i = 0;
        while (i < ss.length) {
            VNACalibratedSample s = ss[i];
            data.addContent((Content)s.asElement(i));
            ++i;
        }
        rc.addContent((Content)data);
        return rc;
    }

    public void consumeCalibratedSample(VNACalibratedSample sample, int index) {
        this.mmRL.consume(sample.getReflectionLoss(), index);
        this.mmTL.consume(sample.getTransmissionLoss(), index);
        this.mmRLPHASE.consume(sample.getReflectionPhase(), index);
        this.mmTLPHASE.consume(sample.getTransmissionPhase(), index);
        this.mmXS.consume(sample.getX(), index);
        this.mmRS.consume(sample.getR(), index);
        this.mmZABS.consume(sample.getZ(), index);
        this.mmSWR.consume(sample.getSWR(), index);
        this.mmRSS.consume(sample.getRelativeSignalStrength1(), index);
        this.mmTheta.consume(sample.getTheta(), index);
        this.mmGroupDelay.consume(sample.getGroupDelay(), index);
        this.calibratedSamples[index] = sample;
    }

    public String getBlockComment() {
        return this.blockComment;
    }

    public VNACalibratedSample[] getCalibratedSamples() {
        return this.calibratedSamples;
    }

    public String getComment() {
        return this.blockComment;
    }

    public File getFile() {
        return this.file;
    }

    public VNAMinMaxPair getMinMaxPair(VNAScaleSymbols.SCALE_TYPE key) {
        if (key == VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNPHASE) {
            return this.mmRLPHASE;
        }
        if (key == VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONPHASE) {
            return this.mmTLPHASE;
        }
        if (key == VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNLOSS) {
            return this.mmRL;
        }
        if (key == VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONLOSS) {
            return this.mmTL;
        }
        if (key == VNAScaleSymbols.SCALE_TYPE.SCALE_RS) {
            return this.mmRS;
        }
        if (key == VNAScaleSymbols.SCALE_TYPE.SCALE_RSS) {
            return this.mmRSS;
        }
        if (key == VNAScaleSymbols.SCALE_TYPE.SCALE_SWR) {
            return this.mmSWR;
        }
        if (key == VNAScaleSymbols.SCALE_TYPE.SCALE_THETA) {
            return this.mmTheta;
        }
        if (key == VNAScaleSymbols.SCALE_TYPE.SCALE_XS) {
            return this.mmXS;
        }
        if (key == VNAScaleSymbols.SCALE_TYPE.SCALE_Z_ABS) {
            return this.mmZABS;
        }
        if (key == VNAScaleSymbols.SCALE_TYPE.SCALE_GRPDLY) {
            return this.mmGroupDelay;
        }
        return null;
    }

    public VNAMinMaxPair getMmGRPDLY() {
        return this.mmGroupDelay;
    }

    public VNAMinMaxPair getMmRL() {
        return this.mmRL;
    }

    public VNAMinMaxPair getMmRP() {
        return this.mmRLPHASE;
    }

    public VNAMinMaxPair getMmRS() {
        return this.mmRS;
    }

    public VNAMinMaxPair getMmRSS() {
        return this.mmRSS;
    }

    public VNAMinMaxPair getMmSWR() {
        return this.mmSWR;
    }

    public VNAMinMaxPair getMmTheta() {
        return this.mmTheta;
    }

    public VNAMinMaxPair getMmTL() {
        return this.mmTL;
    }

    public VNAMinMaxPair getMmTP() {
        return this.mmTLPHASE;
    }

    public VNAMinMaxPair getMmXS() {
        return this.mmXS;
    }

    public VNAMinMaxPair getMmZABS() {
        return this.mmZABS;
    }

    public void setBlockComment(String blockComment) {
        this.blockComment = blockComment;
    }

    public void setCalibratedSamples(VNACalibratedSample[] calibratedSamples) {
        this.calibratedSamples = calibratedSamples;
    }

    public void setComment(String blockComment) {
        this.blockComment = blockComment;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setMmGRPDLY(VNAMinMaxPair mmGRPDLY) {
        this.mmGroupDelay = mmGRPDLY;
    }

    public void setMmRL(VNAMinMaxPair mmRL) {
        this.mmRL = mmRL;
    }

    public void setMmRP(VNAMinMaxPair mmPHASE) {
        this.mmRLPHASE = mmPHASE;
    }

    public void setMmRS(VNAMinMaxPair mmRS) {
        this.mmRS = mmRS;
    }

    public void setMmRSS(VNAMinMaxPair mmRSS) {
        this.mmRSS = mmRSS;
    }

    public void setMmSWR(VNAMinMaxPair mmSWR) {
        this.mmSWR = mmSWR;
    }

    public void setMmTheta(VNAMinMaxPair mmTheta) {
        this.mmTheta = mmTheta;
    }

    public void setMmTL(VNAMinMaxPair mmTL) {
        this.mmTL = mmTL;
    }

    public void setMmTP(VNAMinMaxPair mmTLPHASE) {
        this.mmTLPHASE = mmTLPHASE;
    }

    public void setMmXS(VNAMinMaxPair mmXS) {
        this.mmXS = mmXS;
    }

    public void setMmZABS(VNAMinMaxPair mmZABS) {
        this.mmZABS = mmZABS;
    }
}

