/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.data.calibrated;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.HashSet;
import krause.util.ras.logging.ErrorLogHelper;
import krause.vna.gui.scale.VNAScaleSymbols;
import org.apache.commons.math.complex.Complex;
import org.jdom.Content;
import org.jdom.Element;

public class VNACalibratedSample
implements Serializable {
    private static HashSet<String> beanNames = new HashSet<String>(){};
    private static final long serialVersionUID = -231006451669990001L;
    public static final String XML_NAME_SAMPLE = "sample";
    private static final String XML_NAME_SAMPLE_FREQ = "frequency";
    private static final String XML_NAME_SAMPLE_GRPDEL = "Tgr";
    private static final String XML_NAME_SAMPLE_INDEX = "index";
    private static final String XML_NAME_SAMPLE_MAG = "magnitude";
    private static final String XML_NAME_SAMPLE_R = "r";
    private static final String XML_NAME_SAMPLE_RL = "reflectionloss";
    private static final String XML_NAME_SAMPLE_RP = "reflectionphase";
    private static final String XML_NAME_SAMPLE_RSS1 = "rss1";
    private static final String XML_NAME_SAMPLE_RSS2 = "rss2";
    private static final String XML_NAME_SAMPLE_RSS3 = "rss3";
    private static final String XML_NAME_SAMPLE_SWR = "swr";
    private static final String XML_NAME_SAMPLE_THETA = "theta";
    private static final String XML_NAME_SAMPLE_TL = "transmissionloss";
    private static final String XML_NAME_SAMPLE_TP = "transmissionphase";
    private static final String XML_NAME_SAMPLE_X = "x";
    private static final String XML_NAME_SAMPLE_Z = "z";
    private transient int diagramX = 0;
    private long frequency = 0L;
    private double groupDelay = 0.0;
    private double mag = 0.0;
    private double R = 0.0;
    private double reflectionLoss = 0.0;
    private double reflectionPhase = 0.0;
    private double RelativeSignalStrength1 = 0.0;
    private double RelativeSignalStrength2 = 0.0;
    private double RelativeSignalStrength3 = 0.0;
    private transient Complex RHO = null;
    private double SWR = 0.0;
    private double Theta = 0.0;
    private double transmissionLoss = 0.0;
    private double transmissionPhase = 0.0;
    private double X = 0.0;
    private double z = 0.0;
    private transient Complex zComplex50Ohms = null;

    public static VNACalibratedSample fromElement(Element e) {
        VNACalibratedSample rc = new VNACalibratedSample();
        long index = VNACalibratedSample.getLongFromElement(e, XML_NAME_SAMPLE_INDEX);
        rc.setFrequency(VNACalibratedSample.getLongFromElement(e, XML_NAME_SAMPLE_FREQ));
        rc.setMag(VNACalibratedSample.getDoubleFromElement(e, XML_NAME_SAMPLE_MAG));
        rc.setReflectionLoss(VNACalibratedSample.getDoubleFromElement(e, XML_NAME_SAMPLE_RL));
        rc.setReflectionPhase(VNACalibratedSample.getDoubleFromElement(e, XML_NAME_SAMPLE_RP));
        rc.setTransmissionLoss(VNACalibratedSample.getDoubleFromElement(e, XML_NAME_SAMPLE_TL));
        rc.setTransmissionPhase(VNACalibratedSample.getDoubleFromElement(e, XML_NAME_SAMPLE_TP));
        rc.setR(VNACalibratedSample.getDoubleFromElement(e, XML_NAME_SAMPLE_R));
        rc.setRelativeSignalStrength1(VNACalibratedSample.getDoubleFromElement(e, XML_NAME_SAMPLE_RSS1));
        rc.setRelativeSignalStrength2(VNACalibratedSample.getDoubleFromElement(e, XML_NAME_SAMPLE_RSS2));
        rc.setRelativeSignalStrength3(VNACalibratedSample.getDoubleFromElement(e, XML_NAME_SAMPLE_RSS3));
        rc.setSWR(VNACalibratedSample.getDoubleFromElement(e, XML_NAME_SAMPLE_SWR));
        rc.setTheta(VNACalibratedSample.getDoubleFromElement(e, XML_NAME_SAMPLE_THETA));
        rc.setX(VNACalibratedSample.getDoubleFromElement(e, XML_NAME_SAMPLE_X));
        rc.setZ(VNACalibratedSample.getDoubleFromElement(e, XML_NAME_SAMPLE_Z));
        return rc;
    }

    private static double getDoubleFromElement(Element e, String name) {
        String t;
        double rc = 0.0;
        if (e != null && (t = e.getChildText(name)) != null && !"".equals(t)) {
            rc = Double.parseDouble(t);
        }
        return rc;
    }

    private static long getLongFromElement(Element e, String name) {
        String t;
        long rc = 0L;
        if (e != null && (t = e.getChildText(name)) != null && !"".equals(t)) {
            rc = Long.parseLong(t);
        }
        return rc;
    }

    private static void setupBeanInfo() {
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(VNACalibratedSample.class);
            PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
            int i = 0;
            while (i < propertyDescriptors.length) {
                PropertyDescriptor pd = propertyDescriptors[i];
                if (beanNames.contains(pd.getName())) {
                    pd.setValue("transient", Boolean.TRUE);
                }
                ++i;
            }
        }
        catch (IntrospectionException e) {
            ErrorLogHelper.exception("", "setupBeanInfo", e);
        }
    }

    public VNACalibratedSample() {
        beanNames.add("RHO");
        beanNames.add("ZComplex50Ohms");
        beanNames.add("DiagramX");
        VNACalibratedSample.setupBeanInfo();
    }

    public void copy(VNACalibratedSample pSource) {
        this.setGroupDelay(pSource.getGroupDelay());
        this.setMag(pSource.getMag());
        this.setR(pSource.getR());
        this.setReflectionLoss(pSource.getReflectionLoss());
        this.setReflectionPhase(pSource.getReflectionPhase());
        this.setRelativeSignalStrength1(pSource.getRelativeSignalStrength1());
        this.setRelativeSignalStrength2(pSource.getRelativeSignalStrength2());
        this.setRelativeSignalStrength3(pSource.getRelativeSignalStrength3());
        this.setRHO(pSource.getRHO());
        this.setSWR(pSource.getSWR());
        this.setTheta(pSource.getTheta());
        this.setTransmissionLoss(pSource.getTransmissionLoss());
        this.setTransmissionPhase(pSource.getTransmissionPhase());
        this.setX(pSource.getX());
        this.setZ(pSource.getZ());
        this.setZComplex50Ohms(pSource.getZComplex50Ohms());
    }

    public Element asElement(int index) {
        Element rc = new Element(XML_NAME_SAMPLE);
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_INDEX).setText(Long.toString(index)));
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_FREQ).setText(Long.toString(this.getFrequency())));
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_MAG).setText(Double.toString(this.getMag())));
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_R).setText(Double.toString(this.getR())));
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_RSS1).setText(Double.toString(this.getRelativeSignalStrength1())));
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_RSS2).setText(Double.toString(this.getRelativeSignalStrength2())));
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_RSS3).setText(Double.toString(this.getRelativeSignalStrength3())));
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_RL).setText(Double.toString(this.getReflectionLoss())));
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_RP).setText(Double.toString(this.getReflectionPhase())));
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_TL).setText(Double.toString(this.getTransmissionLoss())));
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_TP).setText(Double.toString(this.getTransmissionPhase())));
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_THETA).setText(Double.toString(this.getTheta())));
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_SWR).setText(Double.toString(this.getSWR())));
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_X).setText(Double.toString(this.getX())));
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_Z).setText(Double.toString(this.getZ())));
        rc.addContent((Content)new Element(XML_NAME_SAMPLE_GRPDEL).setText(Double.toString(this.getGroupDelay())));
        return rc;
    }

    public double getDataByScaleType(VNAScaleSymbols.SCALE_TYPE type) {
        if (type == VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNPHASE) {
            return this.reflectionPhase;
        }
        if (type == VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONPHASE) {
            return this.transmissionPhase;
        }
        if (type == VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONLOSS) {
            return this.transmissionLoss;
        }
        if (type == VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNLOSS) {
            return this.reflectionLoss;
        }
        if (type == VNAScaleSymbols.SCALE_TYPE.SCALE_RSS) {
            return this.RelativeSignalStrength1;
        }
        if (type == VNAScaleSymbols.SCALE_TYPE.SCALE_RS) {
            return this.R;
        }
        if (type == VNAScaleSymbols.SCALE_TYPE.SCALE_SWR) {
            return this.SWR;
        }
        if (type == VNAScaleSymbols.SCALE_TYPE.SCALE_THETA) {
            return this.Theta;
        }
        if (type == VNAScaleSymbols.SCALE_TYPE.SCALE_XS) {
            return this.X;
        }
        if (type == VNAScaleSymbols.SCALE_TYPE.SCALE_Z_ABS) {
            return this.z;
        }
        if (type == VNAScaleSymbols.SCALE_TYPE.SCALE_GRPDLY) {
            return this.groupDelay;
        }
        return 0.0;
    }

    public int getDiagramX() {
        return this.diagramX;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public double getGroupDelay() {
        return this.groupDelay;
    }

    public double getMag() {
        return this.mag;
    }

    public double getR() {
        return this.R;
    }

    public double getReflectionLoss() {
        return this.reflectionLoss;
    }

    public double getReflectionPhase() {
        return this.reflectionPhase;
    }

    public double getRelativeSignalStrength1() {
        return this.RelativeSignalStrength1;
    }

    public double getRelativeSignalStrength2() {
        return this.RelativeSignalStrength2;
    }

    public double getRelativeSignalStrength3() {
        return this.RelativeSignalStrength3;
    }

    public Complex getRHO() {
        return this.RHO;
    }

    public double getSWR() {
        return this.SWR;
    }

    public double getTheta() {
        return this.Theta;
    }

    public double getTransmissionLoss() {
        return this.transmissionLoss;
    }

    public double getTransmissionPhase() {
        return this.transmissionPhase;
    }

    public double getX() {
        return this.X;
    }

    public double getZ() {
        return this.z;
    }

    public Complex getZComplex50Ohms() {
        return this.zComplex50Ohms;
    }

    public void setDiagramX(int diagramX) {
        this.diagramX = diagramX;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }

    public void setGroupDelay(double groupDelay) {
        this.groupDelay = groupDelay;
    }

    public void setMag(double mAG) {
        this.mag = mAG;
    }

    public void setR(double r) {
        this.R = r;
    }

    public void setReflectionLoss(double reflectionLoss) {
        this.reflectionLoss = reflectionLoss;
    }

    public void setReflectionPhase(double phase) {
        this.reflectionPhase = phase;
    }

    public void setRelativeSignalStrength1(double relativeSignalStrength1) {
        this.RelativeSignalStrength1 = relativeSignalStrength1;
    }

    public void setRelativeSignalStrength2(double relativeSignalStrength2) {
        this.RelativeSignalStrength2 = relativeSignalStrength2;
    }

    public void setRelativeSignalStrength3(double relativeSignalStrength3) {
        this.RelativeSignalStrength3 = relativeSignalStrength3;
    }

    public void setRHO(Complex rHO) {
        this.RHO = rHO;
    }

    public void setSWR(double sWR) {
        this.SWR = sWR;
    }

    public void setTheta(double theta) {
        this.Theta = theta;
    }

    public void setTransmissionLoss(double transmissionLoss) {
        this.transmissionLoss = transmissionLoss;
    }

    public void setTransmissionPhase(double transmissionPhase) {
        this.transmissionPhase = transmissionPhase;
    }

    public void setX(double x) {
        this.X = x;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setZComplex50Ohms(Complex zComplex50Ohms) {
        this.zComplex50Ohms = zComplex50Ohms;
    }
}

