/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.VNAFrequencyRange;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.VNAScanMode;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.data.observer.VNADataPoolObserver;
import krause.vna.data.observer.VNAObserver;
import krause.vna.data.reference.VNAReferenceDataBlock;
import krause.vna.device.IVNADriver;

public class VNADataPool {
    public static final String PROPERTIES_PREFIX = "VNADeviceConfig.";
    public static final String PROPERTIES_START_FREQUENCY = "VNADeviceConfig.StartFrequency";
    public static final String PROPERTIES_STOP_FREQUENCY = "VNADeviceConfig.StopFrequency";
    public static final String PROPERTIES_TRANSMISSION_MODE = "VNADeviceConfig.TransmissionMode";
    public static final String KEY_FREQUENCYRANGE = "frequencyRange";
    public static final String KEY_SCANMODE = "scanMode";
    public static final String KEY_DEVICETYPE = "deviceType";
    public static final String KEY_RESIZED_CALBLK = "resizedCalibrationBlock";
    public static final String KEY_MAIN_CALBLK = "mainCalibrationBlock";
    public static final String KEY_MAIN_REFLECTION_CALBLK = "mainCalibrationBlockReflection";
    private static VNADataPool singleton = null;
    private Map<String, List<VNAObserver>> observerMap = new HashMap<String, List<VNAObserver>>();
    private IVNADriver driver = null;
    private VNACalibrationBlock resizedCalibrationBlock = null;
    private VNACalibrationBlock mainCalibrationBlock = null;
    private Map<String, VNACalibrationBlock> mainCalibrationBlocks = new HashMap<String, VNACalibrationBlock>();
    private VNAFrequencyRange frequencyRange = null;
    private VNAScanMode scanMode = null;
    private String deviceType = null;
    private VNASampleBlock rawData = null;
    private VNACalibratedSampleBlock calibratedData = null;
    private VNAReferenceDataBlock referenceData = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VNADataPool getSingleton() {
        if (singleton != null) return singleton;
        Class<VNADataPool> clazz = VNADataPool.class;
        synchronized (VNADataPool.class) {
            if (singleton != null) return singleton;
            try {
                singleton = new VNADataPool();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VNADataPool init(VNAConfig pConfig) {
        if (singleton != null) return singleton;
        Class<VNADataPool> clazz = VNADataPool.class;
        synchronized (VNADataPool.class) {
            if (singleton != null) return singleton;
            try {
                singleton = new VNADataPool();
                singleton.load(pConfig);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return singleton;
        }
    }

    protected VNADataPool() {
        TraceHelper.entry(this, "VNADataPool");
        TraceHelper.exit(this, "VNADataPool");
    }

    public void addObserver(String key, VNAObserver obs) {
        List<VNAObserver> observers = this.observerMap.get(key);
        if (observers == null) {
            observers = new ArrayList<VNAObserver>();
            this.observerMap.put(key, observers);
        }
        observers.add(obs);
    }

    public void clearCalibrationBlocks() {
        TraceHelper.entry(this, "clearCalibrationBlocks");
        if (this.mainCalibrationBlock != null) {
            this.mainCalibrationBlock = null;
            this.mainCalibrationBlock = null;
        }
        if (this.mainCalibrationBlocks != null) {
            this.mainCalibrationBlocks.clear();
        }
        TraceHelper.exit(this, "clearCalibrationBlocks");
    }

    public VNACalibratedSampleBlock getCalibratedData() {
        return this.calibratedData;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public IVNADriver getDriver() {
        return this.driver;
    }

    public VNAFrequencyRange getFrequencyRange() {
        return this.frequencyRange;
    }

    public VNACalibrationBlock getMainCalibrationBlock() {
        return this.mainCalibrationBlock;
    }

    public VNACalibrationBlock getMainCalibrationBlockForMode(VNAScanMode mode) {
        return this.mainCalibrationBlocks.get(mode.key());
    }

    public Map<String, VNACalibrationBlock> getMainCalibrationBlocks() {
        return this.mainCalibrationBlocks;
    }

    public VNASampleBlock getRawData() {
        return this.rawData;
    }

    public VNAReferenceDataBlock getReferenceData() {
        return this.referenceData;
    }

    public VNACalibrationBlock getResizedCalibrationBlock() {
        return this.resizedCalibrationBlock;
    }

    public VNAScanMode getScanMode() {
        return this.scanMode;
    }

    private void load(VNAConfig pConfig) {
        TraceHelper.entry(this, "load");
        this.frequencyRange = new VNAFrequencyRange(pConfig.getLong(PROPERTIES_START_FREQUENCY, 1000000L), pConfig.getLong(PROPERTIES_STOP_FREQUENCY, 180000000L));
        int sm = pConfig.getInteger(PROPERTIES_TRANSMISSION_MODE, -1);
        if (sm != -1) {
            this.scanMode = new VNAScanMode(sm);
        }
        this.deviceType = pConfig.getVNADriverType();
        TraceHelper.exit(this, "load");
    }

    public void removeObserver(String key, VNADataPoolObserver obs) {
        List<VNAObserver> observers = this.observerMap.get(key);
        if (observers != null) {
            this.observerMap.remove(key);
        }
    }

    public void save(VNAConfig pConfig) {
        TraceHelper.entry(this, "save");
        pConfig.putLong(PROPERTIES_START_FREQUENCY, this.frequencyRange.getStart());
        pConfig.putLong(PROPERTIES_STOP_FREQUENCY, this.frequencyRange.getStop());
        if (this.scanMode != null) {
            pConfig.putInteger(PROPERTIES_TRANSMISSION_MODE, this.scanMode.getMode());
        }
        pConfig.setVNADriverType(this.deviceType);
        TraceHelper.exit(this, "save");
    }

    public void setCalibratedData(VNACalibratedSampleBlock calibratedData) {
        this.calibratedData = calibratedData;
    }

    public void clearCalibratedData() {
        this.calibratedData = null;
    }

    public void setDeviceType(String newDeviceType) {
        this.deviceType = newDeviceType;
    }

    public void setDriver(IVNADriver driver) {
        this.driver = driver;
    }

    public void setFrequencyRange(long start, long stop) {
        this.setFrequencyRange(new VNAFrequencyRange(start, stop));
    }

    public void setFrequencyRange(VNAFrequencyRange pNewFrequencyRange) {
        this.frequencyRange = pNewFrequencyRange;
    }

    public void setMainCalibrationBlock(VNACalibrationBlock newMainCalibrationBlock) {
        TraceHelper.entry(this, "setMainCalibrationBlock");
        this.mainCalibrationBlock = newMainCalibrationBlock;
        TraceHelper.exit(this, "setMainCalibrationBlock");
    }

    public void setMainCalibrationBlockForMode(VNACalibrationBlock mcb) {
        TraceHelper.entry((Object)this, "setMainCalibrationBlockForMode", mcb.getScanMode().key());
        this.mainCalibrationBlocks.put(mcb.getScanMode().key(), mcb);
        TraceHelper.exit(this, "setMainCalibrationBlockForMode");
    }

    public void setRawData(VNASampleBlock rawData) {
        this.rawData = rawData;
    }

    public void setReferenceData(VNAReferenceDataBlock referenceData) {
        this.referenceData = referenceData;
    }

    public void setResizedCalibrationBlock(VNACalibrationBlock newResizedCalibrationBlock) {
        this.resizedCalibrationBlock = newResizedCalibrationBlock;
    }

    public void clearResizedCalibrationBlock() {
        this.resizedCalibrationBlock = null;
    }

    public void setScanMode(VNAScanMode newMode) {
        this.scanMode = newMode;
    }
}

