/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.data;

import java.io.Serializable;
import org.apache.commons.math.complex.Complex;

public class VNABaseSample
implements Serializable {
    private static final long serialVersionUID = -2310064516688896620L;
    private int angle = 0;
    private long frequency = 0L;
    public transient boolean hasPData = false;
    private int loss = 0;
    public transient int p1 = 0;
    public transient int p2 = 0;
    public transient int p3 = 0;
    public transient int p4 = 0;
    private int rss1 = 0;
    private int rss2 = 0;
    private int rss3 = 0;

    public VNABaseSample() {
    }

    public VNABaseSample(int angle, int loss, long frequency) {
        this.angle = angle;
        this.loss = loss;
        this.frequency = frequency;
        this.hasPData = false;
    }

    public VNABaseSample(VNABaseSample raw) {
        this.frequency = raw.getFrequency();
        this.angle = raw.getAngle();
        this.loss = raw.getLoss();
        this.rss1 = raw.getRss1();
        this.rss2 = raw.getRss2();
        this.rss3 = raw.getRss3();
        this.hasPData = raw.hasPData;
        this.p1 = raw.p1;
        this.p2 = raw.p2;
        this.p3 = raw.p3;
        this.p4 = raw.p4;
    }

    public Complex asComplex() {
        return new Complex((double)this.loss, (double)this.angle);
    }

    public int getAngle() {
        return this.angle;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public int getLoss() {
        return this.loss;
    }

    public int getRss1() {
        return this.rss1;
    }

    public int getRss2() {
        return this.rss2;
    }

    public int getRss3() {
        return this.rss3;
    }

    public void setAngle(int angle) {
        this.angle = angle;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }

    public void setLoss(int loss) {
        this.loss = loss;
    }

    public void setRss1(int rss1) {
        this.rss1 = rss1;
    }

    public void setRss2(int rss2) {
        this.rss2 = rss2;
    }

    public void setRss3(int rss3) {
        this.rss3 = rss3;
    }

    public String toString() {
        return "VNABaseSample [angle=" + this.angle + ", frequency=" + this.frequency + ", loss=" + this.loss + ", rss1=" + this.rss1 + ", rss2=" + this.rss2 + ", rss3=" + this.rss3 + "]";
    }
}

