/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.data;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.gui.util.VNAFrequencyPair;
import org.supercsv.cellprocessor.ParseLong;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvBeanReader;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.prefs.CsvPreference;

public class VNABandMap {
    private static final VNAConfig config = VNAConfig.getSingleton();
    private static final List<VNAFrequencyPair> list = new ArrayList<VNAFrequencyPair>();
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String CONFIG_FILE = "bandmap.csv";
    private static final String CONFIG_PATHNAME = String.valueOf(config.getVNAConfigDirectory()) + FILE_SEP + "bandmap.csv";
    private static final CellProcessor[] cellProcessors = new CellProcessor[]{new ParseLong(), new ParseLong()};

    public List<VNAFrequencyPair> getList() {
        return list;
    }

    public VNABandMap() {
        this.loadBandmap();
    }

    private void loadBandmap() {
        block15: {
            TraceHelper.entry(this, "loadBandmap");
            CsvBeanReader beanReader = null;
            try {
                try {
                    VNAFrequencyPair frqPair;
                    beanReader = new CsvBeanReader((Reader)new FileReader(CONFIG_PATHNAME), CsvPreference.STANDARD_PREFERENCE);
                    String[] header = beanReader.getHeader(true);
                    while ((frqPair = (VNAFrequencyPair)beanReader.read(VNAFrequencyPair.class, header, cellProcessors)) != null) {
                        list.add(frqPair);
                    }
                }
                catch (Exception ex) {
                    ErrorLogHelper.text(this, "readCSV", ex.getMessage());
                    list.clear();
                    this.loadDefaultBandmap();
                    this.saveBandmap();
                    if (beanReader != null) {
                        try {
                            beanReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (beanReader != null) {
                    try {
                        beanReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (beanReader != null) {
                try {
                    beanReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        TraceHelper.exit(this, "load");
    }

    private void loadDefaultBandmap() {
        TraceHelper.entry(this, "loadDefaultBandmap");
        list.add(new VNAFrequencyPair(135700L, 137800L));
        list.add(new VNAFrequencyPair(472000L, 479000L));
        list.add(new VNAFrequencyPair(1810000L, 2000000L));
        list.add(new VNAFrequencyPair(3500000L, 3800000L));
        list.add(new VNAFrequencyPair(7000000L, 0x6DDD00L));
        list.add(new VNAFrequencyPair(10100000L, 10150000L));
        list.add(new VNAFrequencyPair(14000000L, 14350000L));
        list.add(new VNAFrequencyPair(18068000L, 18168000L));
        list.add(new VNAFrequencyPair(21000000L, 21450000L));
        list.add(new VNAFrequencyPair(24890000L, 24990000L));
        list.add(new VNAFrequencyPair(28000000L, 29700000L));
        list.add(new VNAFrequencyPair(50000000L, 52000000L));
        list.add(new VNAFrequencyPair(70000000L, 70500000L));
        list.add(new VNAFrequencyPair(144000000L, 146000000L));
        list.add(new VNAFrequencyPair(430000000L, 440000000L));
        list.add(new VNAFrequencyPair(1240000000L, 1325000000L));
        list.add(new VNAFrequencyPair(2310000000L, 2450000000L));
        TraceHelper.exit(this, "loadDefaultBandmap");
    }

    private void saveBandmap() {
        block15: {
            TraceHelper.entry(this, "saveBandmap");
            CsvBeanWriter beanWriter = null;
            try {
                try {
                    beanWriter = new CsvBeanWriter((Writer)new FileWriter(CONFIG_PATHNAME), CsvPreference.STANDARD_PREFERENCE);
                    String[] header = new String[]{"startFrequency", "stopFrequency"};
                    beanWriter.writeHeader(header);
                    for (VNAFrequencyPair frqPair : list) {
                        beanWriter.write((Object)frqPair, header, cellProcessors);
                    }
                }
                catch (Exception ex) {
                    ErrorLogHelper.exception(this, "saveBandmap", ex);
                    if (beanWriter != null) {
                        try {
                            beanWriter.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (beanWriter != null) {
                    try {
                        beanWriter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (beanWriter != null) {
                try {
                    beanWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        TraceHelper.exit(this, "saveBandmap");
    }
}

