/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.data;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.VNADataPool;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.data.observer.VNAApplicationStateObserver;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.format.VNAFormatFactory;
import krause.vna.resources.VNAMessages;

public class VNAApplicationState {
    private INNERSTATE innerState;
    private List<VNAApplicationStateObserver> listeners = new ArrayList<VNAApplicationStateObserver>();
    private VNAMainFrame mainframe;
    private VNADataPool datapool = VNADataPool.getSingleton();

    public VNAApplicationState(VNAMainFrame pMF) {
        this.mainframe = pMF;
        this.innerState = INNERSTATE.UNINITIALIZED;
    }

    public void addStateListener(VNAApplicationStateObserver pListener) {
        TraceHelper.entry((Object)this, "addStateListener", pListener.getClass().getName());
        this.listeners.add(pListener);
        TraceHelper.exit(this, "addStateListener");
    }

    public void datapoolLoaded() {
        TraceHelper.entry(this, "datapoolLoaded");
        this.setState(INNERSTATE.NEW);
        TraceHelper.exit(this, "datapoolLoaded");
    }

    public void evtCalibrationLoaded() {
        TraceHelper.entry((Object)this, "evtCalibrationLoaded", "state=" + (Object)((Object)this.innerState));
        String drvString = String.valueOf(this.datapool.getDriver().getDeviceInfoBlock().getShortName()) + "/" + this.datapool.getDriver().getPortname();
        this.mainframe.getStatusBarDriverType().setText(drvString);
        VNACalibrationBlock mcb = this.datapool.getMainCalibrationBlock();
        if (mcb != null) {
            Double calTemp;
            this.mainframe.getStatusBarCalibrationStatus().setText(String.valueOf(mcb.getNumberOfSteps()) + "/" + mcb.getNumberOfOverscans());
            this.mainframe.getStatusBarCalibrationStatus().setBackground(Color.GREEN);
            String calFilename = "";
            if (mcb.getFile() != null) {
                calFilename = mcb.getComment() != null && !"".equals(mcb.getComment()) ? String.valueOf(calFilename) + mcb.getFile().getName() + " (" + mcb.getComment() + ")" : String.valueOf(calFilename) + mcb.getFile().getName();
            }
            if ((calTemp = mcb.getTemperature()) != null) {
                calFilename = String.valueOf(calFilename) + " @" + VNAFormatFactory.getTemperatureFormat().format(calTemp) + "\u00b0C";
            }
            this.mainframe.getStatusBarCalibrationFilename().setText(calFilename);
        }
        this.datapool.setCalibratedData(new VNACalibratedSampleBlock(0));
        this.setState(INNERSTATE.CALIBRATED);
        TraceHelper.exit(this, "evtCalibrationLoaded");
    }

    public void evtCalibrationUnloaded() {
        TraceHelper.entry((Object)this, "evtCalibrationUnloaded", "state=" + (Object)((Object)this.innerState));
        this.setState(INNERSTATE.DRIVERLOADED);
        this.mainframe.getStatusBarDriverType().setText(this.datapool.getDriver().getDeviceInfoBlock().getShortName());
        this.mainframe.getStatusBarCalibrationStatus().setText(VNAMessages.getString("VNAMainFrame.Cal.UNCAL"));
        this.mainframe.getStatusBarCalibrationStatus().setBackground(Color.RED);
        this.mainframe.getStatusBarCalibrationFilename().setText(VNAMessages.getString("VNAMainFrame.Cal.NOFILE"));
        TraceHelper.exit(this, "evtCalibrationUnloaded");
    }

    public void evtDriverLoaded() {
        TraceHelper.entry((Object)this, "evtDriverLoaded", "state=" + (Object)((Object)this.innerState));
        this.setState(INNERSTATE.DRIVERLOADED);
        String drvString = String.valueOf(this.datapool.getDriver().getDeviceInfoBlock().getShortName()) + "/" + this.datapool.getDriver().getPortname();
        this.mainframe.getStatusBarDriverType().setText(drvString);
        this.mainframe.getStatusBarCalibrationStatus().setText(VNAMessages.getString("VNAMainFrame.Cal.UNCAL"));
        this.mainframe.getStatusBarCalibrationStatus().setBackground(Color.RED);
        this.mainframe.getStatusBarCalibrationFilename().setText(VNAMessages.getString("VNAMainFrame.Cal.NOFILE"));
        this.mainframe.preloadCalibrationBlocks();
        this.mainframe.changedMode();
        if (this.datapool.getMainCalibrationBlock() != null) {
            this.evtCalibrationLoaded();
        }
        TraceHelper.exit(this, "evtDriverLoaded");
    }

    public void evtDriverUnloaded() {
        TraceHelper.entry((Object)this, "evtDriverUnloaded", "state=" + (Object)((Object)this.innerState));
        this.setState(INNERSTATE.GUIINITIALIZED);
        TraceHelper.exit(this, "evtDriverUnloaded");
    }

    public void evtGUIInitialzed() {
        TraceHelper.entry(this, "evtGUIInitialzed");
        this.mainframe.getStatusBarDriverType().setText("---");
        this.mainframe.getStatusBarCalibrationStatus().setText(VNAMessages.getString("VNAMainFrame.Cal.UNCAL"));
        this.mainframe.getStatusBarCalibrationStatus().setBackground(Color.RED);
        this.mainframe.getStatusBarCalibrationFilename().setText(VNAMessages.getString("VNAMainFrame.Cal.NOFILE"));
        this.setState(INNERSTATE.GUIINITIALIZED);
        this.mainframe.loadDriver();
        TraceHelper.exit(this, "evtGUIInitialzed");
    }

    public void evtMeasureEnded() {
        TraceHelper.entry((Object)this, "evtMeasureEnded", "state=" + (Object)((Object)this.innerState));
        this.setState(INNERSTATE.CALIBRATED);
        TraceHelper.exit(this, "evtMeasureEnded");
    }

    public void evtMeasureStarted() {
        TraceHelper.entry((Object)this, "evtMeasureStarted", "state=" + (Object)((Object)this.innerState));
        this.setState(INNERSTATE.RUNNING);
        TraceHelper.exit(this, "evtMeasureStarted");
    }

    public void evtScanModeChanged() {
        TraceHelper.entry(this, "evtScanModeChanged");
        this.mainframe.changedMode();
        TraceHelper.exit(this, "evtScanModeChanged");
    }

    public INNERSTATE getState() {
        return this.innerState;
    }

    private void publishState(INNERSTATE pOld, INNERSTATE pNew) {
        TraceHelper.entry((Object)this, "publishState", "state=" + (Object)((Object)this.innerState));
        for (VNAApplicationStateObserver listener : this.listeners) {
            listener.changeState(pOld, pNew);
        }
        TraceHelper.exit(this, "publishState");
    }

    public void republishState() {
        for (VNAApplicationStateObserver listener : this.listeners) {
            listener.changeState(this.innerState, this.innerState);
        }
    }

    protected void setState(INNERSTATE pNew) {
        INNERSTATE old = this.innerState;
        this.innerState = pNew;
        this.publishState(old, pNew);
    }

    public static enum INNERSTATE {
        NEW,
        UNINITIALIZED,
        GUIINITIALIZED,
        DRIVERLOADED,
        CALIBRATED,
        READY,
        RUNNING,
        TERMINATING;

    }
}

