/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.background;

import java.awt.Color;
import java.net.ConnectException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.background.IVNABackgroundTaskStatusListener;
import krause.vna.background.VNABackgroundJob;
import krause.vna.data.IVNADataConsumer;
import krause.vna.data.VNABaseSample;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.helper.VNASampleBlockHelper;
import krause.vna.device.IVNADriver;
import krause.vna.message.ErrorMessage;
import krause.vna.message.GenericMessage;
import krause.vna.message.InfoMessage;
import krause.vna.resources.VNAMessages;
import org.jdesktop.swingworker.SwingWorker;

public class VnaBackgroundTask
extends SwingWorker<List<VNABackgroundJob>, GenericMessage>
implements IVNABackgroundTaskStatusListener {
    private List<VNABackgroundJob> jobs = new ArrayList<VNABackgroundJob>();
    private List<IVNADataConsumer> consumers = new ArrayList<IVNADataConsumer>();
    private JLabel statusLabel = null;
    private IVNADriver driver;
    private long maxJobs = 0L;
    private long currJob = 0L;
    private long currOver = 0L;

    public VnaBackgroundTask(IVNADriver pDriver) {
        this.driver = pDriver;
    }

    public void addDataConsumer(IVNADataConsumer pConsumer) {
        TraceHelper.entry(this, "addConsumer");
        this.consumers.add(pConsumer);
        TraceHelper.exit(this, "addConsumer");
    }

    @Override
    public List<VNABackgroundJob> doInBackground() {
        TraceHelper.entry(this, "doInBackground");
        try {
            this.publish(new InfoMessage("Background.1"));
            this.publish(new InfoMessage("Background.2"));
            this.maxJobs = this.jobs.size();
            this.currJob = 0L;
            for (VNABackgroundJob job : this.jobs) {
                int speedup;
                int realSamples = job.getNumberOfSamples();
                int nofSpeedSamples = realSamples / (speedup = job.getSpeedup());
                if (nofSpeedSamples * speedup < realSamples) {
                    ++nofSpeedSamples;
                }
                ++this.currJob;
                VNASampleBlock block = null;
                if (job.getOverScans() > 1) {
                    ArrayList<VNASampleBlock> blocks = new ArrayList<VNASampleBlock>();
                    int i = 0;
                    while (i < job.getOverScans()) {
                        this.currOver = i;
                        VNASampleBlock aBlock = this.driver.scan(job.getScanMode(), job.getFrequencyRange().getStart(), job.getFrequencyRange().getStop(), nofSpeedSamples, this);
                        blocks.add(aBlock);
                        ++i;
                    }
                    block = VNASampleBlockHelper.calculateAverageSampleBlock(blocks);
                } else {
                    this.currOver = 0L;
                    block = this.driver.scan(job.getScanMode(), job.getFrequencyRange().getStart(), job.getFrequencyRange().getStop(), nofSpeedSamples, this);
                }
                if (speedup > 1) {
                    VNABaseSample[] newSamples = new VNABaseSample[realSamples];
                    int idx = 0;
                    VNABaseSample[] speedSamples = block.getSamples();
                    int i = 0;
                    while (i < nofSpeedSamples) {
                        VNABaseSample currentSample = speedSamples[i];
                        VNABaseSample nextSample = i < nofSpeedSamples - 1 ? speedSamples[i + 1] : currentSample;
                        idx = this.createIntermediateSamples(currentSample, nextSample, newSamples, idx, speedup);
                        ++i;
                    }
                    block.setSamples(newSamples);
                    block.setNumberOfSteps(realSamples);
                }
                job.setResult(block);
                this.driver.stopGenerator();
            }
        }
        catch (Exception e) {
            ErrorLogHelper.exception(this, "doInBackground", e);
            Throwable root = e;
            if (e.getCause() != null) {
                root = e.getCause();
            }
            if (root instanceof ConnectException) {
                String msg = VNAMessages.getString("VnaBackgroundTask.ConnectException");
                this.publish(new ErrorMessage(MessageFormat.format(msg, e.getMessage())));
            }
            this.publish(new ErrorMessage(e.getMessage()));
        }
        TraceHelper.exit(this, "doInBackground");
        return this.getJobs();
    }

    private int createIntermediateSamples(VNABaseSample currentSample, VNABaseSample nextSample, VNABaseSample[] newSamples, int idx, int speedup) {
        int maxIdx = newSamples.length;
        int j = 0;
        while (j < speedup) {
            if (idx < maxIdx) {
                newSamples[idx] = currentSample;
                ++idx;
            }
            ++j;
        }
        return idx;
    }

    protected VNABaseSample calculateDiffSample(VNABaseSample o, VNABaseSample d, int j) {
        VNABaseSample rc = new VNABaseSample();
        rc.setAngle(o.getAngle() + d.getAngle() * j);
        rc.setFrequency(o.getFrequency() + d.getFrequency() * (long)j);
        rc.setLoss(o.getLoss() + d.getLoss() * j);
        rc.setRss1(o.getRss1() + d.getRss1() * j);
        rc.setRss2(o.getRss2() + d.getRss2() * j);
        rc.setRss3(o.getRss3() + d.getRss3() * j);
        return rc;
    }

    protected VNABaseSample createDiffSample(VNABaseSample s1, VNABaseSample s2, int w) {
        VNABaseSample rc = new VNABaseSample();
        rc.setAngle((s2.getAngle() - s1.getAngle()) / w);
        rc.setFrequency((s2.getFrequency() - s1.getFrequency()) / (long)w);
        rc.setLoss((s2.getLoss() - s1.getLoss()) / w);
        rc.setRss1((s2.getRss1() - s1.getRss1()) / w);
        rc.setRss2((s2.getRss2() - s1.getRss2()) / w);
        rc.setRss3((s2.getRss3() - s1.getRss3()) / w);
        return rc;
    }

    @Override
    protected void process(List<GenericMessage> chunks) {
        if (this.statusLabel != null) {
            for (GenericMessage message : chunks) {
                this.statusLabel.setOpaque(true);
                if (message instanceof ErrorMessage) {
                    this.statusLabel.setForeground(Color.RED);
                    this.statusLabel.setBackground(Color.BLACK);
                } else {
                    this.statusLabel.setForeground(Color.BLACK);
                    this.statusLabel.setBackground(Color.GREEN);
                }
                this.statusLabel.setText(message.getMessage());
                TraceHelper.text(this, "process", message.getMessage());
            }
        }
    }

    @Override
    protected void done() {
        TraceHelper.entry(this, "done");
        try {
            List data = (List)this.get();
            for (IVNADataConsumer consumer : this.consumers) {
                consumer.consumeDataBlock(data);
            }
        }
        catch (InterruptedException e) {
            ErrorLogHelper.exception(this, "done", e);
        }
        catch (ExecutionException e) {
            ErrorLogHelper.exception(this, "done", e);
        }
        TraceHelper.exit(this, "done");
    }

    public void addJob(VNABackgroundJob job) {
        this.getJobs().add(job);
    }

    public List<VNABackgroundJob> getJobs() {
        return this.jobs;
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }

    public void setStatusLabel(JLabel statusLabel) {
        this.statusLabel = statusLabel;
    }

    @Override
    public void publishProgress(int percentage) {
        this.publish(new InfoMessage("Background.3", this.currOver, this.currJob, this.maxJobs, percentage));
    }
}

