/*
 * Decompiled with CFR 0.152.
 */
package krause.util.ras.logging;

import java.util.Properties;
import krause.common.exception.InitializationException;
import krause.util.PropertiesHelper;
import krause.util.component.ManageableComponent;
import krause.util.ras.logging.ConsoleLogger;
import krause.util.ras.logging.ConsoleTracer;
import krause.util.ras.logging.Logger;
import krause.util.ras.logging.TraceHelper;
import krause.util.ras.logging.Tracer;

public class LogManager
implements ManageableComponent {
    public static final String CLASSNAME = "classname";
    public static final String ERRORLOGGER_PREFIX = "ErrorLogger.";
    public static final String ERRORLOGGER_CLASSNAME = "ErrorLogger.classname";
    public static final String ERRORLOGGER_ENABLE = "ErrorLogger.logging";
    public static final String APPLOGGER_PREFIX = "ApplicationLogger.";
    public static final String APPLOGGER_CLASSNAME = "ApplicationLogger.classname";
    public static final String APPLOGGER_ENABLE = "ApplicationLogger.logging";
    public static final String TRACER_PREFIX = "Tracer.";
    public static final String TRACER_CLASSNAME = "Tracer.classname";
    public static final String TRACER_ENABLE = "Tracer.tracing";
    private static LogManager singleton = null;
    private Logger fieldErrorLogger = null;
    private Logger fieldApplicationLogger = null;
    private Tracer fieldTracer = null;
    private boolean errorLoggingEnabled = false;
    private boolean applicationLoggingEnabled = false;
    private boolean tracingEnabled = false;

    private LogManager() {
    }

    @Override
    public void destroy() {
        TraceHelper.entry(this, "destroy");
        try {
            if (this.fieldErrorLogger != null) {
                this.fieldErrorLogger.destroy();
                this.fieldErrorLogger = null;
            }
            if (this.fieldApplicationLogger != null) {
                this.fieldApplicationLogger.destroy();
                this.fieldApplicationLogger = null;
            }
            if (this.fieldTracer != null) {
                this.fieldTracer.destroy();
                this.fieldTracer = null;
            }
            singleton = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("LogManager::destroy-exit");
    }

    public boolean readyToDestroy() {
        return true;
    }

    public void suspendActivity() {
    }

    public void resumeActivity() {
    }

    @Override
    public void initialize(Properties theProps) throws InitializationException {
        try {
            String tracerClass;
            String appLoggerClass;
            String loggerClass = (String)theProps.get(ERRORLOGGER_CLASSNAME);
            if (loggerClass != null) {
                Logger newLogger = (Logger)Class.forName(loggerClass.trim()).newInstance();
                newLogger.initialize(PropertiesHelper.createProperties(theProps, ERRORLOGGER_PREFIX, true));
                this.fieldErrorLogger = newLogger;
                this.errorLoggingEnabled = "true".equalsIgnoreCase(theProps.getProperty(ERRORLOGGER_ENABLE));
            }
            if ((appLoggerClass = (String)theProps.get(APPLOGGER_CLASSNAME)) != null) {
                Logger newLogger = (Logger)Class.forName(appLoggerClass.trim()).newInstance();
                newLogger.initialize(PropertiesHelper.createProperties(theProps, APPLOGGER_PREFIX, true));
                this.fieldApplicationLogger = newLogger;
                this.applicationLoggingEnabled = "true".equalsIgnoreCase(theProps.getProperty(APPLOGGER_ENABLE));
            }
            if ((tracerClass = (String)theProps.get(TRACER_CLASSNAME)) != null) {
                Tracer newTracer = (Tracer)Class.forName(tracerClass.trim()).newInstance();
                newTracer.initialize(PropertiesHelper.createProperties(theProps, TRACER_PREFIX, true));
                this.fieldTracer = newTracer;
                this.tracingEnabled = "true".equalsIgnoreCase(theProps.getProperty(TRACER_ENABLE));
            }
        }
        catch (Exception ex) {
            throw new InitializationException(ex);
        }
    }

    public Logger getErrorLogger() {
        return this.fieldErrorLogger;
    }

    public Logger getApplicationLogger() {
        return this.fieldApplicationLogger;
    }

    public Tracer getTracer() {
        return this.fieldTracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogManager getSingleton() {
        if (singleton != null) return singleton;
        Class<LogManager> clazz = LogManager.class;
        synchronized (LogManager.class) {
            if (singleton != null) return singleton;
            try {
                LogManager manager = new LogManager();
                manager.initializeDefault();
                singleton = manager;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return singleton;
        }
    }

    @Override
    public void initializeDefault() {
        this.fieldErrorLogger = new ConsoleLogger();
        this.fieldApplicationLogger = new ConsoleLogger();
        this.fieldTracer = new ConsoleTracer();
        this.errorLoggingEnabled = true;
        this.applicationLoggingEnabled = true;
        this.tracingEnabled = true;
    }

    public boolean isApplicationLoggingEnabled() {
        return this.applicationLoggingEnabled;
    }

    public boolean isErrorLoggingEnabled() {
        return this.errorLoggingEnabled;
    }

    public void setApplicationLoggingEnabled(boolean applicationLoggingEnabled) {
        this.applicationLoggingEnabled = applicationLoggingEnabled;
    }

    public void setErrorLoggingEnabled(boolean loggingEnabled) {
        this.errorLoggingEnabled = loggingEnabled;
    }

    public void setTracingEnabled(boolean tracingEnabled) {
        this.tracingEnabled = tracingEnabled;
    }

    public boolean isTracingEnabled() {
        return this.tracingEnabled;
    }

    @Override
    public String getVersion() {
        return "1.0";
    }
}

