/*
 * Decompiled with CFR 0.152.
 */
package krause.util.ras.logging;

import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import krause.common.exception.InitializationException;
import krause.common.exception.ProcessingException;
import krause.util.GlobalSymbols;
import krause.util.ras.logging.Tracer;

public class GenericTracer
implements Tracer {
    private boolean fieldShortClassname = false;
    private Writer fieldWriter = null;
    public static final String SHORTCLASSNAME = "shortclassname";

    @Override
    public void destroy() throws ProcessingException {
        try {
            if (this.getWriter() != null) {
                this.getWriter().flush();
                this.getWriter().close();
            }
        }
        catch (Exception ex) {
            throw new ProcessingException(ex);
        }
    }

    @Override
    public void initialize(Properties parmProps) throws InitializationException {
        try {
            this.setShortClassname("true".equalsIgnoreCase((String)parmProps.get(SHORTCLASSNAME)));
        }
        catch (Exception ex) {
            throw new InitializationException(ex);
        }
    }

    public void setShortClassname(boolean shortClassname) {
        this.fieldShortClassname = shortClassname;
    }

    public boolean isShortClassname() {
        return this.fieldShortClassname;
    }

    protected StringBuffer buildLineHeader(Object theCaller, String theMethod) {
        int i;
        StringBuffer sbData = new StringBuffer(100);
        sbData.append(DateFormat.getDateTimeInstance().format(new Date()));
        String classname = theCaller.getClass().getName();
        if (this.isShortClassname() && (i = classname.lastIndexOf(".")) != -1) {
            classname = classname.substring(i + 1);
        }
        sbData.append(" T:").append(classname).append("::").append(theMethod);
        return sbData;
    }

    public void setWriter(Writer writer) {
        this.fieldWriter = writer;
    }

    public Writer getWriter() {
        return this.fieldWriter;
    }

    @Override
    public void text(Object theCaller, String theMethod, String theMsg) {
        try {
            StringBuffer sbData = this.buildLineHeader(theCaller, theMethod);
            sbData.append("() ").append(theMsg).append(GlobalSymbols.LINE_SEPARATOR);
            this.getWriter().write(sbData.toString());
            this.getWriter().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void entry(Object theCaller, String theMethod, Object[] theParms) {
        try {
            StringBuffer sbData = this.buildLineHeader(theCaller, theMethod);
            sbData.append("()-entry ");
            int i = 0;
            while (i < theParms.length) {
                sbData.append("parm").append(i).append("=[").append(theParms[i]).append("] ");
                ++i;
            }
            sbData.append(GlobalSymbols.LINE_SEPARATOR);
            this.getWriter().write(sbData.toString());
            this.getWriter().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void entry(Object theCaller, String theMethod, String text) {
        try {
            StringBuffer sbData = this.buildLineHeader(theCaller, theMethod);
            sbData.append("()-entry ");
            sbData.append(text);
            sbData.append(GlobalSymbols.LINE_SEPARATOR);
            this.getWriter().write(sbData.toString());
            this.getWriter().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void exitWithRC(Object theCaller, String theMethod, Object rc) {
        try {
            StringBuffer sbData = this.buildLineHeader(theCaller, theMethod);
            sbData.append("()-exit RC=[").append(rc).append("]").append(GlobalSymbols.LINE_SEPARATOR);
            this.getWriter().write(sbData.toString());
            this.getWriter().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void exitWithRC(Object theCaller, String theMethod, Object[] theParms) {
        try {
            StringBuffer sbData = this.buildLineHeader(theCaller, theMethod);
            sbData.append("()-exit ");
            int i = 0;
            while (i < theParms.length) {
                sbData.append("rc").append(i).append("=[").append(theParms[i]).append("] ");
                ++i;
            }
            sbData.append(GlobalSymbols.LINE_SEPARATOR);
            this.getWriter().write(sbData.toString());
            this.getWriter().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void entry(Object theCaller, String theMethod) {
        try {
            StringBuffer sbData = this.buildLineHeader(theCaller, theMethod);
            sbData.append("()-entry").append(GlobalSymbols.LINE_SEPARATOR);
            this.getWriter().write(sbData.toString());
            this.getWriter().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void exit(Object theCaller, String theMethod) {
        try {
            StringBuffer sbData = this.buildLineHeader(theCaller, theMethod);
            sbData.append("()-exit").append(GlobalSymbols.LINE_SEPARATOR);
            this.getWriter().write(sbData.toString());
            this.getWriter().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

