/*
 * Decompiled with CFR 0.152.
 */
package krause.util.ras.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import krause.common.exception.InitializationException;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.Logger;

public class GenericLogger
implements Logger {
    private boolean fieldShortClassname = false;
    private Writer fieldWriter = null;
    public static final String SHORTCLASSNAME = "shortclassname";

    public boolean isShortClassname() {
        return this.fieldShortClassname;
    }

    public void setShortClassname(boolean shortClassname) {
        this.fieldShortClassname = shortClassname;
    }

    @Override
    public void destroy() throws ProcessingException {
        try {
            if (this.getWriter() != null) {
                this.getWriter().flush();
                this.getWriter().close();
            }
        }
        catch (Exception ex) {
            throw new ProcessingException(ex);
        }
    }

    @Override
    public void initialize(Properties parmProps) throws InitializationException {
        try {
            this.setShortClassname("true".equalsIgnoreCase((String)parmProps.get(SHORTCLASSNAME)));
        }
        catch (Exception ex) {
            throw new InitializationException(ex);
        }
    }

    @Override
    public void text(Object theCaller, String theMethod, String theMsg) {
        StringBuffer sbData = new StringBuffer();
        sbData.append(this.buildLineHeader(theCaller, theMethod));
        sbData.append(theMsg).append("\n");
        try {
            this.getWriter().write(sbData.toString());
            this.getWriter().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected StringBuffer buildLineHeader(Object theCaller, String theMethod) {
        int i;
        StringBuffer sbData = new StringBuffer(100);
        sbData.append(DateFormat.getDateTimeInstance().format(new Date()));
        String classname = theCaller.getClass().getName();
        if (this.isShortClassname() && (i = classname.lastIndexOf(".")) != -1) {
            classname = classname.substring(i + 1);
        }
        sbData.append(" L:").append(classname).append("::").append(theMethod).append("() ");
        return sbData;
    }

    public void setWriter(Writer writer) {
        this.fieldWriter = writer;
    }

    @Override
    public Writer getWriter() {
        return this.fieldWriter;
    }

    @Override
    public void text(Object theCaller, String theMethod, Exception theExc) {
        StringBuffer sbData = new StringBuffer();
        sbData.append(this.buildLineHeader(theCaller, theMethod));
        sbData.append(theExc.toString()).append("\n");
        try {
            this.getWriter().write(sbData.toString());
            theExc.printStackTrace(new PrintWriter(this.getWriter()));
            this.getWriter().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

