/*
 * Decompiled with CFR 0.152.
 */
package krause.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import krause.common.exception.PropertyNotFoundException;
import krause.util.PropertiesLoader;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;

public class PropertiesHelper {
    public static Properties load(String fullFileName) {
        try {
            Properties properties = new Properties();
            try (InputStream in = PropertiesLoader.getResourceAsStream(fullFileName);){
                properties.load(in);
            }
            return properties;
        }
        catch (Throwable th) {
            return null;
        }
    }

    public static Properties createProperties(Properties props, String key) {
        return PropertiesHelper.createProperties(props, key, false);
    }

    public static Properties createProperties(Properties props, String key, boolean chopOffKey) {
        Properties newProps = new Properties();
        Enumeration<Object> keys = props.keys();
        String oldKey = null;
        String newKey = null;
        while (keys.hasMoreElements()) {
            oldKey = (String)keys.nextElement();
            if (!oldKey.startsWith(key)) continue;
            newKey = oldKey;
            if (chopOffKey) {
                newKey = oldKey.substring(key.length(), oldKey.length());
            }
            newProps.put(newKey, props.getProperty(oldKey));
        }
        return newProps;
    }

    public static String getProperty(Properties props, String key) throws PropertyNotFoundException {
        String prop = props.getProperty(key);
        if (prop == null || prop.length() == 0) {
            throw new PropertyNotFoundException(key);
        }
        return prop;
    }

    public static Properties loadXMLProperties(String userFileName, Properties defaultProperties) {
        Properties rc = new Properties();
        try {
            FileInputStream is = new FileInputStream(userFileName);
            rc.loadFromXML(is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            rc = defaultProperties;
        }
        catch (IOException e) {
            rc = defaultProperties;
        }
        return rc;
    }

    public static void saveXMLProperties(Properties props, String userFileName) {
        TraceHelper.entry((Object)"", "saveXMLProperties", userFileName);
        try {
            FileOutputStream os = new FileOutputStream(userFileName);
            props.storeToXML(os, new Date().toString());
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException e) {
            ErrorLogHelper.exception("", "saveXMLProperties", e);
        }
        catch (IOException e) {
            ErrorLogHelper.exception("", "saveXMLProperties", e);
        }
        TraceHelper.exit("", "saveXMLProperties");
    }
}

