/*
 * Decompiled with CFR 0.152.
 */
package krause.net.server.data;

import java.util.HashMap;
import java.util.Map;
import krause.net.server.data.ServerReportItem;

public class ServerReport {
    private Map<String, ServerReportItem> items = new HashMap<String, ServerReportItem>();

    public ServerReportItem getItem(String name) {
        ServerReportItem lItem = this.items.get(name);
        if (lItem == null) {
            lItem = new ServerReportItem();
            lItem.setName(name);
            this.items.put(name, lItem);
        }
        return lItem;
    }

    public void updateItem(ServerReportItem item) {
        ServerReportItem lItem = this.items.get(item.getName());
        if (lItem != null) {
            lItem.setIntValue(item.getIntValue());
            lItem.setStringValue(item.getStringValue());
        }
    }

    public void incItemValue(String name) {
        ServerReportItem lItem = this.items.get(name);
        if (lItem == null) {
            lItem = new ServerReportItem();
            lItem.setName(name);
            this.items.put(name, lItem);
        }
        lItem.incIntValue();
    }

    public void decItemValue(String name) {
        ServerReportItem lItem = this.items.get(name);
        if (lItem == null) {
            lItem = new ServerReportItem();
            lItem.setName(name);
            this.items.put(name, lItem);
        }
        lItem.decIntValue();
    }

    public void updateItem(String name, int value) {
        ServerReportItem lItem = this.items.get(name);
        if (lItem == null) {
            lItem = new ServerReportItem();
            lItem.setName(name);
            lItem.setIntValue(value);
            this.items.put(name, lItem);
        }
        lItem.setIntValue(value);
    }

    public void updateItem(String name, String value) {
        ServerReportItem lItem = this.items.get(name);
        if (lItem != null) {
            lItem.setStringValue(value);
        }
    }

    public void setItems(Map<String, ServerReportItem> items) {
        this.items = items;
    }

    public Map<String, ServerReportItem> getItems() {
        return this.items;
    }
}

