/*
 * Decompiled with CFR 0.152.
 */
package krause.net.server;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.Properties;
import krause.common.exception.ProcessingException;
import krause.net.server.SimpleServerSocketBaseRequestHandler;
import krause.net.server.data.ServerController;
import krause.net.server.data.ServerStatusBlock;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;

public class SimpleSocketServer
extends Thread {
    public static final String CONFIG_ACCEPT_PORT = "SimpleSocketServer.AcceptPort";
    public static final String CONFIG_ACCEPT_TIMEOUT = "SimpleSocketServer.AcceptTimeout";
    public static final String CONFIG_HANDLER_CLASSNAME = "SimpleSocketServer.SocketRequestHandlerClassname";
    private int acceptPort;
    private int acceptTimeout;
    private InetAddress bindAddr;
    private ServerController serverController;
    private ServerStatusBlock status = new ServerStatusBlock();
    private Properties parameters = null;
    private String socketRequestHandlerClassname = null;
    private Class<SimpleServerSocketBaseRequestHandler> socketRequestHandlerClass = null;
    private Constructor<SimpleServerSocketBaseRequestHandler> socketRequestHandlerConstructor = null;

    public SimpleSocketServer(InetAddress pBindAddr, ServerController pServerControl, Properties pProps) throws ProcessingException {
        TraceHelper.entry(this, "SimpleSocketServer");
        this.parameters = pProps;
        this.bindAddr = pBindAddr;
        this.serverController = pServerControl;
        this.acceptPort = Integer.parseInt(this.parameters.getProperty(CONFIG_ACCEPT_PORT));
        this.acceptTimeout = Integer.parseInt(this.parameters.getProperty(CONFIG_ACCEPT_TIMEOUT));
        this.setupClassFactory();
        TraceHelper.exit(this, "SimpleSocketServer");
    }

    private void setupClassFactory() throws ProcessingException {
        TraceHelper.entry(this, "setupClassFactory");
        this.socketRequestHandlerClassname = this.parameters.getProperty(CONFIG_HANDLER_CLASSNAME);
        try {
            this.socketRequestHandlerClass = Class.forName(this.socketRequestHandlerClassname);
            this.socketRequestHandlerConstructor = this.socketRequestHandlerClass.getConstructor(Socket.class, Properties.class, ServerStatusBlock.class);
        }
        catch (ClassNotFoundException e) {
            ErrorLogHelper.exception(this, "setupClassFactory", e);
            throw new ProcessingException(e);
        }
        catch (SecurityException e) {
            ErrorLogHelper.exception(this, "setupClassFactory", e);
            throw new ProcessingException(e);
        }
        catch (NoSuchMethodException e) {
            ErrorLogHelper.exception(this, "setupClassFactory", e);
            throw new ProcessingException(e);
        }
        TraceHelper.exit(this, "setupClassFactory");
    }

    @Override
    public void run() {
        TraceHelper.entry(this, "run");
        this.status.setStartTime(new Date());
        try {
            ServerSocket clientConnect = new ServerSocket(this.acceptPort, 0, this.bindAddr);
            clientConnect.setSoTimeout(this.acceptTimeout);
            while (!this.serverController.serverShouldStop()) {
                this.status.setLastLifesign(new Date());
                this.serverController.reportServerStatus(this.status);
                Socket clientReq = null;
                try {
                    clientReq = clientConnect.accept();
                    SimpleServerSocketBaseRequestHandler socketHandler = this.createNewSocketRequestHandler(clientReq);
                    socketHandler.handle();
                }
                catch (SocketTimeoutException socketHandler) {
                    if (clientReq == null) continue;
                    try {
                        clientReq.close();
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "run", e);
                    }
                    continue;
                }
                catch (Exception e) {
                    try {
                        ErrorLogHelper.exception(this, "run", e);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (clientReq != null) {
                            try {
                                clientReq.close();
                            }
                            catch (IOException e2) {
                                ErrorLogHelper.exception(this, "run", e2);
                            }
                        }
                    }
                }
                if (clientReq == null) continue;
                try {
                    clientReq.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "run", e);
                }
            }
            clientConnect.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TraceHelper.exit(this, "run");
    }

    private SimpleServerSocketBaseRequestHandler createNewSocketRequestHandler(Socket clientReq) throws ProcessingException {
        SimpleServerSocketBaseRequestHandler rc = null;
        TraceHelper.entry(this, "createNewSocketRequestHandler");
        try {
            rc = this.socketRequestHandlerConstructor.newInstance(clientReq, this.parameters, this.status);
        }
        catch (IllegalArgumentException e) {
            ErrorLogHelper.exception(this, "createNewSocketRequestHandler", e);
            throw new ProcessingException(e);
        }
        catch (InstantiationException e) {
            ErrorLogHelper.exception(this, "createNewSocketRequestHandler", e);
            throw new ProcessingException(e);
        }
        catch (IllegalAccessException e) {
            ErrorLogHelper.exception(this, "createNewSocketRequestHandler", e);
            throw new ProcessingException(e);
        }
        catch (InvocationTargetException e) {
            ErrorLogHelper.exception(this, "createNewSocketRequestHandler", e);
            throw new ProcessingException(e);
        }
        TraceHelper.exit(this, "createNewSocketRequestHandler");
        return rc;
    }
}

