/*
 * Decompiled with CFR 0.152.
 */
package krause.common.validation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import krause.common.gui.ILocationAwareDialog;
import krause.common.gui.KrauseDialog;
import krause.common.resources.CommonMessages;
import krause.common.validation.ValidationResultTable;
import krause.common.validation.ValidationResults;
import krause.util.ras.logging.TraceHelper;

public class ValidationResultsDialog
extends KrauseDialog
implements ILocationAwareDialog {
    private final JPanel contentPanel = new JPanel();
    private ValidationResultTable lstMessages;

    public ValidationResultsDialog(Window mainFrame, ValidationResults pResults, String title) {
        super(mainFrame, true);
        this.setTitle(title);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, "", 4, 2, null, null));
        FlowLayout flowLayout = (FlowLayout)panel.getLayout();
        flowLayout.setAlignment(0);
        this.getContentPane().add((Component)panel, "North");
        JLabel lblOneOrMore = new JLabel(CommonMessages.getString("ValidationResultsDialog.headline"));
        lblOneOrMore.setForeground(Color.RED);
        lblOneOrMore.setFont(new Font("Segoe UI", 1, 18));
        panel.add(lblOneOrMore);
        FlowLayout fl_contentPanel = new FlowLayout();
        fl_contentPanel.setAlignment(0);
        this.contentPanel.setLayout(fl_contentPanel);
        this.contentPanel.setBorder(new EtchedBorder(1, null, null));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.lstMessages = new ValidationResultTable();
        this.lstMessages.setFillsViewportHeight(true);
        this.lstMessages.setSelectionMode(0);
        this.lstMessages.setRowSelectionAllowed(false);
        this.lstMessages.getModel().setResults(pResults);
        this.lstMessages.setPreferredScrollableViewportSize(new Dimension(600, 200));
        JScrollPane sp = new JScrollPane(this.lstMessages);
        sp.setAlignmentX(0.0f);
        this.contentPanel.add(sp);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton(CommonMessages.getString("Button.OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidationResultsDialog.this.doCANCEL();
            }
        });
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.doInit();
    }

    @Override
    protected void doCANCEL() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    protected void doInit() {
        this.addEscapeKey();
        this.showInPlace();
    }

    @Override
    public void restoreWindowPosition() {
        TraceHelper.entry(this, "restoreWindowPosition");
        Dimension dimRoot = Toolkit.getDefaultToolkit().getScreenSize();
        int x = dimRoot.width / 2 - this.getSize().width / 2;
        int y = dimRoot.height / 2 - this.getSize().height / 2;
        this.setLocation(x, y);
        TraceHelper.exit(this, "restoreWindowPosition");
    }

    @Override
    public void restoreWindowSize() {
        TraceHelper.entry(this, "restoreWindowSize");
        TraceHelper.exit(this, "restoreWindowSize");
    }

    @Override
    public void showInPlace() {
        TraceHelper.entry(this, "showInPlace");
        this.restoreWindowSize();
        this.pack();
        this.restoreWindowPosition();
        this.setVisible(true);
        TraceHelper.exit(this, "showInPlace");
    }

    @Override
    public void storeWindowPosition() {
        TraceHelper.entry(this, "storeWindowPosition");
        TraceHelper.exit(this, "storeWindowPosition");
    }

    @Override
    public void storeWindowSize() {
        TraceHelper.entry(this, "storeWindowSize");
        TraceHelper.exit(this, "storeWindowSize");
    }
}

