/*
 * Decompiled with CFR 0.152.
 */
package krause.common.validation;

import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import krause.common.resources.CommonMessages;
import krause.common.validation.ValidationResult;
import krause.common.validation.ValidationResults;

public class LongValidator {
    public static long parse(String value, long min, long max, String context, ValidationResults results) {
        NumberFormat fmt = NumberFormat.getNumberInstance();
        long rc = 0L;
        try {
            ValidationResult res;
            String msg;
            rc = fmt.parse(value).longValue();
            if (rc < min) {
                msg = CommonMessages.getString("LongValidator.tooSmall");
                res = new ValidationResult(MessageFormat.format(msg, min));
                res.setType(ValidationResult.ValidationType.ERROR);
                res.setErrorObject(context);
                results.add(res);
            }
            if (rc > max) {
                msg = CommonMessages.getString("LongValidator.tooLarge");
                res = new ValidationResult(MessageFormat.format(msg, max));
                res.setType(ValidationResult.ValidationType.ERROR);
                res.setErrorObject(context);
                results.add(res);
            }
        }
        catch (ParseException e1) {
            ValidationResult res = new ValidationResult(e1, e1.getMessage());
            res.setType(ValidationResult.ValidationType.ERROR);
            res.setErrorObject(context);
            results.add(res);
        }
        return rc;
    }
}

