/*
 * Decompiled with CFR 0.152.
 */
package krause.common.validation;

import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import krause.common.resources.CommonMessages;
import krause.common.validation.ValidationResult;
import krause.common.validation.ValidationResults;

public class IntegerValidator {
    public static int parse(String value, int min, int max, String context, ValidationResults results) {
        NumberFormat fmt = NumberFormat.getNumberInstance();
        int rc = 0;
        try {
            ValidationResult res;
            String msg;
            rc = fmt.parse(value).intValue();
            if (rc < min) {
                msg = CommonMessages.getString("IntegerValidator.tooSmall");
                res = new ValidationResult(MessageFormat.format(msg, min));
                res.setType(ValidationResult.ValidationType.ERROR);
                res.setErrorObject(context);
                results.add(res);
            }
            if (rc > max) {
                msg = CommonMessages.getString("IntegerValidator.tooLarge");
                res = new ValidationResult(MessageFormat.format(msg, max));
                res.setType(ValidationResult.ValidationType.ERROR);
                res.setErrorObject(context);
                results.add(res);
            }
        }
        catch (ParseException e1) {
            ValidationResult res = new ValidationResult(e1, e1.getMessage());
            res.setType(ValidationResult.ValidationType.ERROR);
            res.setErrorObject(context);
            results.add(res);
        }
        return rc;
    }
}

