/*
 * Decompiled with CFR 0.152.
 */
package krause.common.math;

import org.apache.commons.math.complex.Complex;

public class FFT {
    public static Complex[] fft(Complex[] x) {
        int N = x.length;
        if (N == 1) {
            return new Complex[]{x[0]};
        }
        if (N % 2 != 0) {
            throw new RuntimeException("N is not a power of 2");
        }
        Complex[] even = new Complex[N / 2];
        int k = 0;
        while (k < N / 2) {
            even[k] = x[2 * k];
            ++k;
        }
        Complex[] q = FFT.fft(even);
        Complex[] odd = even;
        int k2 = 0;
        while (k2 < N / 2) {
            odd[k2] = x[2 * k2 + 1];
            ++k2;
        }
        Complex[] r = FFT.fft(odd);
        Complex[] y = new Complex[N];
        int k3 = 0;
        while (k3 < N / 2) {
            double kth = (double)(-2 * k3) * Math.PI / (double)N;
            Complex wk = new Complex(Math.cos(kth), Math.sin(kth));
            y[k3] = q[k3].add(wk.multiply(r[k3]));
            y[k3 + N / 2] = q[k3].subtract(wk.multiply(r[k3]));
            ++k3;
        }
        return y;
    }

    public static Complex[] ifft(Complex[] x) {
        int N = x.length;
        Complex[] y = new Complex[N];
        int i = 0;
        while (i < N) {
            y[i] = x[i].conjugate();
            ++i;
        }
        y = FFT.fft(y);
        i = 0;
        while (i < N) {
            y[i] = y[i].conjugate();
            ++i;
        }
        i = 0;
        while (i < N) {
            y[i] = y[i].multiply(1.0 / (double)N);
            ++i;
        }
        return y;
    }

    public static Complex[] cconvolve(Complex[] x, Complex[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("Dimensions don't agree");
        }
        int N = x.length;
        Complex[] a = FFT.fft(x);
        Complex[] b = FFT.fft(y);
        Complex[] c = new Complex[N];
        int i = 0;
        while (i < N) {
            c[i] = a[i].multiply(b[i]);
            ++i;
        }
        return FFT.ifft(c);
    }

    public static Complex[] convolve(Complex[] x, Complex[] y) {
        Complex[] a = new Complex[2 * x.length];
        int i = 0;
        while (i < x.length) {
            a[i] = x[i];
            ++i;
        }
        i = x.length;
        while (i < 2 * x.length) {
            a[i] = Complex.ZERO;
            ++i;
        }
        Complex[] b = new Complex[2 * y.length];
        int i2 = 0;
        while (i2 < y.length) {
            b[i2] = y[i2];
            ++i2;
        }
        i2 = y.length;
        while (i2 < 2 * y.length) {
            b[i2] = Complex.ZERO;
            ++i2;
        }
        return FFT.cconvolve(a, b);
    }

    public static void show(Complex[] x, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        int i = 0;
        while (i < x.length) {
            System.out.println(String.valueOf(x[i].getReal()) + "+" + x[i].getImaginary() + "i");
            ++i;
        }
        System.out.println();
    }

    public static void main(String[] args) {
        int N = 4;
        Complex[] x = new Complex[N];
        int i = 0;
        while (i < N) {
            x[i] = new Complex((double)i, 0.0);
            x[i] = new Complex(-2.0 * Math.random() + 1.0, 0.0);
            ++i;
        }
        FFT.show(x, "x");
        Complex[] y = FFT.fft(x);
        FFT.show(y, "y = fft(x)");
        Complex[] z = FFT.ifft(y);
        FFT.show(z, "z = ifft(y)");
        Complex[] c = FFT.cconvolve(x, x);
        FFT.show(c, "c = cconvolve(x, x)");
        Complex[] d = FFT.convolve(x, x);
        FFT.show(d, "d = convolve(x, x)");
    }
}

