/*
 * Decompiled with CFR 0.152.
 */
package krause.common.gui.test;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

class RoundButton
extends JButton {
    protected Shape shape;
    protected Shape base;

    public RoundButton(Icon icon, String i2, String i3) {
        super(icon);
        this.setPressedIcon(new ImageIcon(this.getClass().getResource(i2)));
        this.setRolloverIcon(new ImageIcon(this.getClass().getResource(i3)));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setBackground(Color.BLACK);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setAlignmentY(0.0f);
        this.initShape();
    }

    @Override
    public Dimension getPreferredSize() {
        Icon icon = this.getIcon();
        Insets i = this.getInsets();
        int iw = Math.max(icon.getIconWidth(), icon.getIconHeight());
        return new Dimension(iw + i.right + i.left, iw + i.top + i.bottom);
    }

    protected void initShape() {
        if (!this.getBounds().equals(this.base)) {
            Dimension s = this.getPreferredSize();
            this.base = this.getBounds();
            this.shape = new Ellipse2D.Float(0.0f, 0.0f, s.width - 1, s.height - 1);
        }
    }

    @Override
    protected void paintBorder(Graphics g) {
        this.initShape();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBackground());
        g2.draw(this.shape);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public boolean contains(int x, int y) {
        this.initShape();
        return this.shape.contains(x, y);
    }
}

