/*
  23/13cm Umschaltung incl. CAT Steuerung
 DG1ATN

 23 cm ist Bootzustand; wird auf 7 MHz umgesetzt
 13 cm schaltet das Relay; wird auf 28 MHz umgesetzt
WinTest Einstellungen
> 7 MHz for 23 cm - Offset at 1289.0 MHz
> 28 MHz for 13 cm - Offset to 2292.0 MHz


 The circuit:
 * LCD RS pin to digital pin 12
 * LCD Enable pin to digital pin 11
 * LCD D4 pin to digital pin 5
 * LCD D5 pin to digital pin 4
 * LCD D6 pin to digital pin 3
 * LCD D7 pin to digital pin 2
 * LCD R/W pin to ground
 * LCD VSS pin to ground
 * LCD VCC pin to 5V
 * 10K resistor:
 * ends to +5V and ground
 * wiper to LCD VO pin (pin 3)

 * TX Pin für TRX Software Serial digital pin 8
 * RX Pin für TRX Software Serial digital pin 9

 * Taster digital pin 7 330 Ohm Pull up
 * Relay oder LED pin 6

 * Leistungseinstellungen für FT-817
 * bool FT817 = true;
 * Es wird dirket in den Speicher vom 817 geschrieben.
 * Daten werden im Vorfeld ausgelesen und anschließend neu geschreiben

 */

// include the library code:
#include <LiquidCrystal.h>
#include <SoftwareSerial.h>

LiquidCrystal lcd(12, 11, 5, 4, 3, 2);
SoftwareSerial TRX(9, 8); // RX, TX
static int TRX_baud = 9600;
int tasterPin = 7;
int relayPin = 6;

char data[6];
char freq[6] = {
  0x14, 0x41, 0x50, 0x00, 0x01
};
char mode[6] = {
  0x01, 0x00, 0x00, 0x00, 0x07
};
char split[6] = {
  0x00, 0x00, 0x00, 0x00, 0x82
};
char clar[6] = {
  0x00, 0x00, 0x00, 0x00, 0x85
};
char rTRX[6] = {
  0x00, 0x00, 0x00, 0x00, 0x03
};
char eFT817[6] = {
  0x00, 0x79, 0x03, 0x33, 0xBC
};

bool SHF = false;
bool readTRX = false;
bool freeRun = true;
bool eprom = false;
bool inet = false;
bool FT817 = true;

byte i = 0;

void setup() {
  // set up the LCD's number of columns and rows:
  lcd.begin(16, 4);
  // Print a message to the LCD.
  lcd.setCursor(0, 0);
  lcd.print("DG1ATN 23/13cm ");
  lcd.setCursor(0, 1);
  lcd.print("Free Run");
  Serial.begin(9600);

  TRX.begin(TRX_baud);

  if (FT817) {
    while (i < 5) {
      TRX.write(eFT817[i]);
      i++;
    }
  } else {
    while (i < 5) {
      TRX.write(split[i]);
      i++;
    }
  }

  delay(100);

  i = 0;

  while (i < 5) {
    TRX.write(clar[i]);
    i++;
  }

  delay(100);

  i = 0;
  while (i < 5) {
    TRX.write(freq[i]);
    i++;
  }

  delay(100);

  i = 0;
  while (i < 5) {
    TRX.write(mode[i]);
    i++;
  }

  i = 0;

  pinMode(tasterPin, INPUT);
  pinMode(relayPin, OUTPUT);

  inet = true;
}

void loop() {
  if (digitalRead(tasterPin) == LOW) {
    SHF = !SHF;
  }
  if (SHF) {
    digitalWrite(relayPin, HIGH);
  }
  else if (!SHF) {
    digitalWrite(relayPin, LOW);
  }

  char inChar;
  while (Serial.available()) {
    inChar = (byte)Serial.read();
    data[i] = inChar;
    i++;
    if ((i == 5) && (inChar == 0x03)) {
      readTRX = true;
      if (freeRun) {
        lcd.clear();
        lcd.setCursor(0, 1);
        lcd.print("CAT Mode");
        freeRun = false;
      }
    }
    if ((i == 5) && (inChar == 0x01)) {

      memcpy(freq, data, sizeof(data));

      freq[0] = 0x14;
      freq[1] = freq[1] & 0x0F;
      freq[1] = freq[1] | 0x40;

      int Hz = int(data[3] & 0x0F);
      Hz += 10 * int((data[3] >> 4) & 0x0F);

      int kHz = int(data[2] & 0x0F);
      kHz += 10 * int((data[2] >> 4) & 0x0F);
      kHz += 100 * int(data[1] & 0x0F);

      int MHz = int((data[1] >> 4) & 0x0F);
      MHz += 10 * int(data[0] & 0x0F);
      MHz += 100 * int((data[0] >> 4) & 0x0F);

      //lcd.setCursor(0,1);
      //lcd.print(MHz);

      if (MHz > 20) {
        MHz = 2320;
        SHF = true;
      }
      if (MHz < 20) {
        MHz = 1296;
        SHF = false;
      }


      TRX.write(freq[0]);
      TRX.write(freq[1]);
      TRX.write(freq[2]);
      TRX.write(freq[3]);
      TRX.write(freq[4]);

      i = 0;
    }
    if ((i == 5) && (inChar != 0x01)) {
      i = 0;

      //lcd.setCursor(0, 1);
      //lcd.print(byte(data[0]), HEX);
      //lcd.print(byte(data[1]), HEX);
      //lcd.print(byte(data[2]), HEX);
      //lcd.print(byte(data[3]), HEX);
      //lcd.print(byte(data[4]), HEX);

      if (inChar == 0x00)
        i = 4;
      if (inChar != 0x00) {
        TRX.write(data[0]);
        TRX.write(data[1]);
        TRX.write(data[2]);
        TRX.write(data[3]);
        TRX.write(data[4]);

        if (byte(data[4]) == 0xBB) {
          eprom = true;
        }


      }

    }
  }
  while (TRX.available()) {

    inChar = (byte)TRX.read();
    data[i] = inChar;

    if (inet) {
      delay(100);
    }

//lcd.setCursor(14,1);
//lcd.print(i,DEC);
//
//lcd.setCursor(i*2, 1);
//lcd.print(byte(data[i]), HEX);

    i++;
    if ((readTRX) && (data[0] != 0x14)) {
      i --;
    }
    if ((inet) && (data[0] == 0xF0)) {
      i --;
    }

    if ((i == 4) && (inet)) {
      inet = false;
      i = 0;
    }

    if ((i == 2) && (eprom)) {
      i = 0;
      eprom = false;
      Serial.write(data[0]);
      Serial.write(data[1]);

    }
    if (i == 5) {
      if (!readTRX) {
        if (!freeRun) {
          Serial.write(data[0]);
          Serial.write(data[1]);
          Serial.write(data[2]);
          Serial.write(data[3]);
          Serial.write(data[4]);
        }
        i = 0;
      }

      if ((readTRX) && (data[0] == 0x14)) {
        memcpy(freq, data, sizeof(data));

        int Hz = int(data[3] & 0x0F);
        Hz += 10 * int((data[3] >> 4) & 0x0F);

        int kHz = int(data[2] & 0x0F);
        kHz += 10 * int((data[2] >> 4) & 0x0F);
        kHz += 100 * int(data[1] & 0x0F);
        //      int kHz = h+z+e;

        int MHz;

        if (!SHF) {
          MHz = 1296;
          freq[0] = 0x00;
          freq[1] = freq[1] & 0x0F;
          freq[1] = freq[1] | 0x70;
        }
        if (SHF) {
          MHz = 2320;
          freq[0] = 0x02;
          freq[1] = freq[1] & 0x0F;
          freq[1] = freq[1] | 0x80;
        }


        lcd.setCursor(0, 0);
        lcd.print(MHz, DEC);
        lcd.print(".");
        if (kHz < 100)
          lcd.print("0");
        if (kHz < 10)
          lcd.print("0");
        lcd.print(kHz, DEC);
        lcd.print(".");
        if (Hz < 10)
          lcd.print("0");
        lcd.print(Hz, DEC);
        lcd.print(" MHz  ");

        if (!freeRun) {
          Serial.write(freq[0]);
          Serial.write(freq[1]);
          Serial.write(freq[2]);
          Serial.write(freq[3]);
          Serial.write(freq[4]);
        }
        i = 0;
        readTRX = false;

      }
    }
  }
  if (freeRun) {
    int j = 0;
    while (j < 5) {
      TRX.write(rTRX[j]);
      j ++;
    }
    delay(100);
    i = 0;
    readTRX = true;
  }
}



