unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, LibUSB, ComCtrls, Math, Buttons, ExtCtrls, Menus;

var
USBDEV_SHARED_VENDOR  : integer=  $16C0;  (* VOTI *)
USBDEV_SHARED_PRODUCT : integer=  $05DC;  (* Obdev's free shared PID *)
USBDEV_WEB: pchar='www.obdev.at';
USBDEV_DEVNUM: BYTE=1;

type
//new structure
 t_lin = packed record  	//data set per segment lin mode: 14 byte
	npoints: WORD;		//loc 0: number of data points
	mRF: BYTE;	     	//loc 2: clock multiplier
	mLO: BYTE;	     	//loc 3: clock multiplier
        fracRF: byte;           //loc 4: fraction RF start FTW/ml
	startRF: cardinal; 	//loc 5: integer RF start FTW/ml
	deltaRF: array[0..5] of BYTE;//loc 9: RF FTW increment
        end;

t_log = packed record  	        //data set per segment lin mode: 18 byte
        npoints: WORD;		//loc 0: number of data points
	mRF: BYTE;	     	//loc 2: clock multiplier
	mLO: BYTE;	     	//loc 3: clock multiplier
        startRF: array[0..6] of BYTE;//loc 4: RF start FTW
	alfa:    array[0..6] of BYTE;//loc11: RF FTW increment
        end;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    StatusBar1: TStatusBar;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label15: TLabel;
    Button1: TButton;
    Button4: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Button2: TButton;
    E0: TEdit;
    E1: TEdit;
    E2: TEdit;
    E3: TEdit;
    E4: TEdit;
    ELen: TEdit;
    E7: TEdit;
    E6: TEdit;
    E5: TEdit;
    EditName: TEdit;
    ComboBox1: TComboBox;
    Button3: TButton;
    EText: TEdit;
    Button5: TButton;
    Edit4: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function usbOpenDevice(var device: Pusb_dev_handle; vendor: Integer; vendorName: pchar ;product: Integer; productName: pchar; devicenum: BYTE):  Integer;

  end;

var
  Form1: TForm1;

implementation

type
 TPString = array [0..255] of Char;

(* Use obdev's generic shared VID/PID pair and follow the rules outlined
 * in firmware/usbdrv/USBID-License.txt.
 *)

 const
(* Command declarations *)
CMD_ECHO      = 0;
CMD_GETMEM    = 1;
CMD_SETMEM    = 2;
CMD_GETLOADR  = 7;

type TDevice=record
  VID: integer;
  PID: integer;
  vendorstring: string;
  product: string;
  serial: string;
  devnum: BYTE;
  end;

var devices: array of TDevice;
    device: integer=0;


{$R *.dfm}

function floattostr(x: double): string; overload;
begin
Result:=Format('%15.6f',[x])
end;

procedure usb_showinfo;

  procedure print_endpoint(endpoint: usb_endpoint_descriptor);
  begin
    Form1.ListBox1.AddItem('      bEndpointAddress: '+ IntToHex(endpoint.bEndpointAddress,2)+ 'h',nil);
    Form1.ListBox1.AddItem('      bEndpointAddress: '+ IntToHex(endpoint.bEndpointAddress,2)+ 'h',nil);
    Form1.ListBox1.AddItem('      bmAttributes:     '+ IntToHex(endpoint.bmAttributes, 2)+ 'h',nil);
    Form1.ListBox1.AddItem('      wMaxPacketSize:   '+ IntToStr(endpoint.wMaxPacketSize),nil);
    Form1.ListBox1.AddItem('      bInterval:        '+ IntToStr(Cardinal(endpoint.bInterval)),nil);
    Form1.ListBox1.AddItem('      bRefresh:         '+ IntToStr(Cardinal(endpoint.bRefresh)),nil);
    Form1.ListBox1.AddItem('      bSynchAddress:    '+ IntToStr(Cardinal(endpoint.bSynchAddress)),nil);
  end;

  procedure print_altsetting(iinterface: usb_interface_descriptor);
  var
    I: integer;
  begin
    Form1.ListBox1.AddItem('    bInterfaceNumber:   '+ IntToStr(Cardinal(iinterface.bInterfaceNumber)),nil);
    Form1.ListBox1.AddItem('    bAlternateSetting:  '+ IntToStr(Cardinal(iinterface.bAlternateSetting)),nil);
    Form1.ListBox1.AddItem('    bNumEndpoints:      '+ IntToStr(Cardinal(iinterface.bNumEndpoints)),nil);
    Form1.ListBox1.AddItem('    bInterfaceClass:    '+ IntToStr(Cardinal(iinterface.bInterfaceClass)),nil);
    Form1.ListBox1.AddItem('    bInterfaceSubClass: '+ IntToStr(Cardinal(iinterface.bInterfaceSubClass)),nil);
    Form1.ListBox1.AddItem('    bInterfaceProtocol: '+ IntToStr(Cardinal(iinterface.bInterfaceProtocol)),nil);
    Form1.ListBox1.AddItem('    iInterface:         '+ IntToStr(Cardinal(iinterface.iInterface)),nil);

    for I := 0 to iinterface.bNumEndpoints-1 do
      begin
        print_endpoint(iinterface.endpoint[I]);
      end;
  end;

  procedure print_interface(iinterface: usb_interface);
  var
    I: integer;
  begin
    for I := 0 to iinterface.num_altsetting-1 do
      begin
        print_altsetting(iinterface.altsetting[I]);
      end;
  end;

  procedure print_configuration(config: usb_config_descriptor);
  var
    I: integer;
  begin
    Form1.ListBox1.AddItem('  wTotalLength:         '+ inttostr(config.wTotalLength),nil);
    Form1.ListBox1.AddItem('  bNumInterfaces:       '+ inttostr(cardinal(config.bNumInterfaces)),nil);
    Form1.ListBox1.AddItem('  bConfigurationValue:  '+ inttostr(cardinal(config.bConfigurationValue)),nil);
    Form1.ListBox1.AddItem('  iConfiguration:       '+ inttostr(cardinal(config.iConfiguration)),nil);
    Form1.ListBox1.AddItem('  bmAttributes:         '+ IntToHex(config.bmAttributes, 2)+ 'h',nil);
    Form1.ListBox1.AddItem('  MaxPower:             '+ inttostr(cardinal(config.MaxPower)),nil);

  for I := 0 to config.bNumInterfaces-1 do
    begin
      print_interface(config.iinterface[I]);
    end;
  end;

var
  bus: pusb_bus;
  dev: pusb_device;
  udev: pusb_dev_handle;
  ret,
  I: integer;
  S: array [0..255] of char;
begin
  usb_init; // Initialize libusb


  usb_find_busses; // Finds all USB busses on system
  usb_find_devices; // Find all devices on all USB devices
  bus := usb_get_busses; // Return the list of USB busses found
  Form1.ListBox1.AddItem('bus/device  idVendor/idProduct',nil);
  while Assigned(bus) do
    begin
      dev := bus^.devices;
      while Assigned(dev) do
        begin
          SetLength(Devices, Length(Devices)+1);
          Form1.ListBox1.AddItem(
                  string(bus^.dirname)+ '/'+string( dev^.filename)+
                  '     '+
                  '0x' + IntToHex(dev^.descriptor.idVendor, 4)+
                  '/'+
                  '0x' + IntToHex(dev^.descriptor.idProduct, 4),nil);
          Devices[High(Devices)].VID:=dev^.descriptor.idVendor;
          Devices[High(Devices)].PID:=dev^.descriptor.idProduct;
          udev := usb_open(dev);
          if Assigned(udev) then
            begin
              Devices[High(Devices)].devnum:=dev^.devnum;
              if dev^.descriptor.iManufacturer > 0 then
                begin
                  ret := usb_get_string_simple(udev, dev^.descriptor.iManufacturer, S, sizeof(S));
                  if (ret > 0) then
                    begin
                      Devices[High(Devices)].vendorstring:=s;
                      Form1.ListBox1.AddItem('- Manufacturer : '+ S,nil);
                    end
                    else
                    begin
                      Devices[High(Devices)].vendorstring:='';
                      Form1.ListBox1.AddItem('- Unable to fetch manufacturer string',nil);
                    end;
                end;

              if (dev^.descriptor.iProduct > 0) then
                begin
                  ret := usb_get_string_simple(udev, dev^.descriptor.iProduct, S, sizeof(S));
                  if (ret > 0) then
                    begin
                      Devices[High(Devices)].product:=s;
                      Form1.ListBox1.AddItem('- Product      : '+ S,nil);
                    end
                    else
                    begin
                      Form1.ListBox1.AddItem('- Unable to fetch product string',nil);
                      Devices[High(Devices)].product:='';
                    end;
                end;

              if (dev^.descriptor.iSerialNumber > 0) then
                begin
                  ret := usb_get_string_simple(udev, dev^.descriptor.iSerialNumber, S, sizeof(S));
                  if (ret > 0) then
                    begin
                      Form1.ListBox1.AddItem('- Serial Number: '+ S,nil);
                      Devices[High(Devices)].serial:=s;
                    end
                    else
                    begin
                      Form1.ListBox1.AddItem('- Unable to fetch serial number string',nil);
                      Devices[High(Devices)].serial:='';
                    end;
                end;

              usb_close(udev);
            end;

          if not assigned(dev^.config) then
            begin
              Form1.ListBox1.AddItem('  Couldn''t retrieve descriptors',nil);
              continue;
            end;

          for I := 0 to dev^.descriptor.bNumConfigurations-1 do
            begin
              print_configuration(dev^.config[i]);
            end;

          dev := dev^.next;
        end;

      bus := bus^.next;
    end;
end;

//////////////////////////////////////////////////////////////

function usbGetStringAscii(handle: pusb_dev_handle; index: Integer;langid: Integer;var buf: TPString;buflen: Integer ): integer;
var
 buffer: array [0..255] of char;
 rval, i: Integer;
begin
    rval := usb_control_msg(handle, USB_ENDPOINT_IN, USB_REQ_GET_DESCRIPTOR, (USB_DT_STRING shl 8) + index, langid, buffer, sizeof(buffer), 1000);
    result:=rval;
    if rval < 0 then exit;
    result:=0;
    if buffer[1] <> char(USB_DT_STRING) then Exit;
    if BYTE(buffer[0]) < rval then
        rval := BYTE(buffer[0]);

    rval:= rval div 2;
    (* lossy conversion to ISO Latin1 *)
    for i := 1 to rval-1 do
      begin
        if i > buflen then  (* destination buffer overflow *)
            break;
        buf[i-1] := buffer[2 * i];
        if buffer[2 * i + 1] <> #0 then (* outside of ISO Latin1 range *)
            buf[i-1] := char('?');
      end;
    buf[i-1] := #0;
    Result := i-1;
end;

(* DDS uses the free shared default VID/PID. If you want to see an
 * example device lookup where an individually reserved PID is used, see our
 * RemoteSensor reference implementation.
 *)

const
  USB_ERROR_NOTFOUND = 1;
  USB_ERROR_ACCESS   = 2;
  USB_ERROR_IO       = 3;


function TForm1.usbOpenDevice(var device: Pusb_dev_handle; vendor: Integer; vendorName: pchar ;product: Integer; productName: pchar; devicenum: BYTE):  Integer;
const
{$J+}
   didUsbInit: integer = 0; //not a true constant but a static variable
{$J-}
var
  bus: Pusb_bus;
  dev: Pusb_device;
  handle: Pusb_dev_handle;
  errorCode: integer;
  S: TPstring;
  len: Integer;
begin
handle:=nil;
errorCode := USB_ERROR_NOTFOUND;
    if didUsbInit=0 then
      begin
        didUsbInit := 1;
        usb_init;
      end;
    usb_find_busses;
    usb_find_devices;
    bus := usb_get_busses;
    While assigned(bus) do
      begin
        dev := bus^.devices;
        while assigned(dev) do
          begin
            if(dev.descriptor.idVendor = vendor) and (dev.descriptor.idProduct = product) then
              begin
                handle := usb_open(dev); (* we need to open the device in order to query strings *)
                if not assigned(handle) then
                  begin
                    errorCode := USB_ERROR_ACCESS;
                    raise Exception.Create('Warning: cannot open USB device '+usb_strerror());
                    continue;
                  end;
                if (vendorName = nil) and (productName = nil) then break; (* name does not matter *)
                (* now check whether the names match: *)
                len := usbGetStringAscii(handle, dev.descriptor.iManufacturer, $0409,S, sizeof(S));
                if (len < 0) then
                  begin
                    errorCode := USB_ERROR_IO;
                    raise Exception.Create('Warning: cannot query manufacturer for device: '+usb_strerror());
                  end
                 else
                  begin
                    errorCode := USB_ERROR_NOTFOUND;
                    (* fprintf(stderr, "seen device from vendor ->%s<-\n", string); *)
                    if StrPas(S)=vendorName then 
                      begin
                        len := usbGetStringAscii(handle, dev.descriptor.iProduct, $0409,S, sizeof(S));
                        if (len < 0) then
                          begin
                            errorCode := USB_ERROR_IO;
                            raise Exception.Create('Warning: cannot query product for device: '+usb_strerror());
                          end
                         else
                          begin
                            errorCode := USB_ERROR_NOTFOUND;
                            (* fprintf(stderr, "seen product ->%s<-\n", string); *)
                            if (StrPas(S)=productName) and (dev^.devnum=devicenum) then
                                break;
                          end;  //if len
                      end; //if string_
                  end;  //if len<0
                usb_close(handle);
                handle := nil;
              end;  //if dev descriptor
            dev := dev.next;
          end;  //while assigned(dev)
        if handle<>nil then break;
        bus := bus.next;
      end;  //while assigned(bus)
    if (handle <> nil) then
      begin
        errorCode := 0;
        device := handle;
      end;
Result := errorCode;
end;

procedure TForm1.Button1Click(Sender: TObject);
var i: integer;
begin
ListBox1.Clear;
SetLength(Devices,0);
usb_showinfo;
ComboBox1.Clear;
for i:=0 to length(Devices)-1 do
  ComboBox1.AddItem(
    inttostr(Devices[i].devnum)+':  '+
    Devices[i].product+'  '+
    Devices[i].vendorstring+'  '+
    Devices[i].serial+
    '  VID=0x'+inttohex(Devices[i].VID,4)+
    '  PID=0x'+inttohex(Devices[i].PID,4)
    ,nil);
if length(Devices)=0 then exit;
ComboBox1.ItemIndex:=Device;
EditName.Text:=Devices[Device].product;
USBDEV_SHARED_VENDOR  :=Devices[Device].VID;
USBDEV_SHARED_PRODUCT :=Devices[Device].PID;
USBDEV_WEB:=PChar(Devices[Device].vendorstring);
USBDEV_DEVNUM:=Devices[Device].devnum;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  handle: Pusb_dev_handle;
  buffer: array[0..7] of char;
  request, value, index: integer;
  retval: string;
  i: integer;
begin
//ListBox1.Clear;
buffer[0]:=#0;
buffer[1]:=#0;
buffer[2]:=#0;
request:=strtoint('$'+Edit1.Text);
value:=strtoint('$'+edit2.Text);
index:=strtoint('$'+edit3.Text);
usb_init();
if (usbOpenDevice(handle, USBDEV_SHARED_VENDOR, USBDEV_WEB, USBDEV_SHARED_PRODUCT, pchar(EditName.Text), USBDEV_DEVNUM) <> 0) then
  begin
    raise Exception.Create(Format(
       'Could not find USB device '+EditName.Text+' with vid=$%x and pid=$%x !',
          [USBDEV_SHARED_VENDOR, USBDEV_SHARED_PRODUCT]));
        exit;
    end;
value:=usb_control_msg(handle, USB_TYPE_VENDOR or USB_RECIP_DEVICE or USB_ENDPOINT_IN, request, value, index, buffer, sizeof(buffer), 5000);
usb_close(handle);
retval:=inttostr(value)+'';
Label3.Caption:=retval+' USB transfer return bytes = ';
for i:=value-1 downto 0 do Label3.Caption:=Label3.Caption+inttoHex(BYTE(buffer[i]),2);
Label3.Caption:=Label3.Caption+' Hex';
ListBox1.AddItem('Done',nil);
end;



procedure TForm1.FormCreate(Sender: TObject);
var noerror: boolean;
    s: string;
begin
VertScrollBar.Visible:=false;
HorzScrollBar.Visible:=false;
Label3.Caption:='USB transfer return value = ';
E0.Text:='05';
E1.Text:='00';
E2.Text:='00';
E3.Text:='02';
E4.Text:='00';
E5.Text:='00';
E6.Text:='00';
E7.Text:='00';
Elen.Text:='04';
Button1Click(Sender);
ListBox1.Clear;
ListBox1.AddItem(s,nil);
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  handle: Pusb_dev_handle;
  buffer: array[0..7] of char;
  request, value, index,len: integer;
  retval: string;
begin
buffer[0]:=char(strtoint('$'+E0.Text));
buffer[1]:=char(strtoint('$'+E1.Text));
buffer[2]:=char(strtoint('$'+E2.Text));
buffer[3]:=char(strtoint('$'+E3.Text));
buffer[4]:=char(strtoint('$'+E4.Text));
buffer[5]:=char(strtoint('$'+E5.Text));
buffer[6]:=char(strtoint('$'+E6.Text));
buffer[7]:=char(strtoint('$'+E7.Text));
len:=strtoint('$'+Elen.Text);
request:=strtoint('$'+Edit1.Text);
value:=strtoint('$'+edit2.Text);
index:=strtoint('$'+edit3.Text);
usb_init();
if (usbOpenDevice(handle, USBDEV_SHARED_VENDOR, USBDEV_WEB, USBDEV_SHARED_PRODUCT, pchar(EditName.Text), USBDEV_DEVNUM) <> 0) then
  begin
    raise Exception.Create(Format(
       'Could not find USB device '+EditName.Text+' with vid=$%x and pid=$%x !',
          [USBDEV_SHARED_VENDOR, USBDEV_SHARED_PRODUCT]));
        exit;
    end;
value:=usb_control_msg(handle, USB_TYPE_VENDOR or USB_RECIP_DEVICE or USB_ENDPOINT_OUT, request, value, index, buffer, len, 5000);
usb_close(handle);
retval:=inttostr(value)+'';
Label3.Caption:=retval+' USB transfer return bytes = '
                +inttoHex(BYTE(buffer[0])+256*BYTE(buffer[1])+256*256*BYTE(buffer[2])+256*256*256*BYTE(buffer[3]),2*value)+' Hex';
end;

type buffer=array of byte;  //assign as Dynamic array
var HexBuf:buffer;



function readline(HexLine:string; var Buf:buffer):integer;
var ADDR,count:integer;
 CHKSUM,SUMLINE,RECLEN,RECTYPE,DATA:byte;
 t:shortstring;
begin
 if HexLine[1]=':' then begin
  t:='$'+copy(HexLine,2,2);   // get length
  RECLEN:=strtoint(t);
  CHKSUM:=0;
  CHKSUM:=CHKSUM+RECLEN;
  t:='$'+copy(HexLine,4,4); // get address
  ADDR:=strtoint(t);
  CHKSUM:=CHKSUM+lo(ADDR)+hi(ADDR);
  t:='$'+copy(HexLine,8,2);
  RECTYPE:=strtoint(t);
  CHKSUM:=CHKSUM+RECTYPE;
  case RECTYPE of
   0:begin             // datablock
     count:=0;
     while (count < RECLEN) do begin
      t:='$'+copy(HexLine,10+2*count,2);
      DATA:=strtoint(t);
      CHKSUM:=CHKSUM+DATA;
      Buf[ADDR+count]:=DATA;
      inc(count);
     end;
     t:='$'+copy(HexLine,10+2*count,2);
     SUMLINE:=strtoint(t);
     end;
   1:begin			// end of file
      t:='$'+copy(HexLine,10,2);
      SUMLINE:=strtoint(t);
      result:=1;
     end;
     else
     begin
        result := -2;  // invalid record type
        exit;
     end;
    end; //case
  // test checksum
  DATA:=SUMLINE+CHKSUM;
  if (DATA<>0) then result:=-3; // checksum error
 end
 else result:=-1; // no record
end;



function writeline(adr,len:integer; var buf:array of byte):shortstring;
var i:integer;
 csum:byte;
begin
 csum:=0;
 result:=':'+inttohex(len,2)+inttohex(adr,4)+'00';
 {$R-} csum:=len+lo(adr)+hi(adr);{$R+}
 for i:=0 to len-1 do begin
  result:=result+inttohex(buf[adr+i],2);
  {$R-}csum:=csum+buf[adr+i];{$R+}
 end;
 result:=result+inttohex((-csum) and $FF,2);
end;

function write_eof(startadr:integer):shortstring;
var csum:byte;
begin
 result:=':00'+inttohex(startadr,4)+'01';
 csum:=hi(startadr)+lo(startadr)+1;
 result:=Result+inttohex((-csum) and $FF,2);
end;

procedure WriteIntelHexFile(fname:string; adr, usedbuf: integer; var buf:array of byte);
var Fp: TextFile;
    i : integer;
begin
AssignFile(Fp,Fname); { File selected in dialog }
Rewrite(Fp);
for i:=0 to ((usedbuf-1) div 16) do begin
  writeln(Fp,writeline(adr,16,buf));
  adr:=adr+16;
end;
if (usedbuf>adr) then
writeln(Fp,writeline(adr,(usedbuf mod 16),buf));
writeln(Fp,write_eof(0));
closefile(Fp);
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
Device:=ComboBox1.ItemIndex;
EditName.Text:=Devices[Device].product;
USBDEV_SHARED_VENDOR  :=Devices[Device].VID;
USBDEV_SHARED_PRODUCT :=Devices[Device].PID;
USBDEV_WEB:=PChar(Devices[Device].vendorstring);
USBDEV_DEVNUM:=Devices[Device].devnum;
end;


procedure TForm1.Button3Click(Sender: TObject);
var
  handle: Pusb_dev_handle;
  buffer: array[0..31] of char;
  request, value, index: integer;
  retval: string;
  i: integer;
begin
ListBox1.Clear;
buffer[0]:=#0;
buffer[1]:=#0;
buffer[2]:=#0;
value:=0;
index:=0;
usb_init();
if (usbOpenDevice(handle, USBDEV_SHARED_VENDOR, USBDEV_WEB, USBDEV_SHARED_PRODUCT, pchar(EditName.Text), USBDEV_DEVNUM) <> 0) then
  begin
    raise Exception.Create(Format(
       'Could not find USB device '+EditName.Text+' with vid=$%x and pid=$%x !',
          [USBDEV_SHARED_VENDOR, USBDEV_SHARED_PRODUCT]));
        exit;
    end;
request:=$11;   //reset TX Buffer
usb_control_msg(handle, USB_TYPE_VENDOR or USB_RECIP_DEVICE or USB_ENDPOINT_IN, request, value, index, buffer, sizeof(buffer), 5000);
request:=$10;
for i:=1 to length(EText.Text) do
  begin
    value:=byte(EText.Text[i]);
    usb_control_msg(handle, USB_TYPE_VENDOR or USB_RECIP_DEVICE or USB_ENDPOINT_IN, request, value, index, buffer, sizeof(buffer), 5000);   //send char
  end;
for i:=0 to 50 do
  begin
    Application.ProcessMessages;
    sleep(10);
  end;
for i:=0 to high(buffer) do buffer[i]:=#0;
request:=$12;
usb_control_msg(handle, USB_TYPE_VENDOR or USB_RECIP_DEVICE or USB_ENDPOINT_IN, request, value, index, buffer, sizeof(buffer), 5000);       //read answer
i:=0;
retval:='';
while (buffer[i]<>#0) and (i<high(buffer)) do
  begin
    retval:=retval+buffer[i];
    inc(i);
  end;
ListBox1.AddItem('Received: '+retval,nil);
request:=$13;
usb_control_msg(handle, USB_TYPE_VENDOR or USB_RECIP_DEVICE or USB_ENDPOINT_IN, request, value, index, buffer, sizeof(buffer), 5000);       //clear RX Buf
usb_close(handle);
ListBox1.AddItem('Done',nil);
end;

procedure TForm1.Button5Click(Sender: TObject);
var
  handle: Pusb_dev_handle;
  buffer: array[0..7] of char;
  request, value, index: integer;
  retval: string;
  i: integer;
begin
ListBox1.Clear;
buffer[0]:=#0;
buffer[1]:=#0;
buffer[2]:=#0;
request:=$20;
value:=strtoint(edit4.Text);
index:=0;
usb_init();
if (usbOpenDevice(handle, USBDEV_SHARED_VENDOR, USBDEV_WEB, USBDEV_SHARED_PRODUCT, pchar(EditName.Text), USBDEV_DEVNUM) <> 0) then
  begin
    raise Exception.Create(Format(
       'Could not find USB device '+EditName.Text+' with vid=$%x and pid=$%x !',
          [USBDEV_SHARED_VENDOR, USBDEV_SHARED_PRODUCT]));
        exit;
    end;
value:=usb_control_msg(handle, USB_TYPE_VENDOR or USB_RECIP_DEVICE or USB_ENDPOINT_IN, request, value, index, buffer, sizeof(buffer), 5000);
ListBox1.AddItem('Done',nil);
end;

end.


