
//#define REVERSE_WHEEL_ORIENTATION
#define ON_KEY_PRESSED (PIND&0x80)==0

signed	char		menu;
char				select=0;
char blockButton = 0;

void TurnWheelInit(void){
DDRB=DDRB & ~3;							//turnmenu input lines
PORTB=PORTB | 3;						//pull-ups
DDRD=DDRD & ~0x80;						//button input line
PORTD=PORTD | 0x80;						//pull-up
PCICR  |= (1<<PCIE0) | (1<<PCIE2);
PCMSK0 |= (1<<PCINT1) ;				 	//  enable turnmenu interrupts (demoboard with Preh uses PCINT0, Panasonic uses PCINT1)
PCMSK2 |= (1<<PCINT23); 				//  button interrupt
}

extern void Bluetooth(char on);

ISR(PCINT0_vect)			//menu interrupt
{
int a=0;
int b=0;
if (blockButton==1) return;
channel=' ';
char x=PINB;
char c=(x & 0x1);			//get turnmenu input state
char d=(x & 0x2)>>1;		//get other turnmenu input state which causes interrupt
#define UP c!=d
if (select==1)
	{
#ifdef REVERSE_WHEEL_ORIENTATION
	if (UP) menu--; else menu++;
#else
	if (UP) menu++; else menu--;
#endif
	if (menu==-1) menu=0;
	if (menu>MAXMENU) menu=MAXMENU;
	}else{ 				//select = 0
	switch (menu){		//normal display mode
	  case MENU_ATT:
		a=atten;
		b=pgm_read_byte(&steps[step]);
#ifdef REVERSE_WHEEL_ORIENTATION
		if (UP) a=a-b; else a=a+b;
#else
		if (UP) a=a+b; else a=a-b;
#endif
		if (a<0) {
			//atten=0;
			break;
			}
		if (a>MAX_ATTEN) break;
		atten=a;
	  	break;
	  case MENU_STEP:
	  	a=step;
#ifdef REVERSE_WHEEL_ORIENTATION
 		if (UP) a--; else a++; 
#else
		if (UP) a++; else a--;
#endif
		if (a<0) break;
		if (a>MAXSTEP) break;
		step=a;
	  	break;
	  case MENU_BT_OFF:
	    BT_on=1-BT_on;
		Bluetooth(BT_on);
		break;
		}
	}
}



ISR(PCINT2_vect)			//button interrupt
{
channel=' ';
if (ON_KEY_PRESSED) return; 
if (select!=0) select=0; else select=1;
//LCD_HexByte(ON_KEY_PRESSED,10);
}


