/* Name: timer.h
 * Project: VNA based on ObDev's PowerSwitch based on AVR USB driver
 * Author: Thomas Baier DG8SAQ (DDS extensions)
 * Creation Date: 2007-07-14
 * Copyright: (c) 2007 by DG8SAQ
 * License: GNU GPL v2 (see License.txt) or proprietary (CommercialLicense.txt)
 * This Revision: 
 */


 //Timer0 Settings
#define TIMER0_OFF 		0
#define TIMER0_DIV1		1 
#define TIMER0_DIV8		2 
#define TIMER0_DIV64	3 
#define TIMER0_DIV256	4 
#define TIMER0_DIV1024	5
#define TIMER0_T0_FALL	6 
#define TIMER0_T0_RISE	7
#define FAST_PWM_OC0A_ON	(1<<COM0A1) |(1<<COM0A0) |  (1<<WGM01)|(1<<WGM00)
#define FAST_PWM_OC0A_OFF	(1<<COM0A1) 			 |  (1<<WGM01)|(1<<WGM00)
#define FAST_PWM_OC0X_OFF								(1<<WGM01)|(1<<WGM00)
#define NORMAL_OC0X_OFF		0


//Timer1 Settings
#define FAST_PWM_MODE	(1<<WGM13) | (1<<WGM12)	//Top OCR1A, Interrupt at overflow;
#define TIMER_OFF  		(0	<<  CS10) | FAST_PWM_MODE
#define TIMER_DIV1 		(1	<<  CS10) | FAST_PWM_MODE
#define TIMER_DIV8 		(2	<<  CS10) | FAST_PWM_MODE
#define TIMER_DIV64 	(3	<<  CS10) | FAST_PWM_MODE
#define TIMER_DIV256 	(4	<<  CS10) | FAST_PWM_MODE
#define TIMER_DIV1024 	(5	<<  CS10) | FAST_PWM_MODE
#define TIMER_T1_FALL 	(6	<<  CS10) | FAST_PWM_MODE
#define TIMER_T1_RISE	(7	<<  CS10) | FAST_PWM_MODE
#define FAST_PWM_OC1B_ON	(1<<COM1B1)|(1<<COM1B0)  |  (1<<WGM11)|(1<<WGM10)	
#define FAST_PWM_OC1X_OFF	(1<<WGM11)|(1<<WGM10)
#define NORMAL_OC1X_OFF		(0)
#define TIMER_T1_RISE_NORM	(7	<<  CS10) 

//Timer2 Settings
#define CTC_MODE 		2
#define COM2B_TOGGLE    (1 << 4)
#define TIMER2_OFF 		0
#define TIMER2_DIV1		1 
#define TIMER2_DIV8		2 
#define TIMER2_DIV32	3 
#define TIMER2_DIV64	4 
#define TIMER2_DIV128	5
#define TIMER2_DIV256	6 
#define TIMER2_DIV1024	7

// Timer initialization routines:

//Timer 1//////LCD update timer//////////////////////////////////////////////////////////////


void TimerOn(unsigned int clock){
OCR1A = clock-1;  				//set Top => Interrupt
TCNT1 = 0;						//so Timer1 will fire with delay
TCCR1A=FAST_PWM_OC1X_OFF;		//Output compare sets OC1B pin, Top = OCR1A => Interrupt
TIMSK1 = TIMSK1 | (1<<TOIE1);	//enable output compare interrupt for overflow	
TCCR1B=TIMER_DIV1024;			//start timer/no prescaler, external input T1 
}


void TimerOff(void){
TCCR1B=TIMER_OFF;				//disable timer clock
TIMSK1 = TIMSK1 & ~(1<<TOIE1);	//disable output compare interrupt	
}


void TimerClear(void){			//set Timer1 to defined initial state like after RESET
TCCR1A=0;
TCCR1B=0;
TCNT1=0;
OCR1A=0;
OCR1B=0;
ICR1=0;
TIMSK1=0;
TIFR1=0;
}

//Timer 0///// not used //////////////////////////////////////////////////////////////////////////////////


void Timer0_On(void){ 		
TIMSK0 = TIMSK0 | (1<<TOIE0); 	//enable overflow interrupt
TCCR0B=TIMER0_DIV1024;			//internal clock / 1024
TCCR0A = NORMAL_OC0X_OFF; 		//fast pwm, interrupt only
}


void Timer0_Off(void){
TIMSK0 = TIMSK0 & ~(1<<TOIE0);	//disable overflow interrupt
TCCR0B = TIMER0_OFF;			//disconnect clock source
}


void Timer0_Reset(void){			//set Timer0 to defined initial state like after RESET
TCCR0A=0;
TCCR0B=0;
TCNT0=0;
OCR0A=0;
OCR0B=0;
TIMSK0=0;
TIFR0=0;
}

/// interrupt handlers///////////////////////
char cnt=0;

ISR(TIMER1_OVF_vect) {//20x per second, LCD update interrupt
char a;
sei();
cnt++;
if (cnt>RELAYUPDATE){	//relay update counter
	cnt=0;
	eeprom_update_byte((uint8_t *)&nv_atten,atten);
	eeprom_update_byte((uint8_t *)&nv_step,step);
	//now update relays, only once per second
	SetDB(atten);
	}
switch (menu){		//normal display mode
  case MENU_ATT:
    strcpy(Line1,"Attenuation     ");
	strcpy(Line2,"    dB          ");
	uchar2str(Line2, atten);
	Line2[15]=channel;
  	break;
  case MENU_STEP:
    strcpy(Line1,"Step size       ");
	strcpy(Line2,"    dB          ");
	a=pgm_read_byte(&steps[step]);
	uchar2str(Line2, a);
  	break;
  case MENU_UBAT:
    strcpy(Line1,"Battery Voltage ");
	strcpy(Line2,"                ");
	volts2str(Line2, voltage);
  	break;
  case MENU_BT_OFF:
    strcpy(Line1,"Bluetooth       ");
	strcpy(Line2,"                ");
	if (BT_on==1)
		strcpy(Line2,"ON              ");
		else
		strcpy(Line2,"OFF             ");
  	break;	
  case MENU_OFF:
    strcpy(Line1,"Power OFF       ");
	strcpy(Line2,"                ");
	if (select==0) {
	strcpy(Line2,"executing.......");
	  POWER_OFF;	//execute
	  }
  	break;
  }	
//int2str(Line3,debug);	//debug
LCD_OutStr(Line1,0);
LCD_OutStr(Line2,0x40);
//Line3[16]=0;LCD_OutStr(Line3,0x40);	//debug
if (select==1)
	LCD_Goto(0,LCD_DISPLAY_ON | LCD_CURSOR_ON | LCD_CURSOR_BLINK);
	else 
	LCD_Goto(0,LCD_DISPLAY_ON);
return;
}


