/////////////////////////////////////////////////////////////////////////////////////
//  Attenuator Device specific functions
/////////////////////////////////////////////////////////////////////////////////////


void InitPower(){
blockButton=1;
DDRD=DDRD & ~0x80;						//ON-button input line
PORTD=PORTD | 0x80;						//pull-up
_delay_ms(10);							//wait until pull-up active
INIT_POWER_PIN;
POWER_ON;
LCD_InitPort();
LCD_Init(LCD_DISPLAY_ON);
LCD_Init(LCD_DISPLAY_ON);
LCD_InitBar();
LCD_OutStr("DG8SAQ Atten.   ",0);
LCD_OutStr("release ON key !",0x40);
while (ON_KEY_PRESSED);		//ON key still pressed? Wait!
LCD_OutStr("initializing....",0x40);
blockButton=0;
atten=0;
}

void InitAtten(void){
atten=eeprom_read_byte(&nv_atten);
if (atten==0xFF) atten=DEFAULT_ATTEN;
step=eeprom_read_byte(&nv_step);
if (step==0xFF) step=DEFAULT_STEP;
}

void InitDev(void) { 
TimerOn(600);  	//LCD Timer abt. 20Hz
}

void Bluetooth(char on){
BT_on=on & 1;
eeprom_update_byte((uint8_t *)&nv_BT_on,BT_on);
BT_PDDR=BT_PDDR | (1<<BT_PBIT);
BT_PPORT=BT_PPORT & ~(1<<BT_PBIT);
BT_PPORT=BT_PPORT | (((~BT_on)&1)<<BT_PBIT);
}

void BT_Init(void){
Bluetooth(eeprom_read_byte(&nv_BT_on));
}
