/////////////////////////////////////////////////////////////////////////////////////
//  Attenuator Device specific definitions
/////////////////////////////////////////////////////////////////////////////////////

// available menus
#define MENU_ATT 	0
#define MENU_STEP	1
#define MENU_UBAT	2
#define MENU_BT_OFF	3
#define MENU_OFF	4
#define MAXMENU 	4

// non-volatile EEPROM storage locations
unsigned char EEMEM nv_atten;		//non volatile attenuator value in dB
unsigned char EEMEM nv_step;		//non volatile attenuator step size in dB
unsigned char EEMEM nv_BT_on;

// volatile storage locations
unsigned char		atten=0;		//attenuator value in dB
unsigned char		step=10;		//attenuator step size in dB
char 				channel=' ';	//usb=U, bluetooth=B 
char				BT_on=1;		

char	Line1[17];
char	Line2[17];
// char	Line3[17];	//debug

#define TPORT PORTC
#define TDDR  DDRC
#define T_BIT 3
#define INIT_POWER_PIN	TDDR=TDDR|(1<<T_BIT)
#define POWER_ON 	TPORT=(TPORT &~(1<<T_BIT))|((1)<<T_BIT)
#define POWER_OFF 	TPORT=(TPORT &~(1<<T_BIT))|((0)<<T_BIT)
#define BT_PPORT	PORTC
#define BT_PDDR		DDRC
#define BT_PBIT		1



void int2str(char *str, int n){
char blank=1;
if (n<0){ 
	str[0]='-';
	n=-n; 
	}else str[0]=' ';

char d=0;
while (n>9999){
  d++;
  n=n-10000;}
if (d!=0) blank=0;
if (blank==1) str[1]=' '; else str[1]=0x30+d;

d=0;
while (n>999){
  d++;
  n=n-1000;}
if (d!=0) blank=0;
if (blank==1) str[2]=' '; else str[2]=0x30+d;

d=0;
while (n>99){
  d++;
  n=n-100;}
if (d!=0) blank=0;
if (blank==1) str[3]=' '; else str[3]=0x30+d;

d=0;
while (n>9){
  d++;
  n=n-10;}
if (d!=0) blank=0;
if (blank==1) str[4]=' '; else str[4]=0x30+d;
str[5]=0x30+n;
}

void char2str(char *str,signed char n){
char blank=1;
if (n<0){ 
	str[0]='-';
	n=-n; 
	}else str[0]=' ';

char d=0;

while (n>99){
  d++;
  n=n-100;}
if (d!=0) blank=0;
if (blank==1) str[1]=' '; else str[1]=0x30+d;

d=0;
while (n>9){
  d++;
  n=n-10;}
if (d!=0) blank=0;
if (blank==1) str[2]=' '; else str[2]=0x30+d;
str[3]=0x30+n;
}

void uchar2str(char *str,unsigned char n){
char blank=1;
char d=0;
while (n>99){
  d++;
  n=n-100;}
if (d!=0) blank=0;
if (blank==1) str[0]=' '; else str[0]=0x30+d;

d=0;
while (n>9){
  d++;
  n=n-10;}
if (d!=0) blank=0;
if (blank==1) str[1]=' '; else str[1]=0x30+d;
str[2]=0x30+n;
}

void volts2str(char *str,unsigned char n){
char blank=1;
char d=0;
while (n>99){
  d++;
  n=n-100;}
if (d!=0) blank=0;
if (blank==1) str[0]=' '; else str[0]=0x30+d;

d=0;
while (n>9){
  d++;
  n=n-10;}
if (d!=0) blank=0;
if (blank==1) str[1]=' '; else str[1]=0x30+d;
str[3]=0x30+n;
str[2]='.';
str[5]='V';
}
