
/*
 * Frank G. Sommer, DC8FG
 * Juni 2017
 * Script-Version: 1.0
 * Sender 433 MHz mit Rueckmeldeempfaenger 433 MHz
 * Dieses auf dem sendenden Arduino laufende Script erzeugt aus Tastendruck Counts welche an das empfangende Arduino-Board uebermittelten werden.
 * Der generierte Spannungswert wird zeitgleich zur Kontrolle vom empfangenden Arduino an den sendenden Arduino zurueckgesendet.
 * Eine gesonderte Anfrage an den empfangenden Arduino liefert den aktuellen Spannungswert zurueck.
 */

#include <LiquidCrystal_I2C.h> //Einbinden der LCD-Display-Library fuer I2C-Ansteuerung
#include <RCSwitch.h> // Einbinden der RCSwitch Library

LiquidCrystal_I2C lcd(0x3F, 16, 2);//hier die I2C-Adresse des Displays anpassen

int abfrage_switch = 6;
int status_abfrage_switch;
int tx_abfrage;
int transmit_switch = 7;
int status_transmit_switch;
int up_pin = 8;
int status_up_pin;
int down_pin = 9; 
int status_down_pin;
int TX_Pin = 10; 
int counts;
float Uein; //Wichtig, da sonst nur der ganzzahlige Teil dargestellt wird (int).
int sendedaten;

RCSwitch RadioSwitch = RCSwitch(); // Der Sender wird ab hier mit RadioSwitch angesprochen 

void setup()
{
  Serial.begin(9600); // Initialisiert die Serielle Uebertragung mit 9600baud
  lcd.init();
  lcd.setBacklight(255); // Schaltet die Hintergundbeleuchtung des LCD-Display ein 
	
  //Alle nicht genutzen Pins als Ausgang schalten um eingehende Stoerungen zu vermeiden
  pinMode(A7,OUTPUT);
  pinMode(A6,OUTPUT);
  pinMode(3,OUTPUT);
  pinMode(4,OUTPUT);
  pinMode(5,OUTPUT);
 
  //Alle genutzen Pins setzen	
  pinMode(up_pin,INPUT_PULLUP);//PullUp-Widerstand fuer den Eingangspin Up-Taster aktivieren
  pinMode(down_pin,INPUT_PULLUP);//PullUp-Widerstand fuer den Eingangspin Down-Taster aktivieren
  pinMode(transmit_switch,INPUT_PULLUP);
  pinMode(abfrage_switch, INPUT_PULLUP);

 
  RadioSwitch.enableTransmit(TX_Pin); // Der Sender ist an Pin 10 angeschlossen
  RadioSwitch.setProtocol(2); // Das Protokoll 2 wird verwendet


 RadioSwitch.enableReceive(0); // Hier wird festgelegt, das der Empfaenger den Interrupt 0 angeschlossen ist, welcher auf dem Board Pin 2 entspricht
}


void loop()
{

  status_up_pin = digitalRead(up_pin);
  status_down_pin = digitalRead(down_pin);

  while (status_up_pin == LOW && counts < 1024) {
    counts = counts + 1; //Festlegen der Schrittweite bei der Umrechnung
    Uein = ((counts * 4.8) / 1024);//Berechnen der Spannung welche sich ergaebe wenn sie analog am Port anliegen wuerde
    lcd.home();
	lcd.print("U TX:  ");
	lcd.print(Uein);
	lcd.print(" V   ");
	
    sendedaten = counts; 
    status_up_pin = digitalRead(up_pin);
    delay(10);
  }

  while (status_down_pin == LOW && counts > 0) {
    counts = counts - 1;
    Uein = ((counts * 4.8) / 1024);
	//Serial.print("Counts : ");
	//Serial.println(counts);
	//Serial.print("Spannung : ");
	//Serial.println(Uein);
	
	lcd.home();
	lcd.print("U TX:  ");
	lcd.print(Uein);
	lcd.print(" V   ");
	
    sendedaten = counts; 
    status_down_pin = digitalRead(down_pin);
    delay(10);
  }
  
  
  status_abfrage_switch = digitalRead(abfrage_switch);
  if (status_abfrage_switch == LOW) {
	  
	  tx_abfrage = 9999;
	  RadioSwitch.disableReceive();
	  delay(100);
	  RadioSwitch.send(tx_abfrage,24);
	  delay(100);
	  RadioSwitch.enableReceive(0);
  }
  
  
  status_transmit_switch = digitalRead(transmit_switch);
  if (status_transmit_switch == LOW) {
	  Serial.print("Senden : ");
	  Serial.println(counts);
	  RadioSwitch.disableReceive();
	  delay(100);
	  RadioSwitch.send(sendedaten,24);
	  delay(100);
	  RadioSwitch.enableReceive(0);
	}
    
	if (RadioSwitch.available()) // Wenn die Rueckmeldung vom RX empfangen wurde
		{
		int received_value = RadioSwitch.getReceivedValue(); // Soll value den empfangenen Wert annehmen
		counts = received_value;
		float Usende = ((counts * 4.8) / 1024);//Berechnen der Spannung welche sich ergaebe wenn sie analog am Port anliegen wuerde
		lcd.home();
		lcd.setCursor(0,1);
		lcd.print("U RX:  ");
		lcd.print(Usende);
		lcd.print(" V   ");
		
		}	

	RadioSwitch.resetAvailable(); //Empfaenger fuer Emfang neu initialisieren

}
