/*
 * Frank G. Sommer, DC8FG
 * Juni 2017
 * Script-Version: 1.0
 * Empfaenger 433 MHz mit Rueckmeldesender 433 MHz
 * Dieses auf dem empfangenden Arduino laufende Script erzeugt eine PWM-Spannung anhand von einem anderen Arduino-Board uebermittelten Daten.
 * Der generierte Spannungswert wird zeitgleich zur Kontrolle an den sendenden Arduino zurueckgesendet.
 * Auf gesonderte Anfrage des sendenden Arduino liefert der empfangende Arduino den aktuellen Spannungswert zurueck.
 */



#include <RCSwitch.h> // Einbinden der RCSwitch Library

int pwm_pin = 9; //Pin an dem die PWM-Spannung abgenommen werden kann
int pwm_stat;
int counts;
int PWM_Faktor = 4.01; //errechnet sich aus 1023 moegl. Counts (5V) / 255 (groesster PWM-Wert)
int PWM;
int tastverhaeltnis;

RCSwitch RadioSwitch = RCSwitch(); // Der Empfaenger wird ab jetzt mit RadioSwitch angesprochen


void setup()
{
   Serial.begin(9600); // Initialisiert die Serielle Uebertragung mit 9600 Baud
   //TCCR1B = _BV(CS00); // Prescale 1 - 31.372,55 Hz
   TCCR1B = (TCCR1B & 0b11111000) | 0x01; //Diese zeile hat die gleiche Bedeutung wie TCCR1B = _BV(CS00); 
   pinMode(pwm_pin,OUTPUT);
   RadioSwitch.enableReceive(0); // Hier wird festgelegt, das der Empfaenger den Interrupt 0 angeschlossen ist, welcher auf dem Board Pin 2 entspricht
   RadioSwitch.enableTransmit(10); //Pin 10 bertraegt die Sendedaten an den TX
   RadioSwitch.setProtocol(2);
}

void loop()
{ 
		
  if (RadioSwitch.available()) //Wurden Daten empfangen?
  {    
    int received_data = RadioSwitch.getReceivedValue(); // Dann soll die Variable received_data den empfangenen Wert annehmen
    
    if (received_data == 9999) //Abfrage der eingestellten Spannung
       {
          //Kontrollausgabe auf dem seriellen Monitor
          /*Serial.print("Received Data : ");
          Serial.println(received_data);
          pwm_stat = analogRead(9);
          Serial.print("PWM-Stat : ");
          Serial.println(pwm_stat); */
          //Ende Kontrollausgabe
          senden();
			 }
		

		if (received_data < 1025 && received_data > 0) //Einstellen der Spannung je nach uebertragenem Wert vom Sender (Steuergeraet)
		   {		
				  counts = received_data;
				  PWM = (counts / PWM_Faktor);
				  tastverhaeltnis = ((PWM * 100 /255)); //Den Teiler anpassen falls noetig
				  //Kontrollausgabe auf dem seriellen Monitor
				  /*Serial.print("Tastverhaeltnis : ");
				  Serial.println(tastverhaeltnis);
				  Serial.print("PWM : ");
				  Serial.println(PWM);
				  Serial.print("Received Counts : ");
				  Serial.println(counts); */
			    //Ende Kontrollausgabe
				  analogWrite(9,PWM); 
          senden();
				}
            
          else

          {
            }
           
	}
      
    RadioSwitch.resetAvailable(); //Empfaenger fuer Emfang neu initialisieren
  }


void senden() {

RadioSwitch.disableReceive(); //Empfaenger abschalten
delay(100);	
RadioSwitch.send(counts,24); //Daten senden	
delay(100);	
RadioSwitch.enableReceive(0); //Empfaenger aktivieren
}
