
;**************************************************************************
;*                    I2C Master Example                                  *
;**************************************************************************
;**************************************************************************
;*          v 1.05 - 14.05.2016                                           *
;*                                                                        *
;**************************************************************************
;*          Hardw.: PIC16F1826 used                                       *
;*          OSC.......: Internal osc. used                                *
;**************************************************************************

;--------------------------------------------------------------------------
;power:   3,6 V Li-Ion Accut
;current: 2,0 mA @ 3,6V / max. 3,0 mA during I2C communication with sensor (short time)
;--------------------------------------------------------------------------


 INCLUDE "P16F1826.INC"


_U001			     EQU     B'00100110000100'		;see Page 44 of Datasheet (41391D.pdf)
_U002			     EQU     B'01100011111111'		;see Page 45 of Datasheet (41391D.pdf)


	__CONFIG	_CONFIG1, _U001
	__CONFIG	_CONFIG2, _U002



;==========================================================================
;       Variable Definition
;==========================================================================
TIMER1		EQU	H'20'		;delay routine
TIMER2		EQU	H'21'		; "	"	"

v_data		EQU	H'22'

v_char1		EQU	H'23'
v_char2		EQU	H'24'
v_char3		EQU	H'25'
v_char4		EQU	H'26'
;--------------------------------------------------------------------------

;--------------------------------------------------------------------------
;==========================================================================

		ORG	0		;Reset vector address
		GOTO	init_main	;goto RESET routine when boot.


;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------
;
;	       **********************************
;              **  RESET :  main boot routine  **
;              **********************************
;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; initialization
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

init_main	nop

		clrf	BSR
;
		clrf	INTCON		;disable interrupts

		banksel	OPTION_REG	;BANK 1
		movlw	B'00111111'
		movwf	OPTION_REG	;see datasheet Page 176

		movlw	H'03'
		movwf	BSR		;select BANK 3
		clrf	ANSELA
		clrf	ANSELB

		movlw	H'01'
		movwf	BSR		;select BANK 1
		movlw	B'00000000'
		movwf	TRISA

		movlw	B'00010010'
		movwf	TRISB

;-----------------------------------------------------------------------------------------------------

;default frequency is 500 kHz

;-----------------------------------------------------------------------------------------------------
		movf	OSCCON,0
		andlw	B'11101111'
		iorlw	B'01101000'
		movwf	OSCCON		;set 4MHz internal clock (bit 6:3 = 1101) - Datasheet Page 65
;-----------------------------------------------------------------------------------------------------
		movlw	H'04'
		movwf	BSR		;select BANK 4
		clrf	WPUA		;disable weak pull-ups for PORTA
		clrf	WPUB		;disable weak pull-ups for PORTB


		banksel	LATB
		clrf	LATB

		clrf	BSR		;select BANK 0

		clrf	PORTB
		clrf	PORTA
		bsf	PORTA,D'002'
		bsf	PORTA,D'003'
		bsf	PORTA,D'004'
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
		call	i2c_init

;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
; Main Loop
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------

		clrf	v_char1
		clrf	v_char2
		clrf	v_char3
		clrf	v_char4

main_loop	nop

		call	display_send
		call	d2

		incf	v_char4,1
		movf	v_char4,0
		xorlw	H'0A'
		btfss	STATUS,Z
		goto	main_loop

		clrf	v_char4
		incf	v_char3,1
		movf	v_char3,0
		xorlw	H'0A'
		btfss	STATUS,Z
		goto	main_loop

		clrf	v_char3
		incf	v_char2,1
		movf	v_char2,0
		xorlw	H'0A'
		btfss	STATUS,Z
		goto	main_loop

		clrf	v_char2
		incf	v_char1,1
		movf	v_char1,0
		xorlw	H'0A'
		btfss	STATUS,Z
		goto	main_loop

		clrf	v_char1
		goto	main_loop
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
display_send	call	i2c_start
		movlw	H'DE'
		call	i2c_send
		movf	v_char1,0
		call	i2c_send
		movf	v_char2,0
		call	i2c_send
		movf	v_char3,0
		call	i2c_send
		movf	v_char4,0
		call	i2c_send
		call	i2c_stop
		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; delay routines
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
d2		MOVLW   D'255'
		MOVWF   TIMER2
DEL_LOOP1	MOVLW   D'255'
		MOVWF   TIMER1

DEL_LOOP2	DECFSZ  TIMER1,F
		GOTO    DEL_LOOP2
		DECFSZ  TIMER2,F
		GOTO    DEL_LOOP1
		return
;--------------------------------------
dr2		call	d2
		call	d2
		return
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
;I2C
;set up I2C BUS for communication as a master
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
i2c_init	movlw	H'04'
		movwf	BSR		;select BANK 4

		movlw	B'00101000'		;see Datasheet Page 277
;			bit 3-0 SSPM<3:0>: Synchronous Serial Port Mode Select bits
;			1000 = I2C Master mode, clock = FOSC / (4 * (SSPADD+1))
		movwf	SSP1CON1

;set-up I2C speed
		movlw	B'00111111'
		movwf	SSP1ADD
		clrf	SSP1STAT

		clrf	BSR		;select BANK 0

		return
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
; I2C communication routines
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

;-----------------------------------------------------------------------------
i2c_start	bsf	BSR,D'002'		;select register BANK 4
		bsf	SSP1CON2, SEN
		bcf	BSR,D'002'		;select register BANK 0
		call	d55
		return
;-----------------------------------------------------------------------------
i2c_stop	bsf	BSR,D'002'
		bsf	SSP1CON2, PEN
		bcf	BSR,D'002'
		call	d55
		return
;-----------------------------------------------------------------------------
i2c_ack		bsf	BSR,D'002'
		bcf	SSP1CON2, ACKDT		;ACK
		bsf	SSP1CON2, ACKEN
		bcf	BSR,D'002'
		call	d55
		return
;-----------------------------------------------------------------------------
i2c_not_ack	bsf	BSR,D'002'
		bsf	SSP1CON2, ACKDT		;NOT ACK
		bsf	SSP1CON2, ACKEN
		bcf	BSR,D'002'
		call	d55
		return
;-----------------------------------------------------------------------------
;output: received byte is in W register
;
i2c_receive	bsf	BSR,D'002'
		bsf	SSP1CON2, RCEN
		bcf	BSR,D'002'
		call	d55
		bsf	BSR,D'002'
		movf	SSP1BUF,0
		bcf	BSR,D'002'
		return
;-----------------------------------------------------------------------------
;input: transmitted byte have to be in W register
;
i2c_send	bsf	BSR,D'002'
		movwf	SSP1BUF
		bcf	BSR,D'002'
		call	d55			;wait a while
		return
;-----------------------------------------------------------------------------
i2c_restart	bsf	BSR,D'002'
		bsf	SSP1CON2, RSEN
		bcf	BSR,D'002'
		call	d55
		return
;-----------------------------------------------------------------------------
;-------------------------------------------------------------------------------
d55		movlw	D'255'
		movwf	TIMER2
d55_loop	decfsz	TIMER2,F
		goto	d55_loop
		return

;----------------------------------------------------------------------------


;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx


		END