
;**************************************************************************
;*          4-Digit 7-Segment LED Dynamic Display Driver                  *
;*          I2C Slave Device                                              *
;**************************************************************************
;**************************************************************************
;*          v 1.08 - 03.04.2016                                           *
;*                                                                        *
;**************************************************************************
;*        Hardw.: PIC16F1826 used                                         *
;*        OSC.......: Internal osc. used     POWER.....:   3,6V extern.   *
;**************************************************************************

 INCLUDE "P16F1826.INC"

_U001			     EQU     B'00100110000100'		;see Page 48 of Datasheet
_U002			     EQU     B'01100011111111'		;see Page 49 of Datasheet

	__CONFIG	_CONFIG1, _U001
	__CONFIG	_CONFIG2, _U002


;---------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;-------------------------------------------------XX
#define		I2C_SLAVE_ADDR	B'11011110'	 ;XX
;-------------------------------------------------XX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;---------------------------------------------------


;==========================================================================
;       Variable Definition
;==========================================================================
TIMER1		EQU	H'20'		;delay routine
TIMER2		EQU	H'21'		; "	"	"

v_pos1		EQU	H'22'
v_pos2		EQU	H'23'
v_pos3		EQU	H'24'
v_pos4		EQU	H'25'

v_curr_p	EQU	H'26'

v_bit		EQU	H'27'
v_pos_show	EQU	H'28'

v_i2c_byte1	EQU	H'29'
v_i2c_byte2	EQU	H'2A'
v_i2c_byte3	EQU	H'2B'
v_i2c_byte4	EQU	H'2C'

v_cancel_flag	EQU	H'2D'
;------------------------------------------------------
;------------------------------------------------------

;--------------------------------------------------------------------------
;==========================================================================
		ORG	0		;Reset vector address
		GOTO	init_main	;goto RESET routine when boot.

		ORG	4
		goto	ir_main		;interrupt service routine
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;              ++  RESET :  main boot routine  ++
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
init_main	nop
		clrf	BSR
		clrf	INTCON			;disable interrupts

		banksel	OPTION_REG
		movlw	B'00111111'
		movwf	OPTION_REG		;see datasheet Page 176
						;bit 7 = 0 --> Week pull-ups are enabled
		movlw	H'03'
		movwf	BSR			;select BANK 3
		clrf	ANSELA
		clrf	ANSELB

		banksel	TRISA
		movlw	B'00000000'
		movwf	TRISA
		movlw	B'11111111'
		movwf	TRISB

		movf	OSCCON,0
		andlw	B'11111111'
		iorlw	B'01111000'
		movwf	OSCCON			;set 16MHz internal clock (bit 6:3 = 1111) - Datasheet Page 68

		banksel	WPUB
		movlw	B'00001101'
		movwf	WPUB

		clrf	BSR			;select BANK 0
		call	i2c_slave_init
		goto	main_prg
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;                      Interrupt service routine
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
ir_main		clrf	BSR
;the GIE bit of INTCON is cleared in HW
		movlw	D'010'
		movwf	PR2			;overflow after 002 pulses
;-----------------------------------------------------------------------------
		movf	v_curr_p,0
		call	ishow_digits
;-----------------------------------------------------------------------------
irs_fin_prep	incf	v_curr_p,1
		movf	v_curr_p,0
		xorlw	D'008'
		btfsc	STATUS,Z
		clrf	v_curr_p		;start new round
;-----------------------------------------------------------------------------
;this part finalize the interrupt service routine
irs_fin		clrf	TMR2
		bcf	PIR1,TMR2IF		;clear the source of the interrupt
		retfie				;this instruction sets the bit GIE of INTCON as well
;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------
ishow_digits	brw
		goto	ishow_digit1
		goto	iswitch_off
		goto	ishow_digit2
		goto	iswitch_off
		goto	ishow_digit3
		goto	iswitch_off
		goto	ishow_digit4
		goto	iswitch_off
;-----------------------------------------------------------------------------
ishow_digit1	movf	v_pos1,0
		call	wa_numx
		movwf	v_pos_show
		btfsc	v_pos1,D'007'
		bcf	v_pos_show,D'007'
		call	act_pos1
		call	send_pos
		call	strobe_data
		return
;-----------------------------------------------------------------------------
ishow_digit2	movf	v_pos2,0
		call	wa_numx
		movwf	v_pos_show
		btfsc	v_pos2,D'007'
		bcf	v_pos_show,D'007'
		call	act_pos2
		call	send_pos
		call	strobe_data
		return
;-----------------------------------------------------------------------------
ishow_digit3	movf	v_pos3,0
		call	wa_numx
		movwf	v_pos_show
		btfsc	v_pos3,D'007'
		bcf	v_pos_show,D'007'
		call	act_pos3
		call	send_pos
		call	strobe_data
		return
;-----------------------------------------------------------------------------
ishow_digit4	movf	v_pos4,0
		call	wa_numx
		movwf	v_pos_show
		btfsc	v_pos4,D'007'
		bcf	v_pos_show,D'007'
		call	act_pos4
		call	send_pos
		call	strobe_data
		return
;-----------------------------------------------------------------------------
iswitch_off	movlw	H'FF'
		movwf	v_pos_show
		call	send_pos
		call	send_pos
		call	strobe_data
		movlw	D'001'
		movwf	PR2			;overflow after 001 puls
		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;                  Start the Driver and say "Hallo"
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
main_prg	clrf	BSR
		clrf	v_curr_p
		call	timer2_init

		movlw	H'0B'
		movwf	v_pos1
		movwf	v_pos2
		movwf	v_pos3
		movwf	v_pos4
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;                             Main Loop
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
main_loop3	call	i2c_slave_init

		banksel	SSP1STAT

start_wait	btfss	SSP1STAT,S
		goto	start_wait

idle_main	nop
		banksel	PIR1
		btfsc	PIR1,SSP1IF
		goto	i2c_add_match
		banksel	SSP1STAT
		btfsc	SSP1STAT,P
		goto	main_loop3		;Stop condition detected
		goto	idle_main


i2c_add_match	nop
		banksel	PIR1
		bcf	PIR1,SSP1IF

		banksel	SSP1STAT

		btfsc	SSP1STAT,D'005'		;Data = 1 / Address = 0
		goto	main_loop3		;we expect address on this stage - but now we got data - something is wrong...

		btfsc	SSP1STAT,D'002'		;Read = 1 / Write = 0
		goto	main_loop3		;we do not support read operation

;we received a matching I2C address with write indication
		banksel	SSP1BUF
		movf	SSP1BUF,0		;read the received address to clear the buffer

;------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------
;now we are in the game... expecting data for 1st position
;in this stage always 4 bytes are expected
;after 4th byte all are written to the video-memory
;reception can be interrupted all the time by generation of stop condition by master
;------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------
receive_loop	call	get_i2c_byte
		btfsc	v_cancel_flag,D'000'
		goto	main_loop3
		movwf	v_i2c_byte1

		call	get_i2c_byte
		btfsc	v_cancel_flag,D'000'
		goto	main_loop3
		movwf	v_i2c_byte2

		call	get_i2c_byte
		btfsc	v_cancel_flag,D'000'
		goto	main_loop3
		movwf	v_i2c_byte3

		call	get_i2c_byte
		btfsc	v_cancel_flag,D'000'
		goto	main_loop3
		movwf	v_i2c_byte4

;we received last digit -- now we can move all of them to the "video-memory"
		movf	v_i2c_byte1,0
		movwf	v_pos1
		movf	v_i2c_byte2,0
		movwf	v_pos2
		movf	v_i2c_byte3,0
		movwf	v_pos3
		movf	v_i2c_byte4,0
		movwf	v_pos4

		goto	receive_loop
;------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------
get_i2c_byte	clrf	BSR
		clrf	v_cancel_flag

iddle_data	nop
		banksel	PIR1
		btfsc	PIR1,SSP1IF
		goto	got_it
		banksel	SSP1STAT
		btfsc	SSP1STAT,P
		goto	cancel_comm		;Stop condition detected
		goto	iddle_data

got_it		nop
		banksel	PIR1
		bcf	PIR1,SSP1IF

		banksel	SSP1BUF
		movf	SSP1BUF,0		;read the received data and clear the buffer

		banksel	SSP1STAT

		btfss	SSP1STAT,D'005'		;Data = 1 / Address = 0
		goto	cancel_comm		;we expect data on this stage - just ignore address

		btfsc	SSP1STAT,P
		goto	cancel_comm		;Stop condition has been detected

		clrf	BSR
		return
;-------------------------------------------------
cancel_comm	clrf	BSR
		bsf	v_cancel_flag,D'000'
		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; delay routines
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
d2		MOVLW   D'255'
		MOVWF   TIMER2
DEL_LOOP1	MOVLW   D'255'
		MOVWF   TIMER1

DEL_LOOP2	DECFSZ  TIMER1,F
		GOTO    DEL_LOOP2
		DECFSZ  TIMER2,F
		GOTO    DEL_LOOP1
		return
;------------------------------------------------------------------------------
d2c		MOVLW   D'090'
		MOVWF   TIMER2
cDEL_LOOP1	MOVLW   D'255'
		MOVWF   TIMER1

cDEL_LOOP2	DECFSZ  TIMER1,F
		GOTO    cDEL_LOOP2
		DECFSZ  TIMER2,F
		GOTO    cDEL_LOOP1
		return
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

;------------------------------------
dr2		call	d2
		call	d2
		call	d2
		return
;------------------------------------
dr4		call	dr2
		call	dr2
		call	dr2
		return

;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
;I2C
;set up I2C BUS for communication as a slave
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
i2c_slave_init	movlw	H'04'
		movwf	BSR			;select BANK 4

		movlw	B'00110110'
		movwf	SSP1CON1		;See Page 280 of Datasheet

;set-up the slave address
		movlw	I2C_SLAVE_ADDR		;define the I2C slave address
		movwf	SSP1ADD
		clrf	SSP1STAT

		clrf	BSR			;select BANK 0
		return
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------


;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
;                              -- TIMER2 and Interrupt Setup --
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
timer2_init	movlw	B'00000011'
;		movlw	B'01111011'
;registers T2CON, TMR2 and PR2 resides in Bank 0 - no bank selection required at this place
		movwf	T2CON
		clrf	TMR2
		movlw	D'002'
		movwf	PR2			;overflow after 002 pulses
;-----------------------------------------------------------------------------------------
;Interrupt setup
		banksel	PIE1		
		clrf	PIE1
		clrf	PIE2
		bsf	PIE1,TMR2IE		;Enables the TMR2 interrupt
		clrf	BSR			;select BANK 0
		movlw	B'11000000'
		movwf	INTCON

;at this moment is everything prepared - but TIMER2 is not running

		bsf	T2CON,D'002'		;start TIMER2
		return
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------


;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
; BU2090 driver routines
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
act_pos4	clrf	v_bit
		call	send_bit_1
		bsf	v_bit,D'007'
		call	send_bit_1
		call	send_bit_1
		call	send_bit_1
		return
;------------------------------------------------------------------------------
act_pos3	clrf	v_bit
		bsf	v_bit,D'007'
		call	send_bit_1
		clrf	v_bit
		call	send_bit_1
		bsf	v_bit,D'007'
		call	send_bit_1
		call	send_bit_1
		return
;------------------------------------------------------------------------------
act_pos2	clrf	v_bit
		bsf	v_bit,D'007'
		call	send_bit_1
		call	send_bit_1
		clrf	v_bit
		call	send_bit_1
		bsf	v_bit,D'007'
		call	send_bit_1
		return
;------------------------------------------------------------------------------
act_pos1	clrf	v_bit
		bsf	v_bit,D'007'
		call	send_bit_1
		call	send_bit_1
		call	send_bit_1
		clrf	v_bit
		call	send_bit_1
		return
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;Sending Data to the BU2090 chips
;every chip contains 12 bits
;always the MSb needs to be send as first bit and LSb as last bit
;in case more than 12 bits are send to the BU2090 before strobe
;the last 12 bits are used (the are just cyclic overwritten)
;
;segment on the SA23-12 is on, if the corresponding bit = 0
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
send_pos	nop

;bit 0
		movf	v_pos_show,0
		movwf	v_bit
		call	send_bit_1

;bit 1
		lslf	v_bit,1
		call	send_bit_1

;bit 2
		lslf	v_bit,1
		call	send_bit_1

;bit 3
		lslf	v_bit,1
		call	send_bit_1

;bit 4
		lslf	v_bit,1
		call	send_bit_1

;bit 5
		lslf	v_bit,1
		call	send_bit_1

;bit 6
		lslf	v_bit,1
		call	send_bit_1

;bit 7
		lslf	v_bit,1
		call	send_bit_1

		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;send bit 7 of v_bit register to the BU2090
;at return stays the CLK1 line on High
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
send_bit_1	bcf	PORTA,D'000'		;clear DATA
		nop
		bcf	PORTA,D'001'		;clear CLK1
;set DATA line
		btfsc	v_bit,D'007'
		bsf	PORTA,D'000'

		bsf	PORTA,D'001'		;CLK1
		nop

		bcf	PORTA,D'000'		;clear DATA line
		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
strobe_data	bsf	PORTA,D'000'		;set DATA line to High
		nop
		bcf	PORTA,D'001'		;clear CLK1 line --> strobe
		nop
		bcf	PORTA,D'000'		;clear DATA line
		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
wa_numx		andlw	B'01111111'
		brw
		retlw	B'11000000'	;00h -> 0
		retlw	B'11111001'	;01h -> 1
		retlw	B'10100100'	;02h -> 2
		retlw	B'10110000'	;03h -> 3
		retlw	B'10011001'	;04h -> 4
		retlw	B'10010010'	;05h -> 5
		retlw	B'10000010'	;06h -> 6
		retlw	B'11011000'	;07h -> 7
		retlw	B'10000000'	;09h -> 8
		retlw	B'10010000'	;09h -> 9
		retlw	B'10001000'	;0Ah -> A
		retlw	B'10000011'	;0Bh -> b
		retlw	B'11000110'	;0Ch -> C
		retlw	B'10100001'	;0Dh -> d
		retlw	B'10000110'	;0Eh -> E
		retlw	B'10001110'	;0Fh -> F
		retlw	B'10111111'	;10h -> -
		retlw	B'11111111'	;11h -> space
;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
		END