
;**************************************************************************
;*          4-Digit 7-Segment LED Static Display Driver                   *
;*          I2C Slave Device                                              *
;**************************************************************************
;**************************************************************************
;*          v 1.09 - 14.05.2016                                           *
;**************************************************************************
;*          Hardw.: PIC16F1826 used                                       *
;*          OSC.......: Internal osc. used     POWER.....:   5V extern.   *
;**************************************************************************


 INCLUDE "P16F1826.INC"



_U001			     EQU     B'00100110000100'		;see Page 48 of Datasheet
_U002			     EQU     B'01100011111111'		;see Page 49 of Datasheet


	__CONFIG	_CONFIG1, _U001
	__CONFIG	_CONFIG2, _U002

;---------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;-------------------------------------------------XX
#define		I2C_SLAVE_ADDR	B'11011110'	 ;XX
;-------------------------------------------------XX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;---------------------------------------------------

;--------------------------------------------------------------------------
;RA0 = DATA
;RA1 = CLK1
;RA2 = CLK2
;RA3 = CLK3
;--------------------------------------------------------------------------


;==========================================================================
;       Variable Definition
;==========================================================================
TIMER1		EQU	H'20'		;delay routine
TIMER2		EQU	H'21'		; "	"	"

v_t1		EQU	H'22'
v_t2		EQU	H'23'

v_numx		EQU	H'24'
v_cnt_1		EQU	H'25'
v_cnt_2		EQU	H'26'
v_cnt_3		EQU	H'27'
v_cnt_4		EQU	H'28'

v_i2c_add	EQU	H'29'
;----------------------------
;----------------------------
v_bit		EQU	H'2F'

v_pos1		EQU	H'30'
v_pos2		EQU	H'31'
v_pos3		EQU	H'32'
v_pos4		EQU	H'33'

v_disp1		EQU	H'34'
v_disp2		EQU	H'35'
v_disp3		EQU	H'36'
v_disp4		EQU	H'37'

v_tmp		EQU	H'38'

v_i2c_byte1	EQU	H'39'
v_i2c_byte2	EQU	H'3A'
v_i2c_byte3	EQU	H'3B'
v_i2c_byte4	EQU	H'3C'

v_cancel_flag	EQU	H'3D'

;--------------------------------------------------------------------------
;==========================================================================

		ORG	0		;Reset vector address
		GOTO	init_main	;goto RESET routine when boot.

;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;
;	       **********************************
;              **  RESET :  main boot routine  **
;              **********************************
;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; initialization
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

init_main	nop

		clrf	BSR
;
		clrf	INTCON		;disable interrupts

		banksel	OPTION_REG	;BANK 1
		movlw	B'00111111'
		movwf	OPTION_REG	;see datasheet Page 176

		banksel	ANSELA
		clrf	ANSELA
		clrf	ANSELB

		banksel	TRISA
		movlw	B'00000000'
		movwf	TRISA

		movlw	B'11111111'
		movwf	TRISB

;no OSCCON change - default 500kHz used

		banksel	WPUB
		movlw	B'00001101'
		movwf	WPUB

		clrf	BSR			;select BANK 0

		clrf	PORTA
		clrf	PORTB

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

		clrf	INTCON

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;                      Initialising continues...
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
main_prg	clrf	BSR

		movlw	H'0B'
		movwf	v_disp1
		movwf	v_disp2
		movwf	v_disp3
		movwf	v_disp4
		call	translate3
		call	send_all

;------------------------------------------------------------------------------

		goto	main_loop3

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
clr_pos1	movlw	H'0B'
		call	wa_numx
		movwf	v_pos1
		return
;------------------------------------------------------------------------------
clr_all		movlw	H'0B'
		movwf	v_disp1
		movwf	v_disp2
		movwf	v_disp3
		movwf	v_disp4
		call	translate3
		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
translate3	movf	v_disp1,0
		movwf	v_numx
		call	wa_numx
		movwf	v_pos1

		movf	v_disp2,0
		movwf	v_numx
		call	wa_numx
		movwf	v_pos2

		movf	v_disp3,0
		movwf	v_numx
		call	wa_numx
		movwf	v_pos3

		movf	v_disp4,0
		movwf	v_numx
		call	wa_numx
		movwf	v_pos4

		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
send_all	call	send_pos2
		call	send_pos1
		call	send_pos3
		call	send_pos4
		call	strobe_1
		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
wa_numx		andlw	B'01111111'
		brw
		retlw	B'11000000'	;00h -> 0
		retlw	B'11111001'	;01h -> 1
		retlw	B'10100100'	;02h -> 2
		retlw	B'10110000'	;03h -> 3
		retlw	B'10011001'	;04h -> 4
		retlw	B'10010010'	;05h -> 5
		retlw	B'10000010'	;06h -> 6
		retlw	B'11011000'	;07h -> 7
		retlw	B'10000000'	;09h -> 8
		retlw	B'10010000'	;09h -> 9
		retlw	B'10001000'	;0Ah -> A
		retlw	B'10000011'	;0Bh -> b
		retlw	B'11000110'	;0Ch -> C
		retlw	B'10100001'	;0Dh -> d
		retlw	B'10000110'	;0Eh -> E
		retlw	B'10001110'	;0Fh -> F
		retlw	B'10111111'	;10h -> -
		retlw	B'11111111'	;11h -> space
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;Sending Data to the BU2090 chips
;every chip contains 12 bits
;always the MSb needs to be send as first bit and LSb as last bit
;in case more than 12 bits are send to the BU2090 before strobe
;the last 12 bits are used (the are just cyclic overwritten)
;
;segment on the SA23-12 is on, if the corresponding bit = 0
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
send_pos1	nop

;bit 0
		movf	v_pos1,0
		movwf	v_bit
		btfsc	v_disp1,D'007'
		bcf	v_bit,D'007'
		call	send_bit_1

;bit 1
		lslf	v_bit,1
		call	send_bit_1

;bit 2
		lslf	v_bit,1
		call	send_bit_1

;bit 3
		lslf	v_bit,1
		call	send_bit_1

;bit 4
		lslf	v_bit,1
		call	send_bit_1

;bit 5
		lslf	v_bit,1
		call	send_bit_1

;bit 6
		lslf	v_bit,1
		call	send_bit_1

;bit 7
		lslf	v_bit,1
		call	send_bit_1

		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
send_pos2	nop

;bit 0
		movf	v_pos2,0
		movwf	v_bit
		btfsc	v_disp2,D'007'
		bcf	v_bit,D'007'
		call	send_bit_2

;bit 1
		lslf	v_bit,1
		call	send_bit_2

;bit 2
		lslf	v_bit,1
		call	send_bit_2

;bit 3
		lslf	v_bit,1
		call	send_bit_2

;bit 4
		lslf	v_bit,1
		call	send_bit_1

;bit 5
		lslf	v_bit,1
		call	send_bit_1

;bit 6
		lslf	v_bit,1
		call	send_bit_1

;bit 7
		lslf	v_bit,1
		call	send_bit_1

		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
send_pos3	nop

;bit 0
		movf	v_pos3,0
		movwf	v_bit
		btfsc	v_disp3,D'007'
		bcf	v_bit,D'007'
		call	send_bit_2

;bit 1
		lslf	v_bit,1
		call	send_bit_2

;bit 2
		lslf	v_bit,1
		call	send_bit_2

;bit 3
		lslf	v_bit,1
		call	send_bit_2

;bit 4
		lslf	v_bit,1
		call	send_bit_2

;bit 5
		lslf	v_bit,1
		call	send_bit_2

;bit 6
		lslf	v_bit,1
		call	send_bit_2

;bit 7
		lslf	v_bit,1
		call	send_bit_2

		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
send_pos4	nop

;dummy bit 1
		movf	v_pos4,0
		movwf	v_bit
		call	send_bit_3
;dummy bit 2
		call	send_bit_3
;dummy bit 3
		call	send_bit_3
;dummy bit 4
		call	send_bit_3

;bit 0
		movf	v_pos4,0
		movwf	v_bit
		btfsc	v_disp4,D'007'
		bcf	v_bit,D'007'
		call	send_bit_3

;bit 1
		lslf	v_bit,1
		call	send_bit_3

;bit 2
		lslf	v_bit,1
		call	send_bit_3

;bit 3
		lslf	v_bit,1
		call	send_bit_3

;bit 4
		lslf	v_bit,1
		call	send_bit_3

;bit 5
		lslf	v_bit,1
		call	send_bit_3

;bit 6
		lslf	v_bit,1
		call	send_bit_3

;bit 7
		lslf	v_bit,1
		call	send_bit_3

		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;send bit 7 of v_bit register to the BU2090
;at return stays the CLK1 line on High
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
send_bit_1	bcf	PORTA,D'000'		;clear DATA
		nop
		bcf	PORTA,D'001'		;clear CLK1
;set DATA line
		btfsc	v_bit,D'007'
		bsf	PORTA,D'000'

		bsf	PORTA,D'001'		;CLK1
		nop

		bcf	PORTA,D'000'		;clear DATA line
		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
send_bit_2	bcf	PORTA,D'000'		;clear DATA
		nop
		bcf	PORTA,D'002'		;clear CLK2
;set DATA line
		btfsc	v_bit,D'007'
		bsf	PORTA,D'000'

		bsf	PORTA,D'002'		;CLK2
		nop

		bcf	PORTA,D'000'		;clear DATA line
		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
send_bit_3	bcf	PORTA,D'000'		;clear DATA
		nop
		bcf	PORTA,D'003'		;clear CLK3
;set DATA line
		btfsc	v_bit,D'007'
		bsf	PORTA,D'000'

		bsf	PORTA,D'003'		;CLK3
		nop

		bcf	PORTA,D'000'		;clear DATA line
		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
strobe_1	bsf	PORTA,D'000'		;set DATA line to High
		nop
		bcf	PORTA,D'001'		;clear CLK1 line --> strobe
		bcf	PORTA,D'002'		;clear CLK2 line --> strobe
		bcf	PORTA,D'003'		;clear CLK3 line --> strobe
		nop
		bcf	PORTA,D'000'		;clear DATA line
		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; delay routines
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
d2		MOVLW   D'010'
		MOVWF   TIMER2
DEL_LOOP1	MOVLW   D'255'
		MOVWF   TIMER1

DEL_LOOP2	DECFSZ  TIMER1,F
		GOTO    DEL_LOOP2
		DECFSZ  TIMER2,F
		GOTO    DEL_LOOP1
		return
;------------------------------------------------
d1		MOVLW   D'007'
		MOVWF   TIMER2
DEL_LOOP1b	MOVLW   D'255'
		MOVWF   TIMER1

DEL_LOOP2b	DECFSZ  TIMER1,F
		GOTO    DEL_LOOP2b
		DECFSZ  TIMER2,F
		GOTO    DEL_LOOP1b
		return

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

;------------------------------------
dr2		call	d2
		call	d2
		call	d2
		return
;------------------------------------
dr4		call	dr2
		call	dr2
		call	dr2
		return


;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
;I2C
;set up I2C BUS for communication as a slave
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
i2c_slave_init	movlw	H'04'
		movwf	BSR			;select BANK 4

		movlw	B'00110110'
		movwf	SSP1CON1		;See Page 280 of Datasheet

;set-up the slave address
		movlw	I2C_SLAVE_ADDR		;define the I2C slave address
		movwf	SSP1ADD
		clrf	SSP1STAT

		clrf	BSR			;select BANK 0
		return
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
; I2C communication routines
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

;-----------------------------------------------------------------------------
i2c_start	bsf	BSR,D'002'		;select register BANK 4
		bsf	SSP1CON2, SEN
		bcf	BSR,D'002'		;select register BANK 0
		call	d55
		return
;-----------------------------------------------------------------------------
i2c_stop	bsf	BSR,D'002'
		bsf	SSP1CON2, PEN
		bcf	BSR,D'002'
		call	d55
		return
;-----------------------------------------------------------------------------
i2c_ack		bsf	BSR,D'002'
		bcf	SSP1CON2, ACKDT		;ACK
		bsf	SSP1CON2, ACKEN
		bcf	BSR,D'002'
		call	d55
		return
;-----------------------------------------------------------------------------
i2c_not_ack	bsf	BSR,D'002'
		bsf	SSP1CON2, ACKDT		;NOT ACK
		bsf	SSP1CON2, ACKEN
		bcf	BSR,D'002'
		call	d55
		return
;-----------------------------------------------------------------------------
;output: received byte is in W register
;
i2c_receive	bsf	BSR,D'002'
		bsf	SSP1CON2, RCEN
		bcf	BSR,D'002'
		call	d55
		bsf	BSR,D'002'
		movf	SSP1BUF,0
		bcf	BSR,D'002'
		return
;-----------------------------------------------------------------------------
;input: transmitted byte have to be in W register
;
i2c_send	bsf	BSR,D'002'
		movwf	SSP1BUF
		bcf	BSR,D'002'
		call	d55			;wait a while
		return
;-----------------------------------------------------------------------------
i2c_restart	bsf	BSR,D'002'
		bsf	SSP1CON2, RSEN
		bcf	BSR,D'002'
		call	d55
		return
;-----------------------------------------------------------------------------
;-------------------------------------------------------------------------------
d55		movlw	D'255'
		movwf	TIMER2
d55_loop	decfsz	TIMER2,F
		goto	d55_loop
		return
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------


;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;                             Main Loop
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
main_loop3	call	i2c_slave_init

		banksel	SSP1STAT

start_wait	btfss	SSP1STAT,S
		goto	start_wait

idle_main	nop
		banksel	PIR1
		btfsc	PIR1,SSP1IF
		goto	i2c_add_match
		banksel	SSP1STAT
		btfsc	SSP1STAT,P
		goto	main_loop3		;Stop condition detected
		goto	idle_main


i2c_add_match	nop
		banksel	PIR1
		bcf	PIR1,SSP1IF

		banksel	SSP1STAT

		btfsc	SSP1STAT,D'005'		;Data = 1 / Address = 0
		goto	main_loop3		;we expect address on this stage - but now we got data - something is wrong...

		btfsc	SSP1STAT,D'002'		;Read = 1 / Write = 0
		goto	main_loop3		;we do not support read operation

;we received a matching I2C address with write indication
		banksel	SSP1BUF
		movf	SSP1BUF,0		;read the received address to clear the buffer

;------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------
;now we are in the game... expecting data for 1st position
;in this stage always 4 bytes are expected
;after 4th byte all are written to the video-memory
;reception can be interrupted all the time by generation of stop condition by master
;------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------
receive_loop	call	get_i2c_byte
		btfsc	v_cancel_flag,D'000'
		goto	main_loop3
		movwf	v_i2c_byte1

		call	get_i2c_byte
		btfsc	v_cancel_flag,D'000'
		goto	main_loop3
		movwf	v_i2c_byte2

		call	get_i2c_byte
		btfsc	v_cancel_flag,D'000'
		goto	main_loop3
		movwf	v_i2c_byte3

		call	get_i2c_byte
		btfsc	v_cancel_flag,D'000'
		goto	main_loop3
		movwf	v_i2c_byte4

;we received last digit -- now we can move all of them to the "video-memory"
		movf	v_i2c_byte1,0
		movwf	v_disp1
		movf	v_i2c_byte2,0
		movwf	v_disp2
		movf	v_i2c_byte3,0
		movwf	v_disp3
		movf	v_i2c_byte4,0
		movwf	v_disp4
;display the received data
		call	translate3
		call	send_all

		goto	receive_loop
;------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------
get_i2c_byte	clrf	BSR
		clrf	v_cancel_flag

iddle_data	nop
		banksel	PIR1
		btfsc	PIR1,SSP1IF
		goto	got_it
		banksel	SSP1STAT
		btfsc	SSP1STAT,P
		goto	cancel_comm		;Stop condition detected
		goto	iddle_data

got_it		nop
		banksel	PIR1
		bcf	PIR1,SSP1IF

		banksel	SSP1BUF
		movf	SSP1BUF,0		;read the received data and clear the buffer

		banksel	SSP1STAT

		btfss	SSP1STAT,D'005'		;Data = 1 / Address = 0
		goto	cancel_comm		;we expect data on this stage - just ignore address

		btfsc	SSP1STAT,P
		goto	cancel_comm		;Stop condition has been detected

		clrf	BSR
		return
;-------------------------------------------------
cancel_comm	clrf	BSR
		bsf	v_cancel_flag,D'000'
		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
		END