;
;Programmname 	:timerx
;---------------------------------------------------------------
;Datum			:21.03.2013
;---------------------------------------------------------------
.cseg
;---------------------------------------------------------------
;* in    r16,PORTB             ;read PORTB latch
;* sbr   r16,(1<<PB6)+(1<<PB5) ;set PB6 and PB5 (use masks, not bit#)
;* out   PORTB,r16             ;output to PORTB
;--------------------------------------------------------------- 
;---------------------------------------------------------------
init_timerx:
;---------------------------------------------------------------
;.equ	timerx_high	= sram_start+3
;.equ	timerx_low	= sram_start+2
;--------------------------------------
clr		r16
sts		count0_high,r16
sts		count0_low,r16

sts		count1_high,r16
sts		count1_low,r16

sts		ref_high,r16
sts		ref_low,r16

ldi		r16,1
ret
;---------------------------------------------------------------
;---------------------------------------------------------------
init_int0:
cbi		ddrd,pd2
;--------------------------------------
;select rising edge of INT0.
lds		r16,eicra
sbr		r16,(1<<isc01)+(1<<isc00)
sts		eicra,r16
;--------------------------------------
;enable external interrupt request INT0
sbi		eimsk,int0
;--------------------------------------
ret
;---------------------------------------------------------------
;---------------------------------------------------------------
init_int1:
cbi		ddrd,pd3
;--------------------------------------
;select rising edge of INT1.
lds		r16,eicra
sbr		r16,(1<<isc11)+(1<<isc10)
sts		eicra,r16
;--------------------------------------
;enable external interrupt request INT1
sbi		eimsk,int1
;--------------------------------------
ret
;---------------------------------------------------------------
;---------------------------------------------------------------
init_int2:
cbi		ddrb,pd2
;-------------------------
;select rising edge of INT1.
lds		r16,eicra
sbr		r16,(1<<isc20)+(1<<isc21)
sts		eicra,r16
;-------------------------
;enable external interrupt request INT1
sbi		eimsk,int1
;-------------------------
ret
;---------------------------------------------------------------
;---------------------------------------------------------------
init_pcint31:
;enable PinChangeInterruptEnable3 for PCINT31:24
lds		r16,PCICR
sbr		r16,(1<<PCIE3)
sts		PCICR,r16
;------------------------
;enable PinChangeInterruptEnable for pin PCINT31
lds		r16,PCMSK3
sbr		r16,(1<<PCINT31)
sts		PCICR,r16
;------------------------
ret
;---------------------------------------------------------------
;---------------------------------------------------------------


;---------------------------------------------------------------
;---------------------------------------------------------------
;---------------------------------------------------------------
INT0H:		;IRQ0 Handler / counterx0 up/down
;zl:zh werden gendert.
cli
push    r16
in		r16,sreg
push    r16
push    r17
push	r18
;--------------------
lds		yh,count0_high
lds		yl,count0_low

sbis	pinc,2
rjmp	decrement_timerx0
;--------------------
increment_timerx0:
;addiere 1 zu 16 bit Y register.
adiw yh:yl,1 
rjmp	end_incr0
;--------------------
decrement_timerx0:
;subtrahiere 1 von 16 bit Y register.
sbiw yh:yl,1
;--------------------
end_incr0:
sts		count0_low,yl
sts		count0_high,yh
;--------------------
end_int0:
pop		r18
pop		r17
pop     r16
out     sreg,r16
pop     r16
sbi		eifr,1

reti
;---------------------------------------------------------------
;---------------------------------------------------------------
;---------------------------------------------------------------
INT1H:		;IRQ0 Handler / counterx1 up/down
cli
push    r16
in		r16,sreg
push    r16
push    r17
push	r18

sbi		eifr,1
;--------------------
lds		r17,count1_high
lds		r16,count1_low

sbic	pinc,3
rjmp	decrement_timerx1

;--------------------
increment_timerx1:
ldi		r18,1

add		r16,r18
clr		r18
adc		r17,r18
;----------
cpi		r17,high(3600)
brne	end_incr1
cpi		r16,low(3600)
brne	end_incr1
;----------
ldi		r16,0
ldi		r17,0
rjmp	end_incr1
;--------------------
decrement_timerx1:

ldi		r18,1
sub		r16,r18
clr		r18
sbc		r17,r18
;----------
cpi		r17,high($ffff)
brne	end_incr1
cpi		r16,low($ffff)
brne	end_incr1
;----------
ldi		r16,low(3599)
ldi		r17,high(3599)
rjmp	end_incr1
;--------------------
end_incr1:
sts		count1_low,r16
sts		count1_high,r17
;--------------------
sbi		portc,0
ldi		r18,5
sdih1:
dec		r18
brne	sdih1
cbi		portc,0
;--------------------
end_int1:
pop		r18
pop		r17
pop     r16
out     sreg,r16
pop     r16

sbi		eifr,1
reti


















;---------------------------------------------------------------
;---------------------------------------------------------------
;---------------------------------------------------------------
INT2H:		;IRQ0 Handler / counterx2  /  I2CBUS interrupt
cli
push    r16
in		r16,sreg
push    r16
push    r17
push	r18
;--------------------


;--------------------
end_int2:
pop		r18
pop		r17
pop     r16
out     sreg,r16
pop     r16
sbi		eifr,1

reti
;---------------------------------------------------------------
;---------------------------------------------------------------
;---------------------------------------------------------------
PCINT3H:
;set_referenz
;Taster in Inkrementalgeber pin PD7 / Interrupt PCI-31
cli
push    r16
in		r16,sreg
push    r16
push    r17
;--------------------


;--------------------
end_pcint3:
pop		r17
pop     r16
out     sreg,r16
pop     r16
reti
;---------------------------------------------------------------
;---------------------------------------------------------------
;---------------------------------------------------------------


