;
;Programmname 	:TASTER_4
;---------------------------------------------------------------
;Datum			:29.03.2013
;---------------------------------------------------------------
.cseg
;---------------------------------------------------------------

;---------------------------------------------------------------
init_taster:
;-------------------
;set pins pc4:pc7 =: input
in		r16,ddrc
sbr		r16,(1<<pc4)+(1<<pc5)+(1<<pc6)+(1<<pc7)
out		ddrc,r16
;-------------------
;set pullups pins pc4:pc7
in		r16,portc
sbr		r16,(1<<pc4)+(1<<pc5)+(1<<pc6)+(1<<pc7)
out		portc,r16
;-------------------
;enable interrupts for PCINT23...PCINT16
lds		r16,PCICR
sbr		r16,(1<<pcie2)
sts		PCICR,r16
;-------------------
;enable Pin Change Enable PCINT23
lds		r16,pcmsk2
sbr		r16,(1<<pcint23)+(1<<pcint22)+(1<<pcint21)+(1<<pcint20)
sts		pcmsk2,r16
;-------------------
ret
;---------------------------------------------------------------
;---------------------------------------------------------------

PCINT2H	:
;Handler fr PCINT 23 : 16
;cli
push    r16
in		r16,sreg
push    r16
push    r17
push	r18
;--------------------
;sbi		portb,4

ldi		r17,120
sts		zoom,r17

lds		r16,pcmsk2
cbr		r16,(1<<pcint23)+(1<<pcint22)+(1<<pcint21)+(1<<pcint20)
sts		pcmsk2,r16
;--------------------
rcall	up_down_delay_long
in		r16,pinc
com		r16
andi	r16,0b11110000
;--------------------
sts		flags1,r16

cpi		r16,$10
breq	taste4
;
cpi		r16,$20
breq	taste5
;
cpi		r16,$40
breq	taste6
;
cpi		r16,$80
breq	taste7
;
cpi		r16,$90
breq	taste7_4
;
cpi		r16,$A0
breq	taste7_5
;
cpi		r16,$C0
breq	taste7_6
;---------------------------------------------------------------
cpi		r16,$30
breq	taste5_4
cpi		r16,$50
breq	taste6_4
cpi		r16,$60
breq	taste6_5
cpi		r16,$70
breq	taste6_5_4
cpi		r16,$B0
breq	taste7_5_4
cpi		r16,$D0
breq	taste7_6_4
cpi		r16,$E0
breq	taste7_6_5
cpi		r16,$F0
rjmp	taste7_6_5_4	;breq	taste7_6_5_4
;breq	taste7_6_5_4
;---------------------------------------------------------------
taste4:
rjmp	pulse_up
rjmp	end_PCINT2H
taste5:
rjmp	pulse_down
rjmp	end_PCINT2H
taste6:
rjmp	end_PCINT2H
taste7:
rjmp	end_PCINT2H
;--------------------
taste7_4:
lds		r17,flags0		
sbrs	r17,0			; bit flags0, auf lock gesetzt ?
rjmp	_setlock		; bit nicht auf lock gesetzt. 
cbr		r17,1			; bit auf lock setzen.

rcall 	trans_ref
sts		flags0,r17		; byte in flags0 ablegen.
rjmp	end_PCINT2H	
_setlock:
sbr		r17,1			; bit flags0 auf unlock setzen			
sts		flags0,r17		; byte in flags0 ablegen.
rjmp	end_PCINT2H	
taste7_5:

rjmp	end_PCINT2H	
taste7_6:

rjmp	end_PCINT2H	
;---------------------------------------------------------------
taste5_4:
taste6_4:
taste6_5:
taste6_5_4:
taste7_5_4:
taste7_6_4:
taste7_6_5:
taste7_6_5_4:
rjmp	end_PCINT2H	

;---------------------------------------------------------------
in		r16,pinc
sbrs	r16,pc7
rjmp	pulse_up
sbrs	r16,pc6
rjmp	pulse_down
rjmp	end_PCINT2H

pulse_up:
lds		r16,flags0
sbrs	r16,0
rjmp	end_PCINT2H
;_pulup:
rcall	increment_counter_ref
rcall	up_down_delay_long
pulse_up_1:
rcall	delay_zoom
lds		r17,zoom
dec		r17
cpi		r17,0
brne	pulse_up1_0
subi	r17,252
pulse_up1_0:
in		r16,pinc
sts		zoom,r17
sbrc	r16,pc4
rjmp	end_pcint2h
rcall	increment_counter_ref
rjmp	pulse_up_1


pulse_down:
lds		r16,flags0
sbrs	r16,0
rjmp	end_PCINT2H
;_puldown:
rcall	decrement_counter_ref
rcall	up_down_delay_long
pulse_down_1:
rcall	delay_zoom
lds		r17,zoom
dec		r17
cpi		r17,0
brne	pulse_down_0
subi	r17,252
pulse_down_0:
sts		zoom,r17
in		r16,pinc
sbrc	r16,pc5
rjmp	end_pcint2h
rcall	decrement_counter_ref
rjmp	pulse_down_1
;--------------------
end_PCINT2H	:
rcall	up_down_delay_short

pop		r18
pop		r17
pop     r16
out     sreg,r16

lds		r16,PCIFR
cbr		r16,(1<<pcif2)
;sts		PCIFR,r16

pop     r16

;cbi		portb,4
reti
;--------------------------------------------------------------
;--------------------------------------------------------------
up_down_delay_long:
push	r16
push	r17

ldi		r16,255
ldi		r17,2
updo0:
rcall	up_down_delay_short
dec		r16
brne	updo0
dec		r17
brne	updo0

pop		r17
pop		r16
ret


up_down_delay_short:
;Xtal = 20 MHz
; generate  delay
push	r16
push	r17

ldi		r16,255
ldi		r17,5
dly_loopx2:
dec		r16
brne	dly_loopx2
dec		r17
brne	dly_loopx2

pop		r17
pop		r16
ret


delay_zoom:
;Xtal = 20 MHz
; generate  delay
push	r16
push	r17

lds		r16,zoom
ldi		r17,1
dly_zoom:
rcall	up_down_delay_short

dec		r16
brne	dly_zoom
lds		r16,zoom
dec		r17
brne	dly_zoom

pop		r17
pop		r16
ret
;--------------------------------------------------------------
;--------------------------------------------------------------
;test
make_pulse:
sbi		portb,4
rcall	up_down_delay_short
cbi		portb,4
ret
;--------------------------------------------------------------
;--------------------------------------------------------------
