;
;Programmname 	:PCF8574
;---------------------------------------------------------------
;Datum			:07.04.2011
;---------------------------------------------------------------
.cseg
;---------------------------------------------------------------
.equ	PCA9555 		= $40		;adresse + 0
.equ	PCA9555_in_0 	= 0
.equ	PCA9555_in_1 	= 1
.equ	PCA9555_out_0 	= 2
.equ	PCA9555_out_1 	= 3
.equ	PCA9555_invert0 = 4
.equ	PCA9555_invert1 = 5
;--------------------------------------------------------------- 
;---------------------------------------------------------------
;**************
init_PCA9555:;*
;**************
;config wert fr port 0 in r16 / config wert fr port 1 in r17
 
ldi		r16,0b00000000	;set config port0
ldi		r17,0b00011111	;set config port1
;***************************
config_pca9555_directions:;*
;***************************
/*
configurate the data-direction of port0 with r16.
configurate the data-direction of port1 with r17.
0 =: output  /  1 =: input.
*/
push	r17
push	r16
ldi		r18,PCA9555+I2Cwr	;Set device address and write
rcall	I2C_start			;Send start condition and address 

ldi		r17,6				;select configuration port0
rcall	I2C_transfer		;Execute transfer

pop		r17					;set mode of port0 according data in r16
rcall	I2C_transfer		;Execute transfer

pop		r17					;set mode of port1 according data in r17
rcall	i2c_transfer		;Execute transfer

rcall	I2C_stop
ret
;--------------------------------------------------------------- 
;---------------------------------------------------------------
;PCA9555_config0:
/*
configurate the data-direction of port0 according to the corresponding
configuration port0.
0 sets a bit for output while 1 selects input mode.
the pointer value for configuration port0 = 6
r16 holds the configuration data.
*/
;push	r16
;ldi		r18,PCA9555+I2Cwr	;Set device address and write
;rcall	I2C_start			;Send start condition and address 

;ldi		r17,6				;select configuration port0
;rcall	I2C_transfer		;Execute transfer
;
;pop		r17					;set mode of port0 according data in r16
;rcall	I2C_transfer		;Execute transfer
;
;rcall	I2C_stop
;ret
;-------------------------------------
; PCA9555_config1:
/*
configurate the data-direction of port1 according to the corresponding
configuration port1.
0 sets a bit for output while 1 selects input mode.
the pointer value for configuration port1 = 7
r16 holds the configuration data.
*/
;push	r16
;ldi		r18,PCA9555+I2Cwr	;Set device address and write
;rcall	I2C_start			;Send start condition and address 

;ldi		r17,7				;select configuration port1
;rcall	I2C_transfer		;Execute transfer

;pop		r17					;set mode of port1 according data in r16
;rcall	I2C_transfer		;Execute transfer
;
;rcall	I2C_stop
;ret
;--------------------------------------------------------------- 
;---------------------------------------------------------------
;*********************
write_pca9555_port0:;*
;*********************
push	r16
ldi		r16,PCA9555_out_0	;load output register port 0
rjmp	_write_pca9555
;-------------------
;*********************
write_pca9555_port1:;*
;*********************
push	r16
ldi		r16,PCA9555_out_1	;load output register port 1
_write_pca9555:
;send data in r16 to port
push	r16
ldi		r18,PCA9555+I2Cwr	;Set device address and write
rcall	I2C_start			;Send start condition and address 
pop		r17					;select output port
rcall	I2C_transfer		;Execute transfer
pop		r17					;get r16
rcall	I2C_transfer		;Execute transfer
rcall	I2C_stop
ret
;--------------------------------------------------------------- 
;---------------------------------------------------------------
;********************
read_pca9555_port0:;*
;********************
ldi		r16,PCA9555_in_0	;load input register port 0
rjmp	_pca9555_read
;-------------------
;********************
read_pca9555_port1:;*			;load input register port 1
;********************
ldi		r16,PCA9555_in_1
;-------------------
_pca9555_read:
;inputkanal in r16
;byte wird gelesen und in r16 und r17 zurckgegeben.

push	r16
ldi		r18,PCA9555+I2Cwr	;Set device address and write
rcall	I2C_start			;Send start condition and address 

pop		r17
rcall	i2c_transfer

ldi		r18,PCA9555+I2Crd	;Set device address and read
rcall	I2C_rep_start

sec							;set master acknowledge bit
rcall	I2C_transfer		;Execute transfer and load byte into r17 

rcall	I2C_stop
mov		r16,r17				;return byte in r16 and r16
ret
;--------------------------------------------------------------- 
;---------------------------------------------------------------
;**********************
invert_pca9555_port0:;*
;**********************
push	r16
ldi		r16,PCA9555_invert0	;load invert register port 0
rjmp	_invert_pca9555
;-------------------
;**********************
invert_pca9555_port1:;*
;**********************
push	r16
ldi		r16,PCA9555_invert1	;load invert register port 1
_invert_pca9555:
;send data in r16 to invertregister
push	r16
ldi		r18,PCA9555+I2Cwr	;Set device address and write
rcall	I2C_start			;Send start condition and address 
pop		r17					;select output port
rcall	I2C_transfer		;Execute transfer
pop		r17					;get r16
rcall	I2C_transfer		;Execute transfer
rcall	I2C_stop
ret
;--------------------------------------------------------------- 
;---------------------------------------------------------------
;***************
test_adap_lcd:;*
;***************
rcall	read_pca9555_port1
rcall	write_pca9555_port0
rjmp	test_adap_lcd
;--------------------------------------------------------------- 
;---------------------------------------------------------------

;**** End of File ****
