
;
;Programmname	:MAIN
;---------------------------------------------------------------
;Datum			:29.03.2013
;---------------------------------------------------------------
;CPU			:ATmega 644
;-----------------------------------------------------------------
;XTAL			:20 MHz
;-----------------------------------------------------------------
; REFERENZ EINSTELLUNG BER TASTER
;-----------------------------------------------------------------

;-----------------------------------------------------------------
; "steps0" muss auf 1 (einfache Schrittzahl) oder 2  (doppelte Schrittzahl) gesetzt werden.
; "steps1" muss immer die einfache schrittzahl des drehgebers enthalten.
;-----------------------------------------------------------------
.cseg
;-----------------------------------------------------------------
.equ	steps0		= 2 
; 1 = interrupt bei aufsteigender flanke. 
; 2 = interrupt bei aufsteigender und bei abfallender flanke.
;-----------------------------------------------------------------
.equ	steps1 		= 14400*steps0
;-----------------------------------------------------------------
.equ	grad360_0   = steps1/3600
;-----------------------------------------------------------------
.cseg

.include "m644def.inc"

.org	000
;-----------------------------------------------------------------
;-----------------------------------------------------------------
jmp	RESET		;Reset Handler
jmp	INT0H		;IRQ0 Handler
jmp	INT1H		;IRQ1 Handler
jmp	INT2H		;IRQ2 Handler
jmp	PCINT0H		;PCINT0	Handler
jmp	PCINT1H		;PCINT1	Handler
jmp	PCINT2H		;PCINT2	Handler
jmp	PCINT3H		;PCINT3	Handler
jmp	WDT			;Watchdog Timeout Handler
jmp	TIM2_COMPA	;Timer2	CompareA Handler
jmp	TIM2_COMPB	;Timer2	CompareB Handler
jmp	TIM2_OVF	;Timer2	Overflow Handler
jmp	TIM1_CAPT	;Timer1	Capture	Handler
jmp	TIM1_COMPA	;Timer1	CompareA Handler
jmp	TIM1_COMPB	;Timer1	CompareB Handler
jmp	TIM1_OVF	;Timer1	Overflow Handler
jmp	TIM0_COMPA	;Timer0	CompareA Handler
jmp	TIM0_COMPB	;Timer0	CompareB Handler
jmp	TIM0_OVF	;Timer0	Overflow Handler
jmp	SPI_STC		;SPI Transfer Complete Handler
jmp	USART0_RXC	;USART0	RX Complete Handler
jmp	USART0_UDRE ;USART0,UDR	Empty Handler
jmp	USART0_TXC	;USART0	TX Complete Handler
jmp	ANA_COMP	;Analog	Comparator Handler
jmp	ADC_INT		;ADC Conversion	Complete
jmp	EE_RDY		;EEPROM	Ready Handler
jmp	TWI			;2-wire	Serial Handler
jmp	SPM_RDY		;SPM Ready Handler
;-----------------------------------------------------------------
;-----------------------------------------------------------------
RESET:
ldi		r16,high(ramend)
out		SPH,r16
ldi		r16,low(ramend)
out		SPL,r16
;-----------------------------------------------------------------
;-----------------------------------------------------------------
rcall	init_ports
rcall	init_timer_ref
rcall	init_timer_dreh
rcall	init_int0
rcall	init_timer_ref
rcall	init_taster
rcall	init_anz
rcall	print_lock
;-----------------------------------------------------------------
;-----------------------------------------------------------------

again:
;rcall	test_anzeige
;rjmp	again
sei
lds		r16,pcmsk2
sbr		r16,(1<<pcint23)+(1<<pcint22)+(1<<pcint21)+(1<<pcint20)
sts		pcmsk2,r16
;---------------------------
rcall	show_drehwinkel

rcall	show_ref
;---------------------------
;rcall	zeig_byte

rcall	up_down_delay_long
rjmp	again

;-----------------------------------------------------------------
;-----------------------------------------------------------------
zeig_byte:
push	r16
ldi		r16,zeile4
rcall	setcurs

lds		r16,flags1
rcall	show8bits
pop		r16
ret



;-----------------------------------------------------------------
;-----------------------------------------------------------------
.include "defini.asm"
.include "support.asm"
.include "ea_w162_x3lg.asm"
.include "arithmet.asm"
;.include "i2c_master.asm"
.include "IO_initiate.asm"
.include "counter_dreh.asm"
.include "counter_ref.asm"
.include "anz_ref.asm"
.include "anz_drehwinkel.asm"
.include "transfer_ref.asm"
.include "taster_4.asm"


