
;Programmname         : I2C_MASTER
;---------------------------------------------------------------
;Datum                : 11.08.2007 -  25.03.2010
;---------------------------------------------------------------
;Version              : 0.1
;---------------------------------------------------------------
;
;---------------------------------------------------------------
;
;---------------------------------------------------------------
;               :
;Treiber fr "Single Masgter Implementation"
;Kein Interrupt wird belegt.
;Untersttzt 'normal' und 'fast' mode.
;Untersttzt 7-bit und 10-bit adressierung.
;Untersttzt die gesamte AVR mikroprozessor familie.
;
;Hauptfunktionen:
;"I2C_start"		sendet start condition und sendet Adresse und r/w info.
;"I2C_rep_start" 	sendet eine wiederholte start condition ausserdem Adresse und r/w info.
;"I2C_transfer"		sendet bzw. empfngt data byte (abhngig vom r/w bit).
;"I2C_stop"			sendet stop condition.

; ************* verwendete register: r7, r17,r18 ***************
.cseg
;-------------------------------------------------------------------------------------------
; ANPASSEN.
.equ    SCL       = 0   ; SCL bit number of portx
.equ    SDA       = 1   ; SDA bit number of portx
.equ	PORT	  = PORTC
;-------------------------------------------------------------------------------------------
.equ	i2_port   = PORT
.equ	i2_ddr    = PORT-1
.equ	i2_pin    = PORT-2
;-------------------------------------------------------------------------------------------
.equ	direction = 0	; transfer direction bit in r18
.equ	I2Crd	  = 1
.equ	I2Cwr	  = 0
;-------------------------------------------------------------------------------------------
; bit SCL und SDA mssen als output definiert und auf 0 initialisiert werden.
; dly_2 und dly_4 mssen in defini definiert sein.
;-------------------------------------------------------------------------------------------
; Register X  reserviert.
;-------------------------------------------------------------------------------------------
;****************
I2C_rep_start: ;*
;****************
sbi		i2_ddr,SCL	; force SCL low
cbi		i2_ddr,SDA	; release SDA
lds		r26,dly_2
dy3:
dec		r26
brne	dy3
cbi		i2_ddr,SCL	; release SCL
lds		r26,dly_4
dy16:
dec		r26
brne	dy16
;-------------------------------------------------------------------------------------------
;-------------------------------------------------------------------------------------------
;************
I2C_start: ;*
;************	
 mov		r17,r18			; copy address to transmit register
 sbi		i2_ddr,SDA		; force SDA low
lds			r26,dly_4
dy14:
dec			r26
brne		dy14
;-------------------------------------------------------------------------------------------
;-------------------------------------------------------------------------------------------
I2C_write:
sec						;set carry flag
rol			r17			;shift in carry and out bit one
rjmp		i2c_04
ic2_l03:
lsl			r17			;if transmit register empty
i2c_04:
breq		I2C_get_ack	;goto get acknowledge
sbi			i2_ddr,SCL	;force SCL low

brcc		i2c_05		;if bit high
nop						;(equalize number of cycles)
cbi			i2_ddr,SDA	;release SDA
rjmp		ic2_l06
i2c_05:					;else
sbi			i2_ddr,SDA	;force SDA low
rjmp		ic2_l06		;(equalize number of cycles)
ic2_l06:
lds			r26,dly_2
dy4:
dec			r26
brne		dy4

cbi			i2_ddr,SCL	;release SCL
lds			r26,dly_2
dy5:
dec			r26
brne		dy5

rjmp		ic2_l03
;-------------------------------------------------------------------------------------------
;-------------------------------------------------------------------------------------------
I2C_get_ack:
sbi			i2_ddr,SCL	;force SCL low
cbi			i2_ddr,SDA	;release SDA
lds			r26,dly_2
dy6:
dec			r26
brne		dy6

cbi			i2_ddr,SCL	;release SCL
ic2_l07:
sbis		i2_pin,SCL	;wait SCL high 
						;(In case wait states are inserted)
rjmp		ic2_l07
clc						;clear carry flag
sbic		i2_pin,SDA	;if SDA is high
sec						;set carry flag
lds			r26,dly_2
dy7:
dec			r26
brne		dy7
ret
;-------------------------------------------------------------------------------------------
;-------------------------------------------------------------------------------------------
;***************
I2C_transfer: ;*
;***************
 sbrs			r18,direction	;if dir = write
 rjmp			I2C_write		;goto write data
;-------------------------------------------------------------------------------------------
;-------------------------------------------------------------------------------------------
I2C_read:
sec					;set carry for acknowledge 
rol			r7			;store acknowledge (used by I2C_put_ack) GESPERRT AM 14.09.2005
ldi			r17,0x01	;data = 0x01
ic2_l08:				;do
sbi			i2_ddr,SCL	;force SCL low
lds			r26,dly_2
dy8:
dec			r26
brne		dy8
cbi			i2_ddr,SCL	;release SCL
lds			r26,dly_2
dy9:
dec			r26
brne		dy9
clc						;clear carry flag
sbic		i2_pin,SDA	;if SDA is high
sec						;set carry flag
rol			r17			;store data bit
brcc		ic2_l08		;while receive register not full
;-------------------------------------------------------------------------------------------
;-------------------------------------------------------------------------------------------
I2C_put_ack:
sbi			i2_ddr,SCL	;force SCL low
ror			r7			;get status bit
brcc		ic2_l09		;if bit low goto assert low
cbi			i2_ddr,SDA	;release SDA
rjmp		ic2_l10
ic2_l09:				;else
sbi			i2_ddr,SDA	;force SDA low
ic2_l10:
lds			r26,dly_2
dy10:
dec			r26
brne		dy10
cbi			i2_ddr,SCL	;release SCL
ic2_l11:
sbis		i2_pin,SCL	;wait SCL high
rjmp		ic2_l11
lds			r26,dly_2
dy11:
dec			r26
brne		dy11
ret
;-------------------------------------------------------------------------------------------
;-------------------------------------------------------------------------------------------
;***********
I2C_stop: ;*
;***********
sbi			i2_ddr,SCL	;force SCL low
sbi			i2_ddr,SDA	;force SDA low
lds			r26,dly_2
dy12:
dec			r26
brne		dy12
cbi			i2_ddr,SCL	;release SCL
lds			r26,dly_4
dy15:
dec			r26
brne		dy15
cbi			i2_ddr,SDA	;release SDA
lds			r26,dly_2
dy13:
dec			r26
brne		dy13
ret
;-------------------------------------------------------------------------------------------
;-------------------------------------------------------------------------------------------
;**** End of File ****
