;---------------------------------------------------------------
;Programmname		: EA-W162-X3LG
;---------------------------------------------------------------
;Datum				: 14.10.2012
;---------------------------------------------------------------
; LCD	Treiber	Module fuer OLED  EA-W162-X3LG / busbreite 8 bit.
;---------------------------------------------------------------  

;----------------------------------------------------------------------------
.equ 	enable		=6	
.equ 	r_w			=5
.equ 	rs			=4

.equ 	port1		=portA		;port1 = data LCD
.equ 	ddr1		=port1-1
.equ	pin1		=port1-2


.equ 	port2	  	=portD		;port2 = control LCD
.equ 	ddr2		=port2-1
.equ	pin2		=port2-2

.equ	dispon		=$0c
.equ	curson		=$02
.equ	cursblink   =$01
.equ	cursoff		=$00
.equ	_8bit		=$30
.equ	_4bit		=$20
.equ	_2line		=$08
.equ	_1line		=$00
;----------------------------------------------------------------------------
.cseg
;----------------------------------------------------------------------------
init_anz:
;anzeige	initialisieren.
;Data-Transfer 8 bit
;2-zeilig, Kursorbewegung nach rechts / 2 x 16 char
;_anzeige aktivieren und Kursor ein
ldi		r16,$ff		
out		ddr1,r16
clr		r16
out		port1,r16

sbi		ddr2,enable
sbi		ddr2,r_w
sbi		ddr2,rs

cbi     port2,r_w  
cbi		port2,rs
cbi		port2,enable
;-------------------------------
ldi		r16,$38
rcall	_wr_cont

ldi		r16,$08
rcall	_wr_cont

ldi		r16,$06				;
rcall	_wr_cont

rcall	intl_pwr_on

ldi		r16,$02
rcall	_wr_cont

ldi		r16,$0c
rcall	_wr_cont

ldi		r16,$01
rcall	_wr_cont

rcall	delay_1s	

ret
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
intl_pwr_on:
ldi		r16,0b00010111
rjmp	_wr_cont

intl_pwr_off:
ldi		r16,0b00010011
rjmp	_wr_cont
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
wr_anzeige:
;Das Zeichen in r16 anzeigen.
cbi		port2,r_w		;write
sbi		port2,rs		;RS = 1
rjmp	_anzeige
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
_wr_cont:
cbi		port2,rs		;RS  =	0 =: command
_anzeige:
out		port1,r16	  	;data auf LCD-port
cbi		port2,r_w		;R/W =	0 =: write
sbi		port2,enable	;enable LCD
nop
nop
nop
nop
cbi		port2,enable 	;disable LCD
sbi		port2,r_w
rcall	_busy
ret
;-------------------------------
_busy:
;bei xtal = 20 MHz /  t = 5 S
push	r16
ldi		r16,30
bd1:
dec		r16
brne	bd1
pop		r16
ret
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
clear:
;Zeilen 1 und 2 werden gelscht
ldi		r16,1
rcall	_wr_cont
rcall	_busy
ret
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
setcurs:
;Kursor setzen.
;Die Kursorposition wird in r16 bergeben.
/*
.equ	zeile1		= 0	
.equ	zeile2		= 64
.equ	zeile3		= 20
.equ	zeile4		= 84
*/

.equ	zeile1		= 0	
.equ	zeile2		= 64
.equ	zeile3		= 20
.equ	zeile4		= 84




ori		r16,0x80
rjmp	_wr_cont
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
cursor_on:
;Kursor einschalten
ldi		r16,0b00001110
rjmp	_wr_cont
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
cursor_off:
;Kursor ausschalten
ldi		r16,0b00001100
rjmp	_wr_cont
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
blink_on:
;Zeichen blinken, ein
ldi		r16,0b00001101
rjmp	_wr_cont
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
blink_off:
;Zeichen blinken, aus
ldi		r16,0b00001100
rjmp	_wr_cont
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
show8bits:
;byte in r16 wird binr angezeigt gefolgt von einem space.
mov		r17,r16
ldi		r18,8
lab01:
rol		r17
brcs	shw_1
ldi		r16,'0'
rjmp	lab03
shw_1:
ldi		r16,'1'
lab03:
rcall	wr_anzeige
dec		r18
brne	lab01
ldi		r16,' '
rcall	wr_anzeige
ret
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
show_hex:
;binren wert dezimal _anzeigen.
;bin zahl in r16(low byte)	bis r19 (high byte).
;es werden werte bis max. 4 294 967 295 dez  / $ff ff ff ff angezeigt.
rcall	bin_to_dez
;----------------------------------------------------------------------------
show_dez:
;dez zahl in r16 (low 2 nibble) bis r20 (high 2 nibble)
;den dezmalwert auf dem stack ablegen.

push  	r16
push	r17
push	r18
push	r19
push	r20

ldi		r16,5	; schleifenzhler = 5 dezimale doppeldigits
mov		r2,r16	; schleifenzhler
swdz:
pop		r16		; binr-byte holen
push	r16		; und wieder retten
andi	r16,$f0	; low nibble lschen
swap	r16		; swap low/high nibble 
ori		r16,$30	; low nibble auf ASCII byte erweitern

rcall	wr_anzeige	; byte _anzeigen
pop		r16		; unteres nibble aus doppeldigit holen
andi	r16,$0f	; high nibble lschen
ori		r16,$30	; low nibble auf ASCII byte erweitern

rcall	wr_anzeige	; byte _anzeigen

dec		r2		; schleifenzhler dekrementieren
brne	swdz	; wenn != 0 then next doppeldigit
;end_show_dez:
ret
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
wr_text:
;Ein	Text wird auf LCD-_anzeige ausgegeben.
;Der	Beginn des Textes im Program Memory steht in zl	und in zh.
;beispiel:
;ldi    zh,high(2*text)
;ldi    zl,low(2*text)
;rcall  show_text
;Der	Text muss mit 0	abgeschlossen sein.
;
x0:
lpm		; load byte from program memory	into r0
tst		r0	;reached end of text ?
breq	x1	;if so, branch	x1
mov		r16,r0
rcall	wr_anzeige	; display byte

adiw	zl,1;increase z-register
rjmp	x0	;fetch	next byte
x1:
ret
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;2 dezimal-ziffern anzeigen.
;die ziffern stehen in r16.
;
show2dez:
 push   r16
 andi   r16,$f0
 swap   r16
 ori    r16,$30
 rcall  wr_anzeige
 brtc	sh2x
 ldi	r16,','
 rcall	wr_anzeige
sh2x:
 pop    r16
 andi   r16,$0f
 ori    r16,$30
 rcall  wr_anzeige
 ret
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
test_anzeige:
ldi		r16,zeile1
rcall	setcurs
ldi		zh,high(2*line1)
ldi		zl,low(2*line1)
rcall	wr_text
rcall	delay_1s

ldi		r16,zeile2
rcall	setcurs
ldi		zh,high(2*line2)
ldi		zl,low(2*line2)
rcall	wr_text
rcall	delay_1s

ldi		r16,zeile3
rcall	setcurs
ldi		zh,high(2*line3)
ldi		zl,low(2*line3)
rcall	wr_text
rcall	delay_1s

ldi		r16,zeile4
rcall	setcurs
ldi		zh,high(2*line4)
ldi		zl,low(2*line4)
rcall	wr_text
;rcall	delay_1s


;rcall	clear
;rcall	delay_1s
ret


line1:
.db "Dieses ist Zeile 001",0,0

line2:
.db "Dieses ist Zeile 002",0,0

line3:
.db "Dieses ist Zeile 003",0,0

line4:
.db "Dieses ist Zeile 004",0,0


ret
;--------------------------------------------------------------- 
;---------------------------------------------------------------
