;
;Programmname 	:counter_0
;---------------------------------------------------------------
;Datum			:29.03.2013
;---------------------------------------------------------------
.cseg
;---------------------------------------------------------------

;--------------------------------------------------------------- 
;---------------------------------------------------------------
init_timer_dreh:
;---------------------------------------------------------------
clr		r16
sts		count_dreh_high,r16
sts		count_dreh_low,r16
ret
;---------------------------------------------------------------
;---------------------------------------------------------------
init_INT0:
cbi		ddrd,pd2
cbi		ddrc,pc2
ldi		r17,steps0
;--------------------------------------
;steps0 = 0 =: interrupt bei positiver flanke.
;steps0 = 1 =: interrupt bei positiver und negativer flanke.
;
cpi		r17,2
breq	_init_int0_1
;--------------------------------------
;select rising edge of INT0.
lds		r16,eicra
sbr		r16,(1<<isc01)+(1<<isc00)
sts		eicra,r16
;enable external interrupt request INT0
sbi		eimsk,int0
ret
;--------------------------------------
_init_int0_1:
;--------------------------------------
;select rising and falling edge of INT0.
lds		r16,eicra
sbr		r16,(1<<isc00)
sts		eicra,r16
;enable external interrupt request INT0
sbi		eimsk,int0
ret
;---------------------------------------------------------------
;---------------------------------------------------------------
INT0H:	
;Drehgeber X2	
;IRQ0 Handler / counterx0 up/down
;zl:zh werden gendert.
cli
push    r16
in		r16,sreg
push    r16
push    r17
push	r18

sbi		eifr,1
;--------------------
lds		r17,count_dreh_high
lds		r16,count_dreh_low

sbis	pinc,2
rjmp	decrement_counter_dreh
;--------------------
;increment_counter_dreh:
ldi		r18,1							;
add		r16,r18				
clr		r18					
adc		r17,r18				
;----------
cpi		r17,high(steps1)	
brne	end_incr0			
cpi		r16,low(steps1)		
brne	end_incr0			  
;----------
ldi		r16,0				
ldi		r17,0				
rjmp	end_incr0			    
;--------------------
decrement_counter_dreh:
ldi		r18,1				
sub		r16,r18				
clr		r18					
sbc		r17,r18				
;----------
cpi		r17,high($ffff)		
brne	end_incr0			
cpi		r16,low($ffff)		
brne	end_incr0			
;----------
ldi		r16,low(steps1-1)	
ldi		r17,high(steps1-1)	
rjmp	end_incr0	

;--------------------
end_incr0:
sts		count_dreh_low,r16
sts		count_dreh_high,r17
;--------------------
end_int0:
pop		r18
pop		r17
pop     r16
out     sreg,r16
pop     r16
sbi		eifr,1

reti
;---------------------------------------------------------------
;---------------------------------------------------------------
;---------------------------------------------------------------

