;---------------------------------------------------------------
;Programmname	: ARITHMET
;---------------------------------------------------------------
;Datum			: 20.04.2007
;---------------------------------------------------------------
;Version		: 1.1
;---------------------------------------------------------------
;Controller		: ATmega 16/32/644
;---------------------------------------------------------------
;Version		: 1.0 
;---------------------------------------------------------------

.cseg
;
;bin_to_dez:
;bin zahl in (r16:r19).
;dez zahl in (r6:r10).
;es werden werte bis max. 4 294 967 294 dez ($ff ff ff ff) gewandelt.
;t ca. 200 S / 8 MHz
;---------------------------------------------------------------
;dez_to_bin:
;Max-wert = 4 294 967 295 dez
;dezimalzahl in (r16:r20). 
;binary in (r16:r19).
;es werden werte bis max. 4 294 967 295 dez ($ff ff ff ff) gewandelt.
;t ca. 200 S / 8 MHz
;---------------------------------------------------------------
;add_r21_r25_to_r16_r20:
;(r21:r25) + (r16:r20) =  (r16:r20)
;---------------------------------------------------------------
;sub_r21_r25_from_r16_r20:
;(r16:r20) - (r21:r25) = (r16:r20)
;---------------------------------------------------------------
;mul32:
;(r21:r25) * (r16:r20) = (r21:r25)
;result in (r16:r20)
;result in (r21:r25)
;t ca. 100 s / 8 MHz
;---------------------------------------------------------------
;div32:
;(r16:r20):(r21:r25) = (r16:r20) und (r11:r15)
;(r16:r20):(r21:r25) = (r21:r25)
;divisor  in  (r21:r25)
;dividend in  (r16:r20)
;quotient in  (r16:r20) und in (r11:r15)
;t ca. 200 s / 8 MHz
;---------------------------------------------------------------
;mov_r16_r20_to_r21_r25:
;mov_r16_r20_to_r11_r15:
;mov_r16_r20_to_r6_r10:
;mov_r6_r10_to_r16_r20:
;clr_r16_to_r20:
;clr_r1_to_r15:
;---------------------------------------------------------------
bin_to_dez:
;bin zahl in (r16:r19).
;dez zahl in (r6:r10)
;dez zahl in (r16:r20) 
;es werden werte bis max. 4 294 967 295 dez ($ff ff ff ff) gewandelt.
;
ldi		r20,$01
mov		r3,r20		;set low nibble = 1
ldi		r20,$10
mov		r4,r20		;set high nibble = 1

clr		r6
clr		r7
clr		r8
clr		r9
clr		r10
clr		r20

ldi		xl,10		;load xl with register number 10.
clr		xh

ldi		yl,5		;loop-counter set to 5 loops

ldi		zh,high(2*tab_hex)
ldi		zl,low(2*tab_hex)
;--------------------
lpbtd:
ld		r2,x
rcall	addup_dez
st		x,r2

ld		r5,-x
dec		yl
brne	lpbtd
rcall	mov_r6_r10_to_r16_r20
ret
;---------------------
;---------------------
load_tabx:
lpm		    	;load byte from program memory into	r0
mov		r21,r0
adiw	zl,1	;increase z-register

lpm		    	;load byte from program memory into	r0
mov		r22,r0
adiw	zl,1	;increase z-register

lpm		    	;load byte from program memory into	r0
mov		r23,r0
adiw	zl,1	;increase z-register

lpm		    	;load byte from program memory into	r0
mov		r24,r0
adiw	zl,1	;increase z-register
clr		r25
ret
;---------------------------------------------------------------
;---------------------------------------------------------------
addup_dez:
rcall	load_tabx
bx01:
add		r2,r4
rcall	sub_r21_r25_from_r16_r20
brcc	bx01
rcall	add_r21_r25_to_r16_r20
sub		r2,r4
;---------------------
rcall	load_tabx
bx02:
add		r2,r3
rcall	sub_r21_r25_from_r16_r20
brcc	bx02
rcall	add_r21_r25_to_r16_r20
sub		r2,r3
ret
;---------------------------------------------------------------
;---------------------------------------------------------------
dez_to_bin:
;Max-wert = 4 294 967 295 dez
;dezimalzahl in (r16:r20). 
;binary in (r16:r19).
;es werden werte bis max. 4 294 967 295 dez ($ff ff ff ff) gewandelt.
rcall  	mov_r16_r20_to_r6_r10
rcall  	clr_r16_to_r20
ldi		xl,$0a		;load xl with register r10 (= $0a)
clr		xh
ldi		zh,high(2*tab_hex)
ldi		zl,low(2*tab_hex)
ldi		yl,5		;loop-counter set to 5 loops
lptabx:
;--------------------
rcall 	load_tabx	;1 000 000 000 - 3B 9A CA 00 hex
ld		r5,x
mov		r4,r5
swap	r4
rcall	add_all
;---------------------
rcall	load_tabx	;100 000 000 - 05 F5 E1 00 hex
mov		r4,r5
rcall	add_all
;---------------------
ld		r5,-x		;decrement to next lower d-register
dec		yl			;decrement loop-counter
brne	lptabx
ret
;---------------------
add_all:
push	r26
mov		r26,r4
andi	r26,$0f
breq	eax2
eax1:
rcall	add_r21_r25_to_r16_r20
 ;dec	r4
dec		r26
breq	eax2
rjmp	eax1
eax2:
pop		r26
ret
;---------------------------------------------------------------
;---------------------------------------------------------------
tab_hex:
.db $00,$ca,$9a,$3b	;1 000 000 000 - 3B 9A CA 00 hex
.db $00,$e1,$f5,$05	;  100 000 000 - 05 F5 E1 00 hex
.db $80,$96,$98,$00	;   10 000 000 - 00	98 96 80 hex
.db $40,$42,$0f,$00	;    1 000 000 - 00 0F 42 40 hex
.db $a0,$86,$01,$00	;      100 000 - 00 01 86 a0 hex
.db $10,$27,$00,$00	;	    10 000 - 00 00 27 10 hex
tab_hex_short:
.db $e8,$03,$00,$00	;	     1 000 - 00 00 03 E8 hex
.db $64,$00,$00,$00	;	       100 - 00 00 00 64 hex
.db $0a,$00,$00,$00	;	        10 - 00	00 00 0a hex
.db $01,$00,$00,$00	;	         1 - 00 00 00 01 hex
;---------------------------------------------------------------
;---------------------------------------------------------------

;allgemeine arithmetik
;---------------------------------------------------------------
;---------------------------------------------------------------
add_r21_r25_to_r16_r20:
;(r21:r25) + (r16:r20) =  (r16:r20)
;
add		r16,r21
adc		r17,r22
adc		r18,r23
adc		r19,r24
adc		r20,r25
ret
;---------------------------------------------------------------
;---------------------------------------------------------------
sub_r21_r25_from_r16_r20:
;(r16:20) - (r21:r25) = (r16:r20)
;
sub		r16,r21
sbc		r17,r22
sbc		r18,r23
sbc		r19,r24
sbc		r20,r25
ret
;---------------------------------------------------------------
;---------------------------------------------------------------
mul32:
;(r21:r25) * (r16:r20) = (r21:r25)
;result in (r16:r20)
;result in (r21:r25)
;t ca. 100 s / 8 MHz

rcall	mov_r16_r20_to_r11_r15
rcall	clr_r16_to_r20
clc
;-----------------
mov		r2,r11
rcall	mul32x7
mov		r2,r12
rcall	mul32x7
mov		r2,r13
rcall	mul32x7
mov		r2,r14
rcall	mul32x7
mov		r2,r15
rcall	mul32x7
rcall	mov_r16_r20_to_r21_r25
ret
;-----------------
mul32x7:
sbrc	r2,0
rcall	add_r21_r25_to_r16_r20
rcall	shiftl
;-----------------
sbrc	r2,1
rcall	add_r21_r25_to_r16_r20
rcall	shiftl
;-----------------
sbrc	r2,2
rcall	add_r21_r25_to_r16_r20
rcall	shiftl
;-----------------
sbrc	r2,3
rcall	add_r21_r25_to_r16_r20
rcall	shiftl
;-----------------
sbrc	r2,4
rcall	add_r21_r25_to_r16_r20
rcall	shiftl
;-----------------
sbrc	r2,5
rcall	add_r21_r25_to_r16_r20
rcall	shiftl
;-----------------
sbrc	r2,6
rcall	add_r21_r25_to_r16_r20
rcall	shiftl
;-----------------
sbrc	r2,7
rcall	add_r21_r25_to_r16_r20
rcall	shiftl
;-----------------
clr		r25
clr		r20
ret
;-----------------
shiftl:
;shift	r25:0 left by 1 bit
clc
rol		r21
rol		r22
rol		r23
rol		r24
rol		r25
ret
;---------------------------------------------------------------
;---------------------------------------------------------------
div32:
;(r16:r20):(r21:r25) = (r21:r25)
;divisor  in  (r21:r25)
;dividend in  (r16:r20)
;quotient in  (r16:r20) und in (r11:r15)
;t ca. 200 s / 8 MHz
;
rcall	clr_r1_to_r15
;-----------------------------------------------------------
;normalizing value in (r21:r25) i.e. shift data string to
;utmost	left to	move msb into  r25.7.
;the number of neccessary shifts is logged in register r2
clr		r2
inc		r2
arl2:
sbrc	r25,7		;skip if bit r21.7 = 0 ( r21 = MSB )
rjmp	arl1		;
rcall	shiftl		;shift divisor	left by	1 bit.
inc		r2
brne	arl2		;repeat until bit = 1 or counter overflow.
clr		r2			;r2 = 0ffh / division by zero
dec		r2
;-----------------------------------------------------------
arl1:
rcall	sub_r21_r25_from_r16_r20	
brcs	arl1_x1						;if c = 1 goto	arl1_x1
sec									;c = 1
rjmp	arl_shift
arl1_x1:
rcall	add_r21_r25_to_r16_r20		;result was negative
clc									;c = 0
;---------------------------------------------------------------
arl_shift:
;shift result bit into result registers	 r14 - r11
;rotate	left r14 - r11 by one bit.
rol		r11
rol		r12
rol		r13
rol		r14
rol		r15
;---------------------------------------------------------------
;shift divisor r25 - r21 right by 1 bit
clc
ror		r25
ror		r24
ror		r23
ror		r22
ror		r21
;---------------------------------------------------------------
dec		r2			;decrement loop counter
brne	arl1
clr		r15
mov		r16,r11
mov		r17,r12
mov		r18,r13
mov		r19,r14
mov		r20,r15
ret
;-----------------
mov_r6_r10_to_r16_r20:
mov		r16,r6
mov		r17,r7
mov		r18,r8
mov		r19,r9
mov		r20,r10
ret
;-----------------
mov_r16_r20_to_r21_r25:
mov		r21,r16
mov		r22,r17
mov		r23,r18
mov		r24,r19
mov		r25,r20
ret
;-----------------
mov_r16_r20_to_r11_r15:
mov		r11,r16
mov		r12,r17
mov		r13,r18
mov		r14,r19
mov		r15,r20
ret
;-----------------
mov_r16_r20_to_r6_r10:
mov		r6,r16
mov		r7,r17
mov		r8,r18
mov		r9,r19
mov		r10,r20
ret
;-----------------
clr_r16_to_r20:
clr		r16
clr		r17
clr		r18
clr		r19
clr		r20
ret
;-----------------
clr_r1_to_r15:
clr		r11
clr		r12
clr		r13
clr		r14
clr		r15
ret
;---------------------------------------------------------------
;---------------------------------------------------------------
;---------------------------------------------------------------
;---------------------------------------------------------------
dez_to_bin_short:
;Max-wert = 9 999 dez
;dezimalzahl in (r16:r17). 
;binary in (r16:r17).
 
mov		r6,r16
mov		r7,r17
 
clr		r16
clr		r17

ldi		xl,$0a			;load xl with register r10 (= $0a)
clr		xh
ldi		zh,high(2*tab_hex_short)
ldi		zl,low(2*tab_hex_short)
ldi		yl,2			;loop-counter set to 2 loops
slptabx:
;--------------------
rcall	load_tab_hex_short;1 000 - 00 00 03 E8 hex
ld		r5,x
mov		r4,r5
swap	r4
rcall	add_allshort
;---------------------
rcall	load_tabx	
mov		r4,r5
rcall	add_allshort
;---------------------
ld		r5,-x		;decrement to next lower d-register
dec		yl			;decrement loop-counter
brne	slptabx
ret
;---------------------
add_allshort:
push	r26
mov		r26,r4
andi	r26,$0f
breq	seax2
seax1:
add		r16,r21
adc		r17,r22
dec		r26
breq	seax2
rjmp	seax1
seax2:
pop		r26
ret
;---------------------------------------------------------------
;---------------------------------------------------------------
load_tab_hex_short:
lpm		    	;load byte from program memory into	r0
mov		r21,r0	;load r21 with byte from program memory
adiw	zl,1	;increase z-register

lpm		    	;load byte from program memory into	r0
mov		r22,r0	;load r22 with byte from program memory
adiw	zl,1	;increase z-register
clr		r25
ret

;---------------------------------------------------------------
;---------------------------------------------------------------
;---------------------------------------------------------------


