'Programm ......... : Steuerung Hebeanlage
'
'Programminhalt ... : - Pumpenansteuerung entsprechend dem Fllstand
'                     - Fehlerausgabe optisch und akustisch
'
'
'
'Programmierer .... : Ingolf Bauer (ingolf.bauer@nexgo.de)
'Version .......... : V 2.0
'Datum ............ : 28.12.2014
'
'-------------------------------------------------------------------------------
'
'Simulator-Einstellmglichkeit
'-----------------------------
'$sim                                              'Wartezeit aus
'
' Achtung!
' Diese Zeile unbedingt auskommentieren, bevor der AVR programmiert wird, da
' sonst der AVR nicht korrekt arbeitet.
'
'-------------------------------------------------------------------------------
'
'Versionsbersicht
'-----------------
'
'
'
'
'
'
'
'
'
'
'
'
'
'V 2.0 28.12.2014 - nderung .... : - Fllstandskontakte schalten Masse
'*******************************************************************************
'V 0.2 19.08.2013 - Information . : - Vorabversion fertiggestellt
'V 0.1 13.08.2013 - Information . : - Beginn der Softwareentwicklung
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'
'Programmspeicher des MCs (Programm-Flashspeicher): V 2.0 - 21%
'
'-------------------------------------------------------------------------------
'
'Informationen zur Software
'--------------------------
' Inhalt                                          | Zeile | Korrekturwert
'------------------------------------------------------------------------
' 00. Allgemeine Informationen .................. |    80
'      Taktfrequenz ............................. |    81
'      Programmierung ........................... |    84
' 01. Abkrzungsbersicht ....................... |    87
' 02. Compilereinstellungen ..................... |    91
' 03. Funktionsbeschreibung ..................... |   102
'      Allgemeines .............................. |   104
'      Tastaturbelegung ......................... |   128
' 04. Interrupt ................................. |   139
' 05. Einstellung der FUSE- und/oder LOOK-Bits .. |   144
' 06. Anschluschema fr den AVR (ATmega8) ...... |   179
' 07. Belegung .................................. |   204
' 08. Steckverbinder ............................ |   275
' 09. Definition ................................ |   286
' 10. Deklaration ............................... |   300
' 11. I/O-Ports Konfiguration ................... |   334
' 12. Alias ..................................... |   361
' 13. Konfiguration ADC, Timer, Watchdog ........ |   386
' 14. Interrupt Konfiguration ................... |   434
' 15. Initialisierung ........................... |   444
' 50. Programm .................................. |   484
' 60. Unterprogramm ............................. |   602
' 70. Interruptroutine .......................... |   629
'
'-------------------------------------------------------------------------------
'
'00. Allgemeine Informationen
'----------------------------
' - Taktfrequenz
'   Als Taktfrequenz wir eine Quarzfrequenz von 4,0 MHz verwendet.
'
' - Programmierung
'   Die Programmierung erfolgt ber den Steckverbinder X2.
'
'01. Abkrzungsbersicht
'-----------------------
'[-]
'
'02. Compilereinstellungen
'-------------------------
' Vor dem Compilieren sind im Programm oder im Men (Compiler-Chip) folgende
' Parameter einzustellen:
'  Men ....... : HW Stack [48]   SW Stack [24]   Framesize [16]
'  Programm ... : <$hwstack>      <$swstack>      <$framesize>
'
' Es kommt sonst zu undefinierten Sprngen, falschen Anzeigen u. . Dingen, wo-
' ran man beim Testen des Programms schnell verzweifeln kann.
' Auerdem mu auf die genaue Angabe des Chips (M8) geachtet werden.
'
'03. Funktionsbeschreibung
'-------------------------
' - Allgemeines
'   Stromversorgung
'    Sie kann ber die Klemmenleiste X1 mit P12 V oder mit P5/P12 V eingespeist
'    werden. Bei der einspeisung ber eine duale Stromversorgung darf der Fest-
'    spannungsregler IC3 nicht sbestckt werden.
'    Verfgt die duale Stromversorgung ber einen DIN-Ministecker, kann die ent-
'    sprechende Buchse auf der Platine genutzt werden. Auf die korrekte Polari-
'    tt ist zu achten.
'
'   Anzeige (optisch)
'    Die Steuerung ist fr den Anschluss einer RGB-LED ausgelegt, die ber eine
'    gemeinsame Katode verfgt.
'    Wird eine LED mit einer gemeinsamen Anode verwendet, ist der LED-Jumper
'    umzustecken und die Software anzupassen.
'    Farbcodierung:
'    - gelb 3x blinken ...... : Programm wurde neu gestartet
'    - grn 1x blitzen ...... : Normalsbetrieb
'    - blau    Dauerlicht ... : Pumpe arbeitet
'    - rot     Dauerlicht ... : Fehler (berlauf, Pumpenstrom zu gering)
'
'   Anzeige (akustisch)
'    Bei einem schweren Fehler (kein Abpumpen, Pumpenstrom zu gering) erfolgt
'    ein Warnton.

' - Tastaturbelegung
'   ~~~~~~~~~~~~~~~~
'   Normalbetrieb
'   - - - - - - -
'   Taste 1: Pumpe kann manuell eingeschaltet werden
'
'   Fehler
'   - - -
'   Taste 1: Die akustische Fehlersignalisierung wird abgeschaltet und nach
'            nach 30 Sekunden das Programm neu gestartet.
'
'04. Interrupt
'-------------
' - bersicht
'   Timer 1: 16 Bit, Interrupt bei Timer-berlauf (Zeittakt 10 ms bereitstellen)
'
'05. Einstellung der FUSE- und/oder LOOK-Bits
'--------------------------------------------
' Einstellungen beim USBasp-Programmer
' Name              MEGA8
'   Calibration 0     AF
'   Calibration 1     AD
'   Calibration 2     A7
'   Calibration 3     A7
' * Lockbits          FF
'    Lockbit 65         11: No restrictions for SPM or LPM accessing ...
'    Lockbit 43         11: No restrictions for SPM or LPM accessing ...
'    Lockbit 21         11: No memory lock features enabled for parallel ...
' * Fusebits          ED
'    Fusebit C           1: BODLEVEL 2.7V
'    Fusebit B           1: BODEN disabled
'    Fusebit KLA987     101101: Ext. Crystel/Resonator Medium Freq.
' * Fusebits Hight    D0
'    Fusebit High M      1: PIN PC6 is RESET
'    Fusebit High J      0: WDT enabled by WDTCR
'    Fusebit High I      0: SPI enabled
'    Fusebit High H      1: CKOPT 1
'    Fusebit High G      0: Preserve EEPROM when chip erase
'    Fusebit High FE    00: 1024 word boot size, C00'
'    Fusebit High D      0: Reset svector ist boot loader reset
'
' Achtung
' =======
' - CKSEL
'   Wird CKSEL3= 0 gesetzt, arbeitet der MC nur noch mit einem externen RC-
'   Generator [f= 1/(3RC); C>= 22p].
'
' - RSTDISBL
'   Wird RSTDISBL= 1 gesetzt, ist mit einfachen Brennern kein Programmieren
'   mehr mglich, da dafr die Reset-Funktion unbedingt erforderlich ist.
'
'06. Anschluschema fr den AVR (ATmega8)
'----------------------------------------
'
'                      --------------|_|--------------
' [1]        /RES ---> | 1 [/Reset]    [ADC5, PC5] 28| ---> SIG        [0]
' [x]        FS_1 ---> | 2 [PD0, RXD]  [ADC4, PC4] 27| <--- PUM_I
' [x]        FS_2 ---> | 3 [PD1, TXD]  [ADC3, PC3] 26| ---> PUM        [0]
' [0]         T_1 ---> | 4 [PD2, INT0] [ADC2, PC2] 25| ~~~~ AS_C2
'           AS_D3 ~~~~ | 5 [PD3, INT1] [ADC1, PC1] 24| ~~~~ AS_C1
'           AS_D4 ~~~~ | 6 [PD4, T0]   [ADC0, PC0] 23| ~~~~ AS_C0
'             P5V ==== | 7 [VCC]            [AGND] 22| ==== GND
'             GND ==== | 8 [GND]            [AREF] 21| ==== P5V
'              QZ ++++ | 9 [XT1]            [AVCC] 20| ==== P5V
'              QZ ++++ |10 [XT2]         [SCK,PB5] 19| <--- SCK        [0]
'           AS_D5 ~~~~ |11 [PD5, T1]    [MISO,PB4] 18| <--- MISO       [0]
'           AS_D6 ~~~~ |12 [PD6, AIN0]  [MOSI,PB3] 17| ---> MOSI       [0]
'           AS_D7 ~~~~ |13 [PD7, AIN1]  [/SS, PB2] 16| ---> LED_B      [0]
' [0]       LED_R <--- |14 [PB0, ICP]   [OC1, PB1] 15| ---> LED_G      [0]
'                      -------------------------------
'
' Werte in []: Einstellungen nach dem Programmstart
'  0: aus
'  1: ein
'  x: hngt vom Einschaltzustand ab
'
'07. Belegung
'------------
' Prfix                       Suffix
'----------------------------------------------------------
' A_   : Ausgang
' AS_  : Adapterstecker        C0 - D7 : Port C, Port D
' FS_  : Fllstand             1, 2    : Sensoren 1, 2
' LED_ : LED                   R, G, B : Farbe rt, gn, bl
' PUM_ : Pumpe                 -, I    : Ausgang, Motorstrom
' SIG  : Signaltongeber
' T_   : Taste                 1       : Bedienung
' /RES : Resetfunktion

'Stromversorgung
'- - - - - - - -
' P5V  : Stromversorgung (5 V)
' GND  : Stromversorgung (Masse)
'
'Programmierung
'- - - - - - -
' MISO : Daten
' MOSI : Daten
' SCK  : Takt

'Takterzeugung
'- - - - - - -
' QZ   : Quarz

'bersicht
'---------
'           Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -   : SV  P5V ........ | ............. | Stromversorgung .............. |  7
' -   : SV  GND ........ | ............. | Stromversorgung .............. |  8
' -   : PRG /RESET ..... | ............. | Reset des MCs ................ |  1
' -   : QZ  Frequenz ... | ............. | Frequenznormal mit Quarz ..... |  9
' -   : QZ  Frequenz ... | ............. | Frequenznormal mit Quarz ..... | 10
'
'Port B     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: DA  LED rot .... | LED_R ....... | Wannenstecker 4 .............. | 14
' - .1: DA  LED grn ... | LED_G ....... | Wannenstecker 6 .............. | 15
' - .2: DA  LED blau ... | LED_B ....... | Wannenstecker 8 .............. | 16
' - .3: PRG MOSI ....... | MOSI ........ | Programmierung ............... | 17
' - .4: PRG MISO ....... | MISO ........ | Programmierung ............... | 18
' - .5: PRG SCK ........ | SCK ......... | Programmierung ............... | 19
' - nc: ................ | ............. | .............................. | nc
' - nc: ................ | ............. | .............................. | nc
'
'Port C     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0:     (frei) ..... | AS_C0 ....... | Leiterplattenstecker 1 ....... | 23
' - .1:     (frei) ..... | AS_C1 ....... | Leiterplattenstecker 2 ....... | 24
' - .2:     (frei) ..... | AS_C2 ....... | Leiterplattenstecker 3 ....... | 25
' - .3: DA  Pumpe ...... | PUM ......... | Pumpenmotor .................. | 26
' - .4: AE  Sensor ..... | PUM_I ....... | Stromermittlung .............. | 27
' - .5: DA  Signalton .  | SIG ......... | akustische Signalisierung .... | 28
' - nc: ................ | ............. | .............................. | nc
' - nc: ................ | ............. | .............................. | nc
'
'Port D     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: DE Fllstand 1 . | FS_1 ........ | Sensor 1 ..................... |  2
' - .1: DE Fllstand 2 . | FS_2 ........ | Sensor 2 ..................... |  3
' - .2: DE Taste 1 ..... | T_1 ......... | Bedienung 1 .................. |  4
' - .3:    (frei) ...... | AS_D3 ....... | Wannenstecker 1 .............. |  5
' - .4:    (frei) ...... | AS_D4 ....... | Wannenstecker 3 .............. |  6
' - .5:    (frei) ...... | AS_D5 ....... | Wannenstecker 5 .............. | 11
' - .6:    (frei) ...... | AS_D6 ....... | Wannenstecker 7 .............. | 12
' - .7:    (frei)....... | AS_D7 ....... | Wannenstecker 9 .............. | 13
'
'08. Steckverbinder
'==================
' X 1: Stromversorgung (extern)           Klemmenleiste/Buchse (DC: 5V/12V)
' X 2: Programmer      (extern)           Wannensteckverbinder (10-polig)
' X 3: Erweiterung     (extern)           Wannensteckverbinder (10-polig)
' X 4: LED             (intern)           Leiterplattenbuchse
' X 5: COM             (intern)           Polarittsumsschalter
' X 6: Erweiterung     (extern)           Leiterplattenbuchse
'
'-------------------------------------------------------------------------------
'
'09. Definition
'--------------
'
'Allgemein
   $regfile = "m8adef.dat"                        'Prozessor ....... : ATmega8
   $crystal = 4000000                             'Quarzfrequenz ... : 4,0 MHz

'Einstellungen
   $hwstack = 64                                  'Hardwarestack
   $swstack = 48                                  'Softwarestack
   $framesize = 32                                'Framespace
'
'-------------------------------------------------------------------------------
'
'10. Deklaration
'---------------
'Konstante
   Dim T1_tve As Word                             'Voreinstellwert T1
   Dim Pum_min As Word                            'Minimum Pumpenstrom
   Dim Pum_max As Word                            'Pumpenlaufzeit (Maximalzeit)
   Dim Pum_nor As Word                            'Pumpenlaufzeit (normal)
   Dim Pum_war As Byte                            'Wartezeit bis zum Starten
   Dim Pum_anl As Byte                            'Anlaufzeit (Strom)

'Sensoren (mit ADC auslesen)
   Dim Pum_i As Word                              'ADC-Kanal 4: Pumpen-Strom

'Fehler
   Dim Err_pum As Bit                             'Pumpe
   Dim Err_fs As Bit                              'Fllstand

'Flag
   Dim F_pum As Bit                               'Pumpe
   Dim F_sig As Bit                               'Signalton
   Dim F_fs As Bit                                'Fllstand
   Dim F_ein As Bit                               'Steuerung ein

'Zhler
   Dim Z_hz1 As Byte                              'Hilfszhler 1
   Dim Z_sig As Byte                              'Signalton
   Dim Z_pun As Word                              'Pumpenlaufzeit normal
   Dim Z_pum As Word                              'Pumpenlaufzeit maximum
   Dim Z_ein As Byte                              'Steuerung ein
   Dim Z_puw As Byte                              'Wartezeit bis zum Starten
   Dim Z_anl As Byte                              'Anlaufzeit (Strom)
'
'-------------------------------------------------------------------------------
'
'11. I/O-Ports Konfiguration
'---------------------------
'
'= Port B
'- Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrb = &B0000_0111                             'Ein: 3-7        Aus: 0-2
'- Pullup-Widerstand (passiv [0], aktiv [1])
   Portb = &B0000_0000                            'pas: 0-7

'= Port C
'- Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrc = &B0010_1000                             'Ein: 0,1,2,4    Aus: 3,5
'- Pullup-Widerstand (passiv [0], aktiv [1])
   Portc = &B0000_0111                            'pas: 3-7        akt: 0-2

'= Port D
'- Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrd = &B0000_0000                             'Ein: 0-7        Aus: 7
'- Pullup-Widerstand (passiv [0], aktiv [1])
   Portd = &B1111_1100                            'akt: 2-7        pas: 0,1
'
'Abkrzungen fr die Pullup-Widerstnde
' Ein: Eingang      akt: aktiv
' Aus: Ausgang      pas: passiv
'
'-------------------------------------------------------------------------------
'
'12. Alias
'---------
'Hinweis: Nur die benutzen Kanle werden bezeichnet.
'
'-Kanal B:
' Ausgnge
   Led_r Alias Portb.0                            'Kanal B [DA]: B.0
   Led_g Alias Portb.1                            'Kanal B [DA]: B.1
   Led_b Alias Portb.2                            'Kanal B [DA]: B.2

'-Kanal C:
' Eingnge
'  Pum_i (Kanal 4 analog)                         'Kanal D [AE]
'  Ausgnge
   Pum Alias Portc.3                              'Kanal C [DA]: C.3
   Sig Alias Portc.5                              'Kanal C [DA]: C.5
'
'-Kanal D:
' Eingnge
   Fs1 Alias Pind.0                               'Kanal D [DE]: D.0
   Fs2 Alias Pind.1                               'Kanal D [DE]: D.1
   T1 Alias Pind.2                                'Kanal D [DE]: D.2
'
'-------------------------------------------------------------------------------
'
'13.  Konfiguration
'~~~~~~~~~~~~~~~~~~
'13.1 Analog/Digital Konverter
'-----------------------------
'-Prescaler (Frequenzteiler durch 2, 4, 8, 16, 32, 64, 128)
'-ADC bentigt eine Frequenz von 50-200 kHz
'-Modus <AUTO>: hchstmgliche Frequenz wird gewhlt
'-interne Referenzspannungsquelle (2,56 V) nutzen
'-ADC erst starten, wenn Programm in die Schleife kommt!
   Config Adc = Single , Prescaler = Auto , Reference = Internal
'
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'
'13.2 Timer Konfiguration
'------------------------
'Normal-Konfiguration (Zeitbasis fr Kodierung; 1-8-64-256-1024)
'PSC: Prescale; TZW: Timerzhlwert; TVE: Timervoreinstellwert
'       | ATmega 8   |
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' 8 bit | Timer 0, 2 |
'16 bit | Timer 1    |
'
'Berechnung der Zeitbasis:
' bei 4 MHz-Quarz Timer 1 (16 bit) verwenden
'-------------------------------------------
' T1 = 1/ Quarz * Teiler  * Voreinstellwert
'                     PSC   TZW
'    = 1/  4,0 MHz * 1024 *  390 = 100 ms (0,09984 s)
'
' bei 1 MHz-Quarz Timer 0 ( 8 bit) verwenden
'-------------------------------------------
' T0 = 1/ Quarz * Teiler  * Voreinstellwert
'                     PSC   TZW
'    = 1/  1,0 MHz * 1024 *  98 = 100 ms (0,100352 s)
'
'                                                          TVE
' Timer ( 8 Bit) voreinstellen auf Wert:    256 - TZW =    158 (fr ca. 100 ms)
' Timer (16 Bit) voreinstellen auf Wert: 65.536 - TZW = 65.146 (fr ca. 100 ms)
'
   Config Timer1 = Timer , Prescale = 1024        'Konfiguration
'
'13.3 Watchdog Konfiguration
'---------------------------
   Config Watchdog = 2048
   Start Watchdog
'
'-------------------------------------------------------------------------------
'
'14. Interrupt Konfiguration
'---------------------------
'
   Enable Timer1                                  'Interrupt : Timer 1
      On Timer1 Int_tim1                          ' Timer 1  : berlauf

   Enable Interrupts                              'Interrupts: global zulassen
'
'-------------------------------------------------------------------------------
'
'15. Initialisierung
'-------------------
'Festwerte
'- - - - -
'-Timer
   T1_tve = 65146                                 'Timer1: VEW fr 0,1 s
'-Pumpe
' Strom (Minimalwert 55 wurde durch Versuche ermittelt, ggf. muss er der jewei-
'        liegen Pumpe angepasst werden)
'03.04.2014: Wert auf 50 erhht, Anlaufzeit eingefgt
'30.04.2014: Wert von 45 auf 35 reduziert
'04.03.2014: Wert von 55 auf 45 reduziert
   Pum_min = 50                                   'Minimum Pumpenstrom
' Nachlaufzeit
' Die Zeit, die die Pumpe nachluft, wenn der Kontakt fr den Fllstand den
' normalen Pegel anzeigt.
' Kann der Fllstand durch das Abpumpen nicht verringert werden, wird nach Er-
' reichen der "Maximallaufzeit" die Pumpe abgeschaltet und ein Fehler ausge-
' gegeben.
   Pum_nor = 200                                  '200x 0,1 s= 20 s (0'20'')
' Maximallaufzeit
' Whrend dieser Zeit muss sich der Fllstand soweit verringert haben, dass
' die Kontakte schalten und die Pumpe abgeschaltet wird.
' Diese Zeit wurde nach Einbau des Rckschlagventils erhht, da dadurch die
' Frderleistung zurckgegangen ist.
' Bedingt durch einen zu hohen Wasser-Nachlauf kann diese Zeit ggf. nicht aus-
' reichen.
   Pum_max = 1200                                 '1200x 0,1 s= 180 s (2'00'')
' Wartezeit bis zum Starten des Abpumpens
   Pum_war = 30                                   ' 30x 0,1 s=  3 s
' Whrend der Anlaufzeit wird der Pumpenstrom nicht berwacht.
   Pum_anl = 100                                  '100x 0,1 s= 10 s

'Startbedingungen
'- - - - - - - -
'-Timer
   Timer1 = T1_tve                                'Initialisierung beim MC-Start
'
'-------------------------------------------------------------------------------
'
'50. Programm
'------------
'Programm startet (LED_weis)
   For Z_hz1 = 1 To 3
      Led_r = 0 : Led_g = 0 : Led_b = 0           'SET LED_wei
      Waitms 50
      Led_r = 1 : Led_g = 1 : Led_b = 1           'RES LED_wei
      Waitms 500
   Next Z_hz1
   Wait 3

'Programmzyklus
'--------------
Do
'Tastenabfrage
'-------------
'-Rcksetzung des Signalgeberausganges (F_sig), wenn es gesetzt ist
'-Steuerung der Pumpe (Laufzeit entspricht der Tastenbettigung)
   If T1 = 0 Then
      Waitms 20                                   'Entprellzeit
      Sig = 1 : Waitms 10 : Sig = 0               'Tastenklick
Mta_1:
      If T1 = 0 Then
         If F_sig = 1 Or Err_pum = 1 Then         'Fehlersignalisierung wird
            F_sig = 0                             'ausgeschaltet
            F_pum = 0
            Err_pum = 0
M_ta2:
            If T1 = 0 Then
               Led_r = 1 : Led_g = 0 : Led_b = 1  'SET LED_grn
               Goto M_ta2                         'warten, bis Taste gelst
            End If
         Else
            Pum = 1                               'Pumpe direkt einschalten
            Led_r = 1 : Led_g = 1 : Led_b = 0     'SET LED_blau
         End If
'Kontrolle, ob der Pumpenstrom ber dem Mindestwert liegt. Wenn nicht, wird
'die Pumpe ausgeschaltet.
         Gosub Up_pum
         If Err_pum = 1 Then                      'Pumpenfehler abfragen
           Goto Mta_3                             'Pumpe ausschalten
         End If
         Goto Mta_1                               'Halten, solange wie T1=0
      End If
Mta_3:
      Pum = 0                                     'Pumpe ausschalten
      Led_b = 1                                   'LED_blau ausschalten
      If T1 = 0 Then
         Goto Mta_3                               'Warten, bis Taste gelst ist,
      End If                                      'wenn "F_sig" aktiv war
   End If
M_01:

'Fllstandsermittlung
'--------------------
'Pumpe einschalten, wenn einer der Fllstandskontakte ffnet.
   If Fs1 = 1 Or Fs2 = 1 Then
      Waitms 50                                   'Entprellzeit
      If Fs1 = 1 Or Fs2 = 1 Then
         Set F_fs                                 'SET Fllstand
         Set F_pum                                'SET Flag_Pumpe
      End If
   Else
      Reset F_fs                                  'RESET Fllstand
   End If

'Ende Nachlaufzeit
'-----------------
'Hinweis
'Warum dieser Abschnitt in der Interrupt-Routine fr den Pumpenlauf nicht funk-
'tioniert hat, msste noch untersucht werden.
   If Z_pun > Pum_nor And F_fs = 0 Then
      Reset F_pum                                 'RES Flag_Pumpe
   End If

'Pumpensteuerung
'---------------
   If F_pum = 1 And Err_pum = 0 And Z_puw > Pum_war Then
      Set Pum                                     'Einschalten
'berwachung Pumpenstrom
      Gosub Up_pum
   Else
      Reset Pum                                   'Ausschalten
   End If

'Signalsteuerung
'---------------
   If Err_fs = 1 Or Err_pum = 1 Then              'Fllstand, Pumpe
      Set F_sig                                   'SET Flag_Signalton
   Else
      Reset F_sig                                 'RES Flag_Signalton
      Reset Z_sig                                 'RES Zhler_Signalton
   End If

'Anzeige ber RGB-LED
'--------------------
'Statusanzeigen nur, wenn kein Err_fs oder Err_pum
   If F_sig = 0 Then
'FS aktiv
      If F_fs = 1 And Pum = 0 Then
         Led_r = 0 : Led_g = 1 : Led_b = 0        'SET LED_gelb
         Goto Manz_1
      End If
'Pumpe noch ein
      If Pum = 1 Then
         Led_r = 1 : Led_g = 1 : Led_b = 0        'SET LED_blau
         Goto Manz_1
      End If
'Steuerung ein (ohne Fehler oder einer anderen Signalisierung)
      Set F_ein                                   'Anzeige Steuerung ein
Manz_1:
   Else
      Reset F_ein
   End If

Loop
'
'-------------------------------------------------------------------------------
'60. === U N T E R P R O G R A M M =============================================
'-------------------------------------------------------------------------------
'
'UP: Pumpenstrom ermitteln
Up_pum:
   Start Adc                                      'ADC starten
      Waitms 100                                  'abwarten, bis ADC luft
      Pum_i = Getadc(4)                           'ADC-Kanal 4: Pumpenstrom

      If Pum_i < 10 Then                          'Messfehler ausschalten
         Waitms 200
         Pum_i = Getadc(4)                        'ADC-Kanal 4: Pumpenstrom
      End If
   Stop Adc                                       'ADC stoppen

'Fehler
'Bei laufender Pumpe ist der Pumpenstrom zu gering (Defekt oder Leerlauf).
'Die Auswertung erfolgt erst nach der Anlaufzeit <Pum_anl>.
   If Pum = 1 And Pum_i <= Pum_min And Z_anl >= Pum_anl Then
      Set Err_pum                                 'SET Fehler
      Set F_sig                                   'SET Flag_Signalton
      Reset F_pum                                 'RES Flag_Pumpe
   End If

Return
'
'-------------------------------------------------------------------------------
'70. === I N T E R R U P T R O U T I N E =======================================
'-------------------------------------------------------------------------------
'
'Timer1
'------
'Aufruf alle 100 ms (Taktgeber 10 Hz)
'
Int_tim1:
   Timer1 = T1_tve                                'Timer1: Voreinstellwert
   Reset Watchdog                                 'RES Watchdog

'Signalisierung
'--------------
'Flag=1: Intervall Led_gn
   If F_ein = 1 And F_sig = 0 And T1 = 1 And Pum = 0 And F_fs = 0 Then
      Incr Z_ein
      Select Case Z_ein
         Case 1
            Led_r = 1 : Led_g = 0 : Led_b = 1     'SET LED_grn
         Case 2
            Led_r = 1 : Led_g = 1 : Led_b = 1     'RES LED_grn
         Case Is > 40
            Z_ein = 0
      End Select
   Else
      Z_ein = 0
   End If

'Flag=1: Intervall Led_rt und Signalton
   If F_sig = 1 Then
      Incr Z_sig
      Select Case Z_sig
         Case 1 To 2                              '2x 100 ms= 200 ms
            Sig = 1
            Led_r = 0 : Led_g = 1 : Led_b = 1     'SET LED_rot
         Case 3 To 30
            Sig = 0
            Led_r = 1 : Led_g = 1 : Led_b = 1     'RES LED_rot
         Case Else
            Z_sig = 0                             'Neustart des Zhlers
      End Select
   End If

'Pumpenlaufzeit
'--------------
'Wartezeit bis zum Pumpen
   If F_pum = 1 Then
      Incr Z_puw
      If Z_puw = 251 Then Decr Z_puw              'kein berlauf
   Else
      Z_puw = 0
   End If

'keine Stromberwachung whrend des Anlaufens
' Dazu wird ein Zhler verwendet und erst nach Erreichen der Zeit die Strom-
' berwachung aktiviert.
   If Pum = 1 Then                                'Pumpe aktiviert
      Incr Z_anl                                  'Zeitzhler erhhen
      If Z_anl > Pum_anl Then                     'Begrenzung
         Decr Z_anl
      End If
   Else
      Z_anl = 0                                   'Reset Zeitzhler
   End If

'Zeitberwachung (nur im Automatikbetrieb)
   If T1 = 0 Then Goto M_hb                       'T1= 0: Handbetrieb

   If Pum = 1 Then
      Incr Z_pum                                  'Zhler: maximale Laufzeit
      If F_fs = 0 Then                            'Abpumpen beendet
         Incr Z_pun                               'Nachlaufzeit zhlen
      End If
'Maximale Laufzeit erreicht
      If Z_pum > Pum_max Then
         Reset F_pum                              'RES Flag_Pumpe
         Set Err_pum                              'SET Fehler_Pumpe
      End If
   Else
       Z_pun = 0 : Z_pum = 0                      'RES Zhler Pumpenlaufzeiten
   End If
'Bei Handbetrieb hier weiter
M_hb:

Return

'Programmende
End

'###############################################################################