#include <avr/io.h>			// hier AVR eingefgt
#include <avr/interrupt.h>	// hier AVR eingefgt
#include <util/delay.h>  	// diese Lib eingefgt

#include "mydefs.h"

#define	EA_DOGM162


#define	XTAL	8e6			// 8MHz


#define	LCD_DI		SBIT( PORTB, 2 )
#define	LCD_DDR_DI	SBIT( DDRB, 2 )

#define	LCD_RS		SBIT( PORTD, 4 )
#define	LCD_DDR_RS	SBIT( DDRD, 4 )

#define	LCD_SCK		SBIT( PORTD, 7 )
#define	LCD_DDR_SCK	SBIT( DDRD, 7 )

#define	LCD_CS		SBIT( PORTD, 6 )
#define	LCD_DDR_CS	SBIT( DDRD, 6 )

// hier eingefgt ver

#ifndef _lcd_drv_h_
#define _lcd_drv_h_

#define lcd_text(x)	lcd_text_((u8*)(x))	// avoid char warning

void lcd_command( u8 d );
void lcd_data( u8 d );
void lcd_text_( u8 *t );
void lcd_init( void );
void lcd_pos( u8 line, u8 column );

#endif


